/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import jline.ConsoleReader;
import jline.History;
import jline.Terminal;
import jline.WindowsTerminal;
import junit.framework.TestCase;

public class ConsoleReaderTest
extends TestCase {
    public ConsoleReaderTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        System.setProperty("jline.WindowsTerminal.directConsole", "false");
    }

    public void testDeleteAndBackspaceKeymappings() throws Exception {
        if (!(Terminal.getTerminal() instanceof WindowsTerminal)) {
            return;
        }
        ConsoleReader consoleReader = new ConsoleReader();
        ConsoleReaderTest.assertNotNull((Object)consoleReader);
        ConsoleReaderTest.assertEquals((int)127, (int)consoleReader.getKeyForAction((short)-56));
        ConsoleReaderTest.assertEquals((int)8, (int)consoleReader.getKeyForAction((short)-41));
    }

    public void testReadline() throws Exception {
        ConsoleReader consoleReader = this.createConsole("Sample String\r\n".getBytes());
        ConsoleReaderTest.assertNotNull((Object)consoleReader);
        String line = consoleReader.readLine();
        ConsoleReaderTest.assertEquals((String)"Sample String", (String)line);
    }

    public void testDeleteOnWindowsTerminal() throws Exception {
        if (!(Terminal.getTerminal() instanceof WindowsTerminal)) {
            return;
        }
        char[] characters = new char[]{'S', 's', '\u00e0', 'K', '\u00e0', 'S', '\r', 'n'};
        this.assertWindowsKeyBehavior("S", characters);
    }

    public void testNumpadDeleteOnWindowsTerminal() throws Exception {
        if (!(Terminal.getTerminal() instanceof WindowsTerminal)) {
            return;
        }
        char[] characters = new char[]{'S', 's', '\u0000', 'K', '\u0000', 'S', '\r', 'n'};
        this.assertWindowsKeyBehavior("S", characters);
    }

    public void testHomeKeyOnWindowsTerminal() throws Exception {
        if (!(Terminal.getTerminal() instanceof WindowsTerminal)) {
            return;
        }
        char[] characters = new char[]{'S', 's', '\u00e0', 'G', 'x', '\r', '\n'};
        this.assertWindowsKeyBehavior("xSs", characters);
    }

    public void testEndKeyOnWindowsTerminal() throws Exception {
        if (!(Terminal.getTerminal() instanceof WindowsTerminal)) {
            return;
        }
        char[] characters = new char[]{'S', 's', '\u00e0', 'G', 'x', '\u00e0', 'O', 'j', '\r', '\n'};
        this.assertWindowsKeyBehavior("xSsj", characters);
    }

    public void testPageUpOnWindowsTerminal() throws Exception {
        if (!(Terminal.getTerminal() instanceof WindowsTerminal)) {
            return;
        }
        char[] characters = new char[]{'\u00e0', 'I', '\r', '\n'};
        this.assertWindowsKeyBehavior("dir", characters);
    }

    public void testPageDownOnWindowsTerminal() throws Exception {
        if (!(Terminal.getTerminal() instanceof WindowsTerminal)) {
            return;
        }
        char[] characters = new char[]{'\u00e0', 'Q', '\r', '\n'};
        this.assertWindowsKeyBehavior("mkdir monkey", characters);
    }

    public void testEscapeOnWindowsTerminal() throws Exception {
        if (!(Terminal.getTerminal() instanceof WindowsTerminal)) {
            return;
        }
        char[] characters = new char[]{'s', 's', 's', '\u00e0', '\u0000', '\r', '\n'};
        this.assertWindowsKeyBehavior("", characters);
    }

    public void testInsertOnWindowsTerminal() throws Exception {
        if (!(Terminal.getTerminal() instanceof WindowsTerminal)) {
            return;
        }
        char[] characters = new char[]{'o', 'p', 's', '\u00e0', 'G', '\u00e0', 'R', 'o', 'o', 'p', 's', '\r', '\n'};
        this.assertWindowsKeyBehavior("oops", characters);
    }

    private void assertWindowsKeyBehavior(String expected, char[] input) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append(input);
        ConsoleReader reader = this.createConsole(buffer.toString().getBytes());
        ConsoleReaderTest.assertNotNull((Object)reader);
        String line = reader.readLine();
        ConsoleReaderTest.assertEquals((String)expected, (String)line);
    }

    private ConsoleReader createConsole(byte[] bytes) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        StringWriter writer = new StringWriter();
        ConsoleReader reader = new ConsoleReader(in, writer);
        reader.setHistory(this.createSeededHistory());
        return reader;
    }

    private History createSeededHistory() {
        History history = new History();
        history.addToHistory("dir");
        history.addToHistory("cd c:\\");
        history.addToHistory("mkdir monkey");
        return history;
    }
}

