/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.hamcrest.generator.qdox.JavaClassContext;
import org.hamcrest.generator.qdox.model.AbstractBaseJavaEntity;
import org.hamcrest.generator.qdox.model.AbstractJavaEntity;
import org.hamcrest.generator.qdox.model.Annotation;
import org.hamcrest.generator.qdox.model.ClassLibrary;
import org.hamcrest.generator.qdox.model.DefaultDocletTagFactory;
import org.hamcrest.generator.qdox.model.DocletTag;
import org.hamcrest.generator.qdox.model.DocletTagFactory;
import org.hamcrest.generator.qdox.model.JavaClass;
import org.hamcrest.generator.qdox.model.JavaClassParent;
import org.hamcrest.generator.qdox.model.JavaField;
import org.hamcrest.generator.qdox.model.JavaMethod;
import org.hamcrest.generator.qdox.model.JavaPackage;
import org.hamcrest.generator.qdox.model.JavaParameter;
import org.hamcrest.generator.qdox.model.JavaSource;
import org.hamcrest.generator.qdox.model.Type;
import org.hamcrest.generator.qdox.model.TypeVariable;
import org.hamcrest.generator.qdox.model.annotation.AnnotationFieldRef;
import org.hamcrest.generator.qdox.model.annotation.RecursiveAnnotationVisitor;
import org.hamcrest.generator.qdox.parser.Builder;
import org.hamcrest.generator.qdox.parser.structs.ClassDef;
import org.hamcrest.generator.qdox.parser.structs.FieldDef;
import org.hamcrest.generator.qdox.parser.structs.MethodDef;
import org.hamcrest.generator.qdox.parser.structs.PackageDef;
import org.hamcrest.generator.qdox.parser.structs.TagDef;
import org.hamcrest.generator.qdox.parser.structs.TypeDef;
import org.hamcrest.generator.qdox.parser.structs.TypeVariableDef;

public class ModelBuilder
implements Builder {
    private final JavaClassContext context;
    private final JavaSource source;
    private JavaClassParent currentParent;
    private JavaClass currentClass;
    private JavaMethod currentMethod;
    private List currentAnnoDefs;
    private String lastComment;
    private List lastTagSet;
    private DocletTagFactory docletTagFactory;

    public ModelBuilder() {
        this(new JavaClassContext(new ClassLibrary()), new DefaultDocletTagFactory(), new HashMap());
    }

    public ModelBuilder(JavaClassContext javaClassContext, DocletTagFactory docletTagFactory, Map map) {
        this.context = javaClassContext;
        this.docletTagFactory = docletTagFactory;
        this.source = new JavaSource(javaClassContext);
        this.currentParent = this.source;
        this.currentAnnoDefs = new ArrayList();
    }

    @Override
    public void addPackage(PackageDef packageDef) {
        JavaPackage javaPackage = this.context.getPackageByName(packageDef.name);
        if (javaPackage == null) {
            javaPackage = new JavaPackage(packageDef.name);
            this.context.add(javaPackage);
        }
        javaPackage.setLineNumber(packageDef.lineNumber);
        this.setAnnotations(javaPackage);
        this.source.setPackage(javaPackage);
    }

    @Override
    public void addImport(String string) {
        this.source.addImport(string);
    }

    @Override
    public void addJavaDoc(String string) {
        this.lastComment = string;
        this.lastTagSet = new LinkedList();
    }

    @Override
    public void addJavaDocTag(TagDef tagDef) {
        this.lastTagSet.add(tagDef);
    }

    @Override
    public void beginClass(ClassDef classDef) {
        this.currentClass = new JavaClass();
        this.currentClass.setLineNumber(classDef.lineNumber);
        this.currentClass.setName(classDef.name);
        this.currentClass.setInterface("interface".equals(classDef.type));
        this.currentClass.setEnum("enum".equals(classDef.type));
        this.currentClass.setAnnotation("@interface".equals(classDef.type));
        if (this.currentClass.isInterface()) {
            this.currentClass.setSuperClass(null);
        } else if (!this.currentClass.isEnum()) {
            this.currentClass.setSuperClass(classDef.extendz.size() > 0 ? this.createType((TypeDef)classDef.extendz.toArray()[0], 0) : null);
        }
        Object[] objectArray = this.currentClass.isInterface() ? classDef.extendz : classDef.implementz;
        Iterator iterator = objectArray.iterator();
        Type[] typeArray = new Type[objectArray.size()];
        for (int i = 0; i < typeArray.length && iterator.hasNext(); ++i) {
            typeArray[i] = this.createType((TypeDef)iterator.next(), 0);
        }
        this.currentClass.setImplementz(typeArray);
        objectArray = new String[classDef.modifiers.size()];
        classDef.modifiers.toArray(objectArray);
        this.currentClass.setModifiers((String[])objectArray);
        if (classDef.typeParams != null) {
            objectArray = new TypeVariable[classDef.typeParams.size()];
            int n = 0;
            for (TypeVariableDef typeVariableDef : classDef.typeParams) {
                objectArray[n++] = this.createTypeVariable(typeVariableDef);
            }
            this.currentClass.setTypeParameters((TypeVariable[])objectArray);
        }
        this.addJavaDoc(this.currentClass);
        this.setAnnotations(this.currentClass);
        this.currentParent.addClass(this.currentClass);
        this.currentParent = this.currentClass;
        this.context.add(this.currentClass.getFullyQualifiedName());
    }

    @Override
    public void endClass() {
        this.currentParent = this.currentClass.getParent();
        this.currentClass = this.currentParent instanceof JavaClass ? (JavaClass)this.currentParent : null;
    }

    @Override
    public Type createType(String string, int n) {
        if (string == null || string.equals("")) {
            return null;
        }
        return this.createType(new TypeDef(string), n);
    }

    @Override
    public Type createType(TypeDef typeDef) {
        return this.createType(typeDef, 0);
    }

    public Type createType(TypeDef typeDef, int n) {
        if (typeDef == null) {
            return null;
        }
        return Type.createUnresolved(typeDef, n, this.currentClass == null ? this.currentParent : this.currentClass);
    }

    private void addJavaDoc(AbstractJavaEntity abstractJavaEntity) {
        if (this.lastComment == null) {
            return;
        }
        abstractJavaEntity.setComment(this.lastComment);
        Iterator iterator = this.lastTagSet.iterator();
        ArrayList<DocletTag> arrayList = new ArrayList<DocletTag>();
        while (iterator.hasNext()) {
            TagDef tagDef = (TagDef)iterator.next();
            arrayList.add(this.docletTagFactory.createDocletTag(tagDef.name, tagDef.text, abstractJavaEntity, tagDef.lineNumber));
        }
        abstractJavaEntity.setTags(arrayList);
        this.lastComment = null;
    }

    public void addMethod(MethodDef methodDef) {
        this.beginMethod();
        this.endMethod(methodDef);
    }

    @Override
    public void beginMethod() {
        this.currentMethod = new JavaMethod();
        this.setAnnotations(this.currentMethod);
    }

    @Override
    public void endMethod(MethodDef methodDef) {
        int n;
        Object[] objectArray;
        this.currentMethod.setParentClass(this.currentClass);
        this.currentMethod.setLineNumber(methodDef.lineNumber);
        this.currentMethod.setName(methodDef.name);
        this.currentMethod.setReturns(this.createType(methodDef.returnType, methodDef.dimensions));
        this.currentMethod.setConstructor(methodDef.constructor);
        if (methodDef.typeParams != null) {
            objectArray = new TypeVariable[methodDef.typeParams.size()];
            n = 0;
            for (TypeVariableDef typeVariableDef : methodDef.typeParams) {
                objectArray[n++] = this.createTypeVariable(typeVariableDef);
            }
            this.currentMethod.setTypeParameters((TypeVariable[])objectArray);
        }
        objectArray = new Type[methodDef.exceptions.size()];
        n = 0;
        Iterator iterator = methodDef.exceptions.iterator();
        while (iterator.hasNext()) {
            objectArray[n++] = this.createType((String)iterator.next(), 0);
        }
        this.currentMethod.setExceptions((Type[])objectArray);
        objectArray = new String[methodDef.modifiers.size()];
        methodDef.modifiers.toArray(objectArray);
        this.currentMethod.setModifiers((String[])objectArray);
        this.currentMethod.setSourceCode(methodDef.body);
        this.addJavaDoc(this.currentMethod);
        this.currentClass.addMethod(this.currentMethod);
    }

    public TypeVariable createTypeVariable(TypeVariableDef typeVariableDef) {
        if (typeVariableDef == null) {
            return null;
        }
        return TypeVariable.createUnresolved(typeVariableDef, this.currentClass == null ? this.currentParent : this.currentClass);
    }

    public TypeVariable createTypeVariable(String string, List list) {
        if (string == null || string.equals("")) {
            return null;
        }
        return this.createTypeVariable(new TypeVariableDef(string, list));
    }

    @Override
    public void addField(FieldDef fieldDef) {
        JavaField javaField = new JavaField();
        javaField.setParentClass(this.currentClass);
        javaField.setLineNumber(fieldDef.lineNumber);
        javaField.setName(fieldDef.name);
        javaField.setType(this.createType(fieldDef.type, fieldDef.dimensions));
        String[] stringArray = new String[fieldDef.modifiers.size()];
        fieldDef.modifiers.toArray(stringArray);
        javaField.setModifiers(stringArray);
        javaField.setInitializationExpression(fieldDef.body);
        this.addJavaDoc(javaField);
        this.setAnnotations(javaField);
        this.currentClass.addField(javaField);
    }

    @Override
    public void addParameter(FieldDef fieldDef) {
        JavaParameter javaParameter = new JavaParameter(this.createType(fieldDef.type, fieldDef.dimensions), fieldDef.name, fieldDef.isVarArgs);
        this.setAnnotations(javaParameter);
        this.currentMethod.addParameter(javaParameter);
    }

    private void setAnnotations(final AbstractBaseJavaEntity abstractBaseJavaEntity) {
        if (!this.currentAnnoDefs.isEmpty()) {
            RecursiveAnnotationVisitor recursiveAnnotationVisitor = new RecursiveAnnotationVisitor(){

                @Override
                public Object visitAnnotation(Annotation annotation) {
                    annotation.setContext(abstractBaseJavaEntity);
                    return super.visitAnnotation(annotation);
                }

                @Override
                public Object visitAnnotationFieldRef(AnnotationFieldRef annotationFieldRef) {
                    annotationFieldRef.setContext(abstractBaseJavaEntity);
                    return super.visitAnnotationFieldRef(annotationFieldRef);
                }
            };
            Annotation[] annotationArray = new Annotation[this.currentAnnoDefs.size()];
            ListIterator listIterator = this.currentAnnoDefs.listIterator();
            while (listIterator.hasNext()) {
                Annotation annotation = (Annotation)listIterator.next();
                annotation.accept(recursiveAnnotationVisitor);
                annotationArray[listIterator.previousIndex()] = annotation;
            }
            abstractBaseJavaEntity.setAnnotations(annotationArray);
            this.currentAnnoDefs.clear();
        }
    }

    @Override
    public void addAnnotation(Annotation annotation) {
        this.currentAnnoDefs.add(annotation);
    }

    public JavaSource getSource() {
        return this.source;
    }
}

