/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.generator.qdox.model.AbstractBaseJavaEntity;
import org.hamcrest.generator.qdox.model.DocletTag;
import org.hamcrest.generator.qdox.model.IndentBuffer;
import org.hamcrest.generator.qdox.model.JavaClass;
import org.hamcrest.generator.qdox.model.JavaSource;

public abstract class AbstractJavaEntity
extends AbstractBaseJavaEntity
implements Comparable {
    protected List modifiers = new ArrayList();
    private String comment;
    private DocletTag[] tags = new DocletTag[0];
    private JavaClass parentClass;

    public String[] getModifiers() {
        return this.modifiers.toArray(new String[this.modifiers.size()]);
    }

    public String getComment() {
        return this.comment;
    }

    public DocletTag[] getTags() {
        return this.tags;
    }

    public DocletTag[] getTagsByName(String string) {
        ArrayList<DocletTag> arrayList = new ArrayList<DocletTag>();
        for (int i = 0; i < this.tags.length; ++i) {
            DocletTag docletTag = this.tags[i];
            if (!docletTag.getName().equals(string)) continue;
            arrayList.add(docletTag);
        }
        return arrayList.toArray(new DocletTag[arrayList.size()]);
    }

    public DocletTag getTagByName(String string) {
        for (int i = 0; i < this.tags.length; ++i) {
            DocletTag docletTag = this.tags[i];
            if (!docletTag.getName().equals(string)) continue;
            return docletTag;
        }
        return null;
    }

    public String getNamedParameter(String string, String string2) {
        DocletTag docletTag = this.getTagByName(string);
        if (docletTag != null) {
            return docletTag.getNamedParameter(string2);
        }
        return null;
    }

    void commentHeader(IndentBuffer indentBuffer) {
        if (this.comment == null && (this.tags == null || this.tags.length == 0)) {
            return;
        }
        indentBuffer.write("/**");
        indentBuffer.newline();
        if (this.comment != null && this.comment.length() > 0) {
            indentBuffer.write(" * ");
            indentBuffer.write(this.comment.replaceAll("\n", "\n * "));
            indentBuffer.newline();
        }
        if (this.tags != null && this.tags.length > 0) {
            if (this.comment != null && this.comment.length() > 0) {
                indentBuffer.write(" *");
                indentBuffer.newline();
            }
            for (int i = 0; i < this.tags.length; ++i) {
                DocletTag docletTag = this.tags[i];
                indentBuffer.write(" * @");
                indentBuffer.write(docletTag.getName());
                if (docletTag.getValue().length() > 0) {
                    indentBuffer.write(' ');
                    indentBuffer.write(docletTag.getValue());
                }
                indentBuffer.newline();
            }
        }
        indentBuffer.write(" */");
        indentBuffer.newline();
    }

    public String getCodeBlock() {
        IndentBuffer indentBuffer = new IndentBuffer();
        this.write(indentBuffer);
        return indentBuffer.toString();
    }

    protected void write(IndentBuffer indentBuffer) {
        this.commentHeader(indentBuffer);
        this.writeBody(indentBuffer);
    }

    protected abstract void writeBody(IndentBuffer var1);

    public void setModifiers(String[] stringArray) {
        this.modifiers = Arrays.asList(stringArray);
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setTags(List list) {
        this.tags = new DocletTag[list.size()];
        list.toArray(this.tags);
    }

    public boolean isAbstract() {
        return this.isModifierPresent("abstract");
    }

    public boolean isPublic() {
        return this.isModifierPresent("public");
    }

    public boolean isPrivate() {
        return this.isModifierPresent("private");
    }

    public boolean isProtected() {
        return this.isModifierPresent("protected");
    }

    public boolean isStatic() {
        return this.isModifierPresent("static");
    }

    public boolean isFinal() {
        return this.isModifierPresent("final");
    }

    public boolean isSynchronized() {
        return this.isModifierPresent("synchronized");
    }

    public boolean isTransient() {
        return this.isModifierPresent("transient");
    }

    public boolean isVolatile() {
        return this.isModifierPresent("volatile");
    }

    public boolean isNative() {
        return this.isModifierPresent("native");
    }

    public boolean isStrictfp() {
        return this.isModifierPresent("strictfp");
    }

    private boolean isModifierPresent(String string) {
        return this.modifiers.contains(string);
    }

    protected void writeNonAccessibilityModifiers(IndentBuffer indentBuffer) {
        for (String string : this.modifiers) {
            if (string.startsWith("p")) continue;
            indentBuffer.write(string);
            indentBuffer.write(' ');
        }
    }

    protected void writeAccessibilityModifier(IndentBuffer indentBuffer) {
        for (String string : this.modifiers) {
            if (!string.startsWith("p")) continue;
            indentBuffer.write(string);
            indentBuffer.write(' ');
        }
    }

    protected void writeAllModifiers(IndentBuffer indentBuffer) {
        for (String string : this.modifiers) {
            indentBuffer.write(string);
            indentBuffer.write(' ');
        }
    }

    public JavaSource getSource() {
        return this.parentClass.getParentSource();
    }

    public void setParentClass(JavaClass javaClass) {
        this.parentClass = javaClass;
    }

    @Override
    public JavaClass getParentClass() {
        return this.parentClass;
    }
}

