/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.greedyswitch;

import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.CrossingMatrixFiller;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.SwitchDecider;
import org.eclipse.elk.alg.layered.p3order.GraphInfoHolder;
import org.eclipse.elk.alg.layered.p3order.ICrossingMinimizationHeuristic;
import org.eclipse.elk.alg.layered.p3order.LayerSweepCrossingMinimizer;

public class GreedySwitchHeuristic
implements ICrossingMinimizationHeuristic {
    private final LayerSweepCrossingMinimizer.CrossMinType greedySwitchType;
    private LNode[][] currentNodeOrder;
    private SwitchDecider switchDecider;
    private int[] portPositions;
    private GraphInfoHolder graphData;
    private int nPorts;

    public GreedySwitchHeuristic(LayerSweepCrossingMinimizer.CrossMinType greedyType, GraphInfoHolder graphData) {
        this.graphData = graphData;
        this.greedySwitchType = greedyType;
    }

    @Override
    public boolean minimizeCrossings(LNode[][] order, int freeLayerIndex, boolean forwardSweep, boolean isFirstSweep) {
        this.setUp(order, freeLayerIndex, forwardSweep);
        return this.continueSwitchingUntilNoImprovementInLayer(freeLayerIndex);
    }

    @Override
    public boolean setFirstLayerOrder(LNode[][] currentOrder, boolean isForwardSweep) {
        int startIndex = this.startIndex(isForwardSweep, currentOrder.length);
        this.setUp(currentOrder, startIndex, isForwardSweep);
        return this.sweepDownwardInLayer(startIndex);
    }

    private void setUp(LNode[][] order, int freeLayerIndex, boolean forwardSweep) {
        this.currentNodeOrder = order;
        SwitchDecider.CrossingCountSide side = forwardSweep ? SwitchDecider.CrossingCountSide.WEST : SwitchDecider.CrossingCountSide.EAST;
        this.switchDecider = this.getNewSwitchDecider(freeLayerIndex, side);
    }

    private SwitchDecider getNewSwitchDecider(int freeLayerIndex, SwitchDecider.CrossingCountSide side) {
        CrossingMatrixFiller crossingMatrixFiller = new CrossingMatrixFiller(this.greedySwitchType, this.currentNodeOrder, freeLayerIndex, side);
        return new SwitchDecider(freeLayerIndex, this.currentNodeOrder, crossingMatrixFiller, this.portPositions, this.graphData, this.greedySwitchType == LayerSweepCrossingMinimizer.CrossMinType.ONE_SIDED_GREEDY_SWITCH);
    }

    private boolean continueSwitchingUntilNoImprovementInLayer(int freeLayerIndex) {
        boolean continueSwitching;
        boolean improved = false;
        do {
            continueSwitching = this.sweepDownwardInLayer(freeLayerIndex);
            improved |= continueSwitching;
        } while (continueSwitching);
        return improved;
    }

    private boolean sweepDownwardInLayer(int layerIndex) {
        boolean continueSwitching = false;
        int lengthOfFreeLayer = this.currentNodeOrder[layerIndex].length;
        int upperNodeIndex = 0;
        while (upperNodeIndex < lengthOfFreeLayer - 1) {
            int lowerNodeIndex = upperNodeIndex + 1;
            continueSwitching |= this.switchIfImproves(layerIndex, upperNodeIndex, lowerNodeIndex);
            ++upperNodeIndex;
        }
        return continueSwitching;
    }

    private boolean switchIfImproves(int layerIndex, int upperNodeIndex, int lowerNodeIndex) {
        boolean continueSwitching = false;
        if (this.switchDecider.doesSwitchReduceCrossings(upperNodeIndex, lowerNodeIndex)) {
            this.exchangeNodes(upperNodeIndex, lowerNodeIndex, layerIndex);
            continueSwitching = true;
        }
        return continueSwitching;
    }

    private void exchangeNodes(int indexOne, int indexTwo, int layerIndex) {
        this.switchDecider.notifyOfSwitch(this.currentNodeOrder[layerIndex][indexOne], this.currentNodeOrder[layerIndex][indexTwo]);
        LNode[] layer = this.currentNodeOrder[layerIndex];
        LNode temp = layer[indexTwo];
        layer[indexTwo] = layer[indexOne];
        layer[indexOne] = temp;
    }

    private int startIndex(boolean isForwardSweep, int length) {
        return isForwardSweep ? 0 : length - 1;
    }

    @Override
    public boolean alwaysImproves() {
        return this.greedySwitchType != LayerSweepCrossingMinimizer.CrossMinType.ONE_SIDED_GREEDY_SWITCH;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public void initAtPortLevel(int l, int n, int p, LNode[][] nodeOrder) {
        ++this.nPorts;
    }

    @Override
    public void initAtLayerLevel(int l, LNode[][] nodeOrder) {
        nodeOrder[l][0].getLayer().id = l;
    }

    @Override
    public void initAfterTraversal() {
        this.portPositions = new int[this.nPorts];
    }
}

