"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeYCustomDomainsByGroupId = void 0;
var axis_type_utils_1 = require("../../utils/axis_type_utils");
var axis_utils_1 = require("../../utils/axis_utils");
function mergeYCustomDomainsByGroupId(axesSpecs, chartRotation) {
    var domainsByGroupId = new Map();
    axesSpecs.forEach(function (spec) {
        var id = spec.id, groupId = spec.groupId, domain = spec.domain;
        if (!domain) {
            return;
        }
        if (!axis_utils_1.isYDomain(spec.position, chartRotation)) {
            var errorMessage = "[Axis " + id + "]: custom domain for xDomain should be defined in Settings";
            throw new Error(errorMessage);
        }
        if (axis_type_utils_1.isCompleteBound(domain) && domain.min > domain.max) {
            var errorMessage = "[Axis " + id + "]: custom domain is invalid, min is greater than max";
            throw new Error(errorMessage);
        }
        var prevGroupDomain = domainsByGroupId.get(groupId);
        if (prevGroupDomain) {
            var prevDomain = prevGroupDomain;
            var prevMin = axis_type_utils_1.isLowerBound(prevDomain) ? prevDomain.min : undefined;
            var prevMax = axis_type_utils_1.isUpperBound(prevDomain) ? prevDomain.max : undefined;
            var max = prevMax;
            var min = prevMin;
            if (axis_type_utils_1.isCompleteBound(domain)) {
                min = prevMin != null ? Math.min(domain.min, prevMin) : domain.min;
                max = prevMax != null ? Math.max(domain.max, prevMax) : domain.max;
            }
            else if (axis_type_utils_1.isLowerBound(domain)) {
                min = prevMin != null ? Math.min(domain.min, prevMin) : domain.min;
            }
            else if (axis_type_utils_1.isUpperBound(domain)) {
                max = prevMax != null ? Math.max(domain.max, prevMax) : domain.max;
            }
            var mergedDomain = {
                min: min,
                max: max,
            };
            if (axis_type_utils_1.isBounded(mergedDomain)) {
                domainsByGroupId.set(groupId, mergedDomain);
            }
        }
        else {
            domainsByGroupId.set(groupId, domain);
        }
    });
    return domainsByGroupId;
}
exports.mergeYCustomDomainsByGroupId = mergeYCustomDomainsByGroupId;
//# sourceMappingURL=merge_y_custom_domains.js.map