/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.svgicons;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.freeplane.core.awt.GraphicsHints;

class CachingIcon
implements Icon {
    private Supplier<ImageIcon> iconSupplier;
    private ImageIcon icon;
    private double scaleX = 0.0;
    private double scaleY = 0.0;
    private BufferedImage cachedImage;

    public CachingIcon(Supplier<ImageIcon> iconSupplier) {
        this.iconSupplier = iconSupplier;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        if (g2.getRenderingHint(GraphicsHints.CACHE_ICONS) != Boolean.TRUE || this.getIcon().getIconHeight() <= 0 || this.getIcon().getIconWidth() <= 0) {
            this.getIcon().paintIcon(c, g, x, y);
            return;
        }
        AffineTransform transform = g2.getTransform();
        double scaleX = transform.getScaleX();
        double scaleY = transform.getScaleY();
        if (scaleX != this.scaleX || scaleY != this.scaleY || this.cachedImage == null) {
            int scaledWidth = (int)((double)this.getIconWidth() * scaleX);
            int scaledHeight = (int)((double)this.getIconHeight() * scaleY);
            if (scaledHeight <= 0 || scaledWidth <= 0) {
                return;
            }
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.updateImage(scaledWidth, scaledHeight);
        }
        Graphics2D gg = (Graphics2D)g.create();
        gg.setTransform(AffineTransform.getTranslateInstance((double)x * scaleX + transform.getTranslateX(), (double)y * scaleY + transform.getTranslateY()));
        gg.drawImage((Image)this.cachedImage, 0, 0, null);
        gg.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.getIcon().getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.getIcon().getIconHeight();
    }

    private void updateImage(int scaledWidth, int scaledHeight) {
        this.cachedImage = new BufferedImage(scaledWidth, scaledHeight, 2);
        Graphics2D graphics = this.cachedImage.createGraphics();
        graphics.scale(this.scaleX, this.scaleY);
        this.getIcon().paintIcon(null, graphics, 0, 0);
    }

    public ImageIcon getImageIcon() {
        return this.getIcon();
    }

    private ImageIcon getIcon() {
        if (this.icon == null && this.iconSupplier != null) {
            this.icon = this.iconSupplier.get();
            this.iconSupplier = null;
        }
        return this.icon;
    }
}

