/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.fmt;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspTagException;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.tag.common.fmt.SetLocaleSupport;

public abstract class FormatNumberSupport
extends BodyTagSupport {
    private static final Class[] GET_INSTANCE_PARAM_TYPES = new Class[]{String.class};
    private static final String NUMBER = "number";
    private static final String CURRENCY = "currency";
    private static final String PERCENT = "percent";
    protected Object value;
    protected boolean valueSpecified;
    protected String type;
    protected String pattern;
    protected String currencyCode;
    protected String currencySymbol;
    protected boolean isGroupingUsed;
    protected boolean groupingUsedSpecified;
    protected int maxIntegerDigits;
    protected boolean maxIntegerDigitsSpecified;
    protected int minIntegerDigits;
    protected boolean minIntegerDigitsSpecified;
    protected int maxFractionDigits;
    protected boolean maxFractionDigitsSpecified;
    protected int minFractionDigits;
    protected boolean minFractionDigitsSpecified;
    private String var;
    private int scope;
    private static Class currencyClass;

    public FormatNumberSupport() {
        this.init();
    }

    private void init() {
        this.type = null;
        this.value = null;
        this.valueSpecified = false;
        this.currencySymbol = null;
        this.currencyCode = null;
        this.var = null;
        this.pattern = null;
        this.groupingUsedSpecified = false;
        this.minIntegerDigitsSpecified = false;
        this.maxIntegerDigitsSpecified = false;
        this.minFractionDigitsSpecified = false;
        this.maxFractionDigitsSpecified = false;
        this.scope = 1;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = Util.getScope(scope);
    }

    @Override
    public int doEndTag() throws JspException {
        Locale loc;
        String formatted = null;
        Object input = null;
        if (this.valueSpecified) {
            input = this.value;
        } else if (this.bodyContent != null && this.bodyContent.getString() != null) {
            input = this.bodyContent.getString().trim();
        }
        if (input == null || input.equals("")) {
            if (this.var != null) {
                this.pageContext.removeAttribute(this.var, this.scope);
            }
            return 6;
        }
        if (input instanceof String) {
            try {
                input = ((String)input).indexOf(46) != -1 ? (Number)Double.valueOf((String)input) : (Number)Long.valueOf((String)input);
            }
            catch (NumberFormatException nfe) {
                throw new JspException(Resources.getMessage("FORMAT_NUMBER_PARSE_ERROR", input), nfe);
            }
        }
        if ((loc = SetLocaleSupport.getFormattingLocale(this.pageContext, this, false, true)) != null) {
            NumberFormat formatter = null;
            if (this.pattern != null && !this.pattern.equals("")) {
                DecimalFormatSymbols symbols = new DecimalFormatSymbols(loc);
                formatter = new DecimalFormat(this.pattern, symbols);
            } else {
                formatter = this.createFormatter(loc);
            }
            if (this.pattern != null && !this.pattern.equals("") || CURRENCY.equalsIgnoreCase(this.type)) {
                try {
                    this.setCurrency(formatter);
                }
                catch (Exception e) {
                    throw new JspException(Resources.getMessage("FORMAT_NUMBER_CURRENCY_ERROR"), e);
                }
            }
            this.configureFormatter(formatter);
            formatted = formatter.format(input);
        } else {
            formatted = input.toString();
        }
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, formatted, this.scope);
        } else {
            try {
                this.pageContext.getOut().print(formatted);
            }
            catch (IOException ioe) {
                throw new JspTagException(ioe.toString(), ioe);
            }
        }
        return 6;
    }

    @Override
    public void release() {
        this.init();
    }

    private NumberFormat createFormatter(Locale loc) throws JspException {
        NumberFormat formatter = null;
        if (this.type == null || NUMBER.equalsIgnoreCase(this.type)) {
            formatter = NumberFormat.getNumberInstance(loc);
        } else if (CURRENCY.equalsIgnoreCase(this.type)) {
            formatter = NumberFormat.getCurrencyInstance(loc);
        } else if (PERCENT.equalsIgnoreCase(this.type)) {
            formatter = NumberFormat.getPercentInstance(loc);
        } else {
            throw new JspException(Resources.getMessage("FORMAT_NUMBER_INVALID_TYPE", this.type));
        }
        return formatter;
    }

    private void configureFormatter(NumberFormat formatter) {
        if (this.groupingUsedSpecified) {
            formatter.setGroupingUsed(this.isGroupingUsed);
        }
        if (this.maxIntegerDigitsSpecified) {
            formatter.setMaximumIntegerDigits(this.maxIntegerDigits);
        }
        if (this.minIntegerDigitsSpecified) {
            formatter.setMinimumIntegerDigits(this.minIntegerDigits);
        }
        if (this.maxFractionDigitsSpecified) {
            formatter.setMaximumFractionDigits(this.maxFractionDigits);
        }
        if (this.minFractionDigitsSpecified) {
            formatter.setMinimumFractionDigits(this.minFractionDigits);
        }
    }

    private void setCurrency(NumberFormat formatter) throws Exception {
        String code = null;
        String symbol = null;
        if (this.currencyCode == null && this.currencySymbol == null) {
            return;
        }
        if (this.currencyCode != null && this.currencySymbol != null) {
            if (currencyClass != null) {
                code = this.currencyCode;
            } else {
                symbol = this.currencySymbol;
            }
        } else if (this.currencyCode == null) {
            symbol = this.currencySymbol;
        } else if (currencyClass != null) {
            code = this.currencyCode;
        } else {
            symbol = this.currencyCode;
        }
        if (code != null) {
            Object[] methodArgs = new Object[1];
            Method m = currencyClass.getMethod("getInstance", GET_INSTANCE_PARAM_TYPES);
            methodArgs[0] = code;
            Object currency = m.invoke(null, methodArgs);
            Class[] paramTypes = new Class[]{currencyClass};
            Class<?> numberFormatClass = Class.forName("java.text.NumberFormat");
            m = numberFormatClass.getMethod("setCurrency", paramTypes);
            methodArgs[0] = currency;
            m.invoke((Object)formatter, methodArgs);
        } else {
            DecimalFormat df = (DecimalFormat)formatter;
            DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
            dfs.setCurrencySymbol(symbol);
            df.setDecimalFormatSymbols(dfs);
        }
    }

    static {
        try {
            currencyClass = Class.forName("java.util.Currency");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

