/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.TimeZone;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.JSR310;
import org.h2.util.JSR310Utils;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public class ValueTimestamp
extends Value {
    public static final int DEFAULT_PRECISION = 26;
    public static final int MAXIMUM_PRECISION = 29;
    static final int DEFAULT_SCALE = 6;
    public static final int MAXIMUM_SCALE = 9;
    private final long dateValue;
    private final long timeNanos;

    private ValueTimestamp(long l, long l2) {
        if (l < -511999999967L || l > 512000000415L) {
            throw new IllegalArgumentException("dateValue out of range " + l);
        }
        if (l2 < 0L || l2 >= 86400000000000L) {
            throw new IllegalArgumentException("timeNanos out of range " + l2);
        }
        this.dateValue = l;
        this.timeNanos = l2;
    }

    public static ValueTimestamp fromDateValueAndNanos(long l, long l2) {
        return (ValueTimestamp)Value.cache(new ValueTimestamp(l, l2));
    }

    public static ValueTimestamp get(TimeZone timeZone, Timestamp timestamp) {
        long l = timestamp.getTime();
        return ValueTimestamp.fromLocalMillis(l + (long)(timeZone == null ? DateTimeUtils.getTimeZoneOffsetMillis(l) : timeZone.getOffset(l)), timestamp.getNanos() % 1000000);
    }

    public static ValueTimestamp fromMillis(long l, int n) {
        return ValueTimestamp.fromLocalMillis(l + (long)DateTimeUtils.getTimeZoneOffsetMillis(l), n);
    }

    private static ValueTimestamp fromLocalMillis(long l, int n) {
        long l2 = DateTimeUtils.dateValueFromLocalMillis(l);
        long l3 = (long)n + DateTimeUtils.nanosFromLocalMillis(l);
        return ValueTimestamp.fromDateValueAndNanos(l2, l3);
    }

    public static ValueTimestamp parse(String string) {
        return ValueTimestamp.parse(string, null);
    }

    public static ValueTimestamp parse(String string, CastDataProvider castDataProvider) {
        try {
            return (ValueTimestamp)DateTimeUtils.parseTimestamp(string, castDataProvider, false);
        }
        catch (Exception exception) {
            throw DbException.get(22007, exception, "TIMESTAMP", string);
        }
    }

    public long getDateValue() {
        return this.dateValue;
    }

    public long getTimeNanos() {
        return this.timeNanos;
    }

    @Override
    public Timestamp getTimestamp(TimeZone timeZone) {
        Timestamp timestamp = new Timestamp(DateTimeUtils.getMillis(timeZone, this.dateValue, this.timeNanos));
        timestamp.setNanos((int)(this.timeNanos % 1000000000L));
        return timestamp;
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_TIMESTAMP;
    }

    @Override
    public int getValueType() {
        return 11;
    }

    @Override
    public int getMemory() {
        return 32;
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(29);
        DateTimeUtils.appendDate(stringBuilder, this.dateValue);
        stringBuilder.append(' ');
        DateTimeUtils.appendTime(stringBuilder, this.timeNanos);
        return stringBuilder.toString();
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        stringBuilder.append("TIMESTAMP '");
        DateTimeUtils.appendDate(stringBuilder, this.dateValue);
        stringBuilder.append(' ');
        DateTimeUtils.appendTime(stringBuilder, this.timeNanos);
        return stringBuilder.append('\'');
    }

    @Override
    public boolean checkPrecision(long l) {
        return true;
    }

    @Override
    public Value convertScale(boolean bl, int n) {
        if (n >= 9) {
            return this;
        }
        if (n < 0) {
            throw DbException.getInvalidValueException("scale", n);
        }
        long l = this.timeNanos;
        long l2 = this.dateValue;
        long l3 = DateTimeUtils.convertScale(l, n, l2 == 512000000415L ? 86400000000000L : Long.MAX_VALUE);
        if (l3 == l) {
            return this;
        }
        if (l3 >= 86400000000000L) {
            l3 -= 86400000000000L;
            l2 = DateTimeUtils.incrementDateValue(l2);
        }
        return ValueTimestamp.fromDateValueAndNanos(l2, l3);
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        ValueTimestamp valueTimestamp = (ValueTimestamp)value;
        int n = Long.compare(this.dateValue, valueTimestamp.dateValue);
        if (n != 0) {
            return n;
        }
        return Long.compare(this.timeNanos, valueTimestamp.timeNanos);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ValueTimestamp)) {
            return false;
        }
        ValueTimestamp valueTimestamp = (ValueTimestamp)object;
        return this.dateValue == valueTimestamp.dateValue && this.timeNanos == valueTimestamp.timeNanos;
    }

    @Override
    public int hashCode() {
        return (int)(this.dateValue ^ this.dateValue >>> 32 ^ this.timeNanos ^ this.timeNanos >>> 32);
    }

    @Override
    public Object getObject() {
        return this.getTimestamp(null);
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        if (JSR310.PRESENT) {
            try {
                preparedStatement.setObject(n, JSR310Utils.valueToLocalDateTime(this, null), 93);
                return;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        preparedStatement.setTimestamp(n, this.getTimestamp(null));
    }

    @Override
    public Value add(Value value) {
        ValueTimestamp valueTimestamp = (ValueTimestamp)value.convertTo(11);
        long l = DateTimeUtils.absoluteDayFromDateValue(this.dateValue) + DateTimeUtils.absoluteDayFromDateValue(valueTimestamp.dateValue);
        long l2 = this.timeNanos + valueTimestamp.timeNanos;
        if (l2 >= 86400000000000L) {
            l2 -= 86400000000000L;
            ++l;
        }
        return ValueTimestamp.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(l), l2);
    }

    @Override
    public Value subtract(Value value) {
        ValueTimestamp valueTimestamp = (ValueTimestamp)value.convertTo(11);
        long l = DateTimeUtils.absoluteDayFromDateValue(this.dateValue) - DateTimeUtils.absoluteDayFromDateValue(valueTimestamp.dateValue);
        long l2 = this.timeNanos - valueTimestamp.timeNanos;
        if (l2 < 0L) {
            l2 += 86400000000000L;
            --l;
        }
        return ValueTimestamp.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(l), l2);
    }
}

