/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.abo;

import javafx.fxml.FXML;
import javafx.scene.control.Label;
import mediathek.config.Daten;
import mediathek.daten.ListeAbo;
import mediathek.gui.messages.TimerEvent;
import mediathek.javafx.tool.JavaFxUtils;
import net.engio.mbassy.listener.Handler;

public class AboInformationController {
    @FXML
    private Label totalAbos;
    @FXML
    private Label activeAbos;
    @FXML
    private Label inactiveAbos;
    private int oldSize = -1;
    private long oldActive = -1L;
    private long oldInactive = -1L;
    private Daten daten;

    public void startListener() {
        this.daten = Daten.getInstance();
        this.daten.getMessageBus().subscribe(this);
    }

    private void updateTotalDisplay(int gesamt) {
        if (gesamt == 1) {
            this.totalAbos.setText("Gesamt: 1 Abo");
        } else {
            this.totalAbos.setText(String.format("Gesamt: %d Abos", gesamt));
        }
    }

    private void updateDisplayText() {
        ListeAbo listeAbo = this.daten.getListeAbo();
        long _activeAbos = listeAbo.activeAbos();
        long _inactiveAbos = listeAbo.inactiveAbos();
        int gesamt = listeAbo.size();
        if (gesamt != this.oldSize) {
            this.updateTotalDisplay(gesamt);
            this.oldSize = gesamt;
        }
        if (_activeAbos != this.oldActive) {
            this.activeAbos.setText(String.format("%d eingeschaltet", _activeAbos));
            this.oldActive = _activeAbos;
        }
        if (_inactiveAbos != this.oldInactive) {
            this.inactiveAbos.setText(String.format("%d ausgeschaltet", _inactiveAbos));
            this.oldInactive = _inactiveAbos;
        }
    }

    @Handler
    private void handleTimerEvent(TimerEvent e) {
        JavaFxUtils.invokeInFxThreadAndWait(this::updateDisplayText);
    }
}

