/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx;

import eu.hansolo.tilesfx.Section;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;

public class SectionBuilder<B extends SectionBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected SectionBuilder() {
    }

    public static final SectionBuilder create() {
        return new SectionBuilder();
    }

    public final B start(double VALUE) {
        this.properties.put("start", new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B stop(double VALUE) {
        this.properties.put("stop", new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B text(String TEXT) {
        this.properties.put("text", new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B icon(Image IMAGE) {
        this.properties.put("icon", new SimpleObjectProperty<Image>(IMAGE));
        return (B)this;
    }

    public final B color(Color COLOR) {
        this.properties.put("color", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B highlightColor(Color COLOR) {
        this.properties.put("highlightColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B active(boolean ACTIVE) {
        this.properties.put("active", new SimpleBooleanProperty(ACTIVE));
        return (B)this;
    }

    public final B styleClass(String STYLE_CLASS) {
        this.properties.put("styleClass", new SimpleStringProperty(STYLE_CLASS));
        return (B)this;
    }

    public final B onSectionEntered(EventHandler<Section.SectionEvent> HANDLER) {
        this.properties.put("onSectionEntered", new SimpleObjectProperty<EventHandler<Section.SectionEvent>>(HANDLER));
        return (B)this;
    }

    public final B onSectionLeft(EventHandler<Section.SectionEvent> HANDLER) {
        this.properties.put("onSectionLeft", new SimpleObjectProperty<EventHandler<Section.SectionEvent>>(HANDLER));
        return (B)this;
    }

    public final Section build() {
        Section SECTION = new Section();
        for (String key : this.properties.keySet()) {
            if ("start".equals(key)) {
                SECTION.setStart(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("stop".equals(key)) {
                SECTION.setStop(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("text".equals(key)) {
                SECTION.setText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("icon".equals(key)) {
                SECTION.setIcon((Image)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("color".equals(key)) {
                SECTION.setColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("highlightColor".equals(key)) {
                SECTION.setHighlightColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textColor".equals(key)) {
                SECTION.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("active".equals(key)) {
                SECTION.setActive(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("onSectionEntered".equals(key)) {
                SECTION.setOnSectionEntered((EventHandler)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("onSectionLeft".equals(key)) {
                SECTION.setOnSectionLeft((EventHandler)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"styleClass".equals(key)) continue;
            SECTION.setStyleClass((String)((StringProperty)this.properties.get(key)).get());
        }
        return SECTION;
    }
}

