/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import morfologik.fsa.ByteSequenceIterator;
import morfologik.fsa.FSA;
import morfologik.fsa.FSATraversal;
import morfologik.fsa.MatchResult;
import morfologik.stemming.ArrayViewList;
import morfologik.stemming.BufferUtils;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryIterator;
import morfologik.stemming.DictionaryMetadata;
import morfologik.stemming.ISequenceEncoder;
import morfologik.stemming.IStemmer;
import morfologik.stemming.UnmappableInputException;
import morfologik.stemming.WordData;

public final class DictionaryLookup
implements IStemmer,
Iterable<WordData> {
    private final FSATraversal matcher;
    private final ByteSequenceIterator finalStatesIterator;
    private final int rootNode;
    private static final int EXPAND_SIZE = 10;
    private WordData[] forms = new WordData[0];
    private final ArrayViewList<WordData> formsList = new ArrayViewList<WordData>(this.forms, 0, this.forms.length);
    private final DictionaryMetadata dictionaryMetadata;
    private final CharsetEncoder encoder;
    private final CharsetDecoder decoder;
    private final FSA fsa;
    private final char separatorChar;
    private ByteBuffer byteBuffer = ByteBuffer.allocate(0);
    private CharBuffer charBuffer = CharBuffer.allocate(0);
    private final MatchResult matchResult = new MatchResult();
    private final Dictionary dictionary;
    private final ISequenceEncoder sequenceEncoder;

    public DictionaryLookup(Dictionary dictionary) throws IllegalArgumentException {
        this.dictionary = dictionary;
        this.dictionaryMetadata = dictionary.metadata;
        this.sequenceEncoder = dictionary.metadata.getSequenceEncoderType().get();
        this.rootNode = dictionary.fsa.getRootNode();
        this.fsa = dictionary.fsa;
        this.matcher = new FSATraversal(this.fsa);
        this.finalStatesIterator = new ByteSequenceIterator(this.fsa, this.fsa.getRootNode());
        if (this.dictionaryMetadata == null) {
            throw new IllegalArgumentException("Dictionary metadata must not be null.");
        }
        this.decoder = dictionary.metadata.getDecoder();
        this.encoder = dictionary.metadata.getEncoder();
        this.separatorChar = dictionary.metadata.getSeparatorAsChar();
    }

    @Override
    public List<WordData> lookup(CharSequence word) {
        int arc;
        byte separator = this.dictionaryMetadata.getSeparator();
        int prefixBytes = this.sequenceEncoder.prefixBytes();
        if (!this.dictionaryMetadata.getInputConversionPairs().isEmpty()) {
            word = DictionaryLookup.applyReplacements(word, this.dictionaryMetadata.getInputConversionPairs());
        }
        this.formsList.wrap((WordData[])this.forms, 0, 0);
        this.charBuffer = BufferUtils.clearAndEnsureCapacity(this.charBuffer, word.length());
        for (int i = 0; i < word.length(); ++i) {
            char chr = word.charAt(i);
            if (chr == this.separatorChar) {
                return this.formsList;
            }
            this.charBuffer.put(chr);
        }
        this.charBuffer.flip();
        try {
            this.byteBuffer = BufferUtils.charsToBytes(this.encoder, this.charBuffer, this.byteBuffer);
        }
        catch (UnmappableInputException e) {
            return this.formsList;
        }
        MatchResult match = this.matcher.match(this.matchResult, this.byteBuffer.array(), 0, this.byteBuffer.remaining(), this.rootNode);
        if (match.kind == -4 && (arc = this.fsa.getArc(match.node, separator)) != 0 && !this.fsa.isArcFinal(arc)) {
            int formsCount = 0;
            this.finalStatesIterator.restartFrom(this.fsa.getEndNode(arc));
            while (this.finalStatesIterator.hasNext()) {
                int tagSize;
                int sepPos;
                ByteBuffer bb = this.finalStatesIterator.next();
                byte[] ba = bb.array();
                int bbSize = bb.remaining();
                if (formsCount >= this.forms.length) {
                    this.forms = Arrays.copyOf(this.forms, this.forms.length + 10);
                    for (int k = 0; k < this.forms.length; ++k) {
                        if (this.forms[k] != null) continue;
                        this.forms[k] = new WordData(this.decoder);
                    }
                }
                WordData wordData = this.forms[formsCount++];
                if (this.dictionaryMetadata.getOutputConversionPairs().isEmpty()) {
                    wordData.update(this.byteBuffer, word);
                } else {
                    wordData.update(this.byteBuffer, DictionaryLookup.applyReplacements(word, this.dictionaryMetadata.getOutputConversionPairs()));
                }
                assert (prefixBytes <= bbSize) : this.sequenceEncoder.getClass() + " >? " + bbSize;
                for (sepPos = prefixBytes; sepPos < bbSize && ba[sepPos] != separator; ++sepPos) {
                }
                wordData.stemBuffer = this.sequenceEncoder.decode(wordData.stemBuffer, this.byteBuffer, ByteBuffer.wrap(ba, 0, sepPos));
                if ((tagSize = bbSize - ++sepPos) <= 0) continue;
                wordData.tagBuffer = BufferUtils.clearAndEnsureCapacity(wordData.tagBuffer, tagSize);
                wordData.tagBuffer.put(ba, sepPos, tagSize);
                wordData.tagBuffer.flip();
            }
            this.formsList.wrap((WordData[])this.forms, 0, formsCount);
        }
        return this.formsList;
    }

    public static String applyReplacements(CharSequence word, LinkedHashMap<String, String> replacements) {
        StringBuilder sb = new StringBuilder(word);
        for (Map.Entry<String, String> e : replacements.entrySet()) {
            String key = e.getKey();
            int index = sb.indexOf(e.getKey());
            while (index != -1) {
                sb.replace(index, index + key.length(), e.getValue());
                index = sb.indexOf(key, index + key.length());
            }
        }
        return sb.toString();
    }

    @Override
    public Iterator<WordData> iterator() {
        return new DictionaryIterator(this.dictionary, this.decoder, true);
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public char getSeparatorChar() {
        return this.separatorChar;
    }
}

