/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public abstract class RuleFilter {
    @Nullable
    public abstract RuleMatch acceptRuleMatch(RuleMatch var1, Map<String, String> var2, int var3, AnalyzedTokenReadings[] var4, List<Integer> var5) throws IOException;

    public boolean matches(Map<String, String> arguments, AnalyzedTokenReadings[] patternTokens, int firstMatchToken, List<Integer> tokenPositions) throws IOException {
        RuleMatch fakeMatch = new RuleMatch(new FakeRule(), null, 0, 1, "(internal rule)");
        return this.acceptRuleMatch(fakeMatch, arguments, firstMatchToken, patternTokens, tokenPositions) != null;
    }

    protected String getRequired(String key, Map<String, String> map) {
        String result = map.get(key);
        if (result == null) {
            throw new IllegalArgumentException("Missing key '" + key + "'");
        }
        return result;
    }

    protected String getOptional(String key, Map<String, String> map) {
        return map.get(key);
    }

    protected String getOptional(String key, Map<String, String> map, String defaultValue) {
        String value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected int getPosition(String fromStr, AnalyzedTokenReadings[] patternTokens, RuleMatch match) {
        int i;
        if (fromStr.startsWith("marker")) {
            for (i = 0; i < patternTokens.length && patternTokens[i].getStartPos() < match.getFromPos() || patternTokens[i].isSentenceStart(); ++i) {
            }
            ++i;
            if (fromStr.length() > 6) {
                i += Integer.parseInt(fromStr.replace("marker", ""));
            }
        } else {
            i = Integer.parseInt(fromStr);
        }
        if (i < 1 || i > patternTokens.length) {
            throw new IllegalArgumentException("RuleFilter: Index out of bounds in " + match.getRule().getFullId() + ", value: " + fromStr);
        }
        return i - 1;
    }

    protected boolean isMatchAtSentenceStart(AnalyzedTokenReadings[] tokens, RuleMatch match) {
        int i;
        for (i = 0; i < tokens.length && tokens[i].getStartPos() < match.getFromPos(); ++i) {
        }
        while (i > 0 && StringTools.isPunctuationMark(tokens[i].getToken())) {
            --i;
        }
        return i == 0;
    }

    protected int getSkipCorrectedReference(List<Integer> tokenPositions, int refNumber) {
        if (refNumber < 0) {
            return refNumber;
        }
        int correctedRef = 0;
        int i = 0;
        for (int tokenPosition : tokenPositions) {
            if (i++ >= refNumber) break;
            correctedRef += tokenPosition;
        }
        return correctedRef - 1;
    }

    private static class FakeRule
    extends Rule {
        private FakeRule() {
        }

        @Override
        public String getId() {
            return "FAKE-RULE-FOR-FILTER";
        }

        @Override
        public String getDescription() {
            return "<none>";
        }

        @Override
        public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
            return new RuleMatch[0];
        }
    }
}

