/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.CredentialValidator;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.authenticators.browser.AbstractUsernameFormAuthenticator;
import org.keycloak.authentication.requiredactions.UpdateTotp;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.OTPCredentialProvider;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.OTPCredentialModel;

public class OTPFormAuthenticator
extends AbstractUsernameFormAuthenticator
implements Authenticator,
CredentialValidator<OTPCredentialProvider> {
    @Override
    public void action(AuthenticationFlowContext context) {
        this.validateOTP(context);
    }

    public void authenticate(AuthenticationFlowContext context) {
        Response challengeResponse = this.challenge(context, null);
        context.challenge(challengeResponse);
    }

    public void validateOTP(AuthenticationFlowContext context) {
        UserModel userModel;
        MultivaluedMap inputData = context.getHttpRequest().getDecodedFormParameters();
        if (inputData.containsKey((Object)"cancel")) {
            context.resetFlow();
            return;
        }
        String otp = (String)inputData.getFirst((Object)"otp");
        String credentialId = context.getSelectedCredentialId();
        if (credentialId == null || credentialId.isEmpty()) {
            credentialId = ((OTPCredentialModel)this.getCredentialProvider(context.getSession()).getDefaultCredential(context.getSession(), context.getRealm(), context.getUser())).getId();
            context.setSelectedCredentialId(credentialId);
        }
        if (!this.enabledUser(context, userModel = context.getUser())) {
            return;
        }
        if (otp == null) {
            Response challengeResponse = this.challenge(context, null);
            context.challenge(challengeResponse);
            return;
        }
        boolean valid = this.getCredentialProvider(context.getSession()).isValid(context.getRealm(), context.getUser(), (CredentialInput)new UserCredentialModel(credentialId, this.getCredentialProvider(context.getSession()).getType(), otp));
        if (!valid) {
            context.getEvent().user(userModel).error("invalid_user_credentials");
            Response challengeResponse = this.challenge(context, "invalidTotpMessage");
            context.failureChallenge(AuthenticationFlowError.INVALID_CREDENTIALS, challengeResponse);
            return;
        }
        context.success();
    }

    public boolean requiresUser() {
        return true;
    }

    @Override
    protected String tempDisabledError() {
        return "invalidTotpMessage";
    }

    @Override
    protected Response createLoginForm(LoginFormsProvider form) {
        return form.createLoginTotp();
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return this.getCredentialProvider(session).isConfiguredFor(realm, user);
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
        if (!user.getRequiredActions().contains(UserModel.RequiredAction.CONFIGURE_TOTP.name())) {
            user.addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP.name());
        }
    }

    public List<RequiredActionFactory> getRequiredActions(KeycloakSession session) {
        return Collections.singletonList((UpdateTotp)session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, UserModel.RequiredAction.CONFIGURE_TOTP.name()));
    }

    @Override
    public void close() {
    }

    public OTPCredentialProvider getCredentialProvider(KeycloakSession session) {
        return (OTPCredentialProvider)session.getProvider(CredentialProvider.class, "keycloak-otp");
    }
}

