/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.infinispan.InfinispanXAResourceRecovery;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.tm.XAResourceRecovery;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;

public class XAResourceRecoveryServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
Supplier<XAResourceRecovery>,
Consumer<XAResourceRecovery> {
    private final SupplierDependency<Cache<?, ?>> cache = new ServiceSupplierDependency(this.getServiceName().getParent());
    private volatile SupplierDependency<XAResourceRecoveryRegistry> registry;

    public XAResourceRecoveryServiceConfigurator(PathAddress cacheAddress) {
        super(CacheResourceDefinition.Capability.CACHE.getServiceName(cacheAddress).append(new String[]{"recovery"}));
    }

    @Override
    public XAResourceRecovery get() {
        Cache cache = (Cache)this.cache.get();
        InfinispanXAResourceRecovery recovery = new InfinispanXAResourceRecovery(cache);
        if (cache.getCacheConfiguration().transaction().recovery().enabled()) {
            ((XAResourceRecoveryRegistry)this.registry.get()).addXAResourceRecovery((XAResourceRecovery)recovery);
        }
        return recovery;
    }

    @Override
    public void accept(XAResourceRecovery recovery) {
        if (((Cache)this.cache.get()).getCacheConfiguration().transaction().recovery().enabled()) {
            ((XAResourceRecoveryRegistry)this.registry.get()).removeXAResourceRecovery(recovery);
        }
    }

    public ServiceConfigurator configure(OperationContext context) {
        this.registry = new ServiceSupplierDependency(context.getCapabilityServiceName(TransactionResourceDefinition.TransactionRequirement.XA_RESOURCE_RECOVERY_REGISTRY.getName(), TransactionResourceDefinition.TransactionRequirement.XA_RESOURCE_RECOVERY_REGISTRY.getType()));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer recovery = builder.provides(new ServiceName[]{this.getServiceName()});
        new CompositeDependency(new Dependency[]{this.cache, this.registry}).register(builder);
        FunctionalService service = new FunctionalService(recovery, Function.identity(), (Supplier)this, (Consumer)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.PASSIVE);
    }
}

