/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class FieldNameCollector {
    private FieldNameCollector() {
    }

    public static FieldCollection extractFieldNames(Query query) {
        HashSet<Query> composingQueries = new HashSet<Query>();
        FieldNameCollector.collectComposingQueries(query, composingQueries);
        FieldCollection fieldCollection = new FieldCollection();
        for (Query composingQuery : composingQueries) {
            PhraseQuery phraseQuery;
            if (composingQuery instanceof NumericRangeQuery) {
                fieldCollection.addNumericFieldName(((NumericRangeQuery)composingQuery).getField());
                continue;
            }
            if (composingQuery instanceof MultiTermQuery) {
                fieldCollection.addStringFieldName(((MultiTermQuery)composingQuery).getField());
                continue;
            }
            if (composingQuery instanceof TermQuery) {
                TermQuery termQuery = (TermQuery)composingQuery;
                fieldCollection.addStringFieldName(termQuery.getTerm().field());
                continue;
            }
            if (composingQuery instanceof PhraseQuery) {
                phraseQuery = (PhraseQuery)composingQuery;
                fieldCollection.addStringFieldName(phraseQuery.getTerms()[0].field());
                continue;
            }
            if (!(composingQuery instanceof MultiPhraseQuery)) continue;
            phraseQuery = (MultiPhraseQuery)composingQuery;
            fieldCollection.addStringFieldName(((Term[])phraseQuery.getTermArrays().get(0))[0].field());
        }
        return fieldCollection;
    }

    private static void collectComposingQueries(Query query, Set<Query> composingQueries) {
        if (query instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query;
            for (BooleanClause clause : booleanQuery.clauses()) {
                FieldNameCollector.collectComposingQueries(clause.getQuery(), composingQueries);
            }
        } else if (query instanceof DisjunctionMaxQuery) {
            DisjunctionMaxQuery disjunctionMaxQuery = (DisjunctionMaxQuery)query;
            for (Query subQuery : disjunctionMaxQuery.getDisjuncts()) {
                FieldNameCollector.collectComposingQueries(subQuery, composingQueries);
            }
        } else if (query instanceof ConstantScoreQuery) {
            ConstantScoreQuery constantScoreQuery = (ConstantScoreQuery)query;
            if (constantScoreQuery.getQuery() != null) {
                FieldNameCollector.collectComposingQueries(constantScoreQuery.getQuery(), composingQueries);
            }
        } else {
            composingQueries.add(query);
        }
    }

    public static class FieldCollection {
        private final Set<String> numericFieldNames = new HashSet<String>();
        private final Set<String> stringFieldNames = new HashSet<String>();

        void addNumericFieldName(String fieldName) {
            this.numericFieldNames.add(fieldName);
        }

        void addStringFieldName(String fieldName) {
            this.stringFieldNames.add(fieldName);
        }

        public Set<String> getNumericFieldNames() {
            return this.numericFieldNames;
        }

        public Set<String> getStringFieldNames() {
            return this.stringFieldNames;
        }

        public String toString() {
            return "FieldCollection{numericFieldNames=" + this.numericFieldNames + ", stringFieldNames=" + this.stringFieldNames + '}';
        }
    }
}

