/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.util;

import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500PrivateCredential;
import org.ietf.jgss.GSSCredential;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.GSSKerberosCredential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.credential.X509CertificateChainPublicCredential;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;

public final class EnvironmentUtils {
    public static final String EJB_REMOTE_CONNECTIONS = "remote.connections";
    public static final String EJB_REMOTE_CONNECTION_PREFIX = "remote.connection.";
    public static final String EJB_REMOTE_CONNECTION_PROVIDER_PREFIX = "remote.connectionprovider.create.options.";
    public static final String CONNECT_OPTIONS = "connect.options.";
    public static final String EJB_HOST_KEY = "host";
    public static final String EJB_PORT_KEY = "port";
    public static final String EJB_CALLBACK_HANDLER_CLASS_KEY = "callback.handler.class";
    public static final String EJB_USERNAME_KEY = "username";
    public static final String EJB_PASSWORD_KEY = "password";
    public static final String EJB_PASSWORD_BASE64_KEY = "password.base64";

    private EnvironmentUtils() {
    }

    public static IdentityCredentials getSecurityCredentials(Map<String, ?> env) {
        return EnvironmentUtils.getSecurityCredentials(env, "java.naming.security.credentials");
    }

    public static IdentityCredentials getSecurityCredentials(Map<String, ?> env, String propertyName) {
        Assert.checkNotNullParam("env", env);
        Assert.checkNotNullParam("propertyName", propertyName);
        Object rawCredential = env.get(propertyName);
        if (rawCredential == null) {
            return null;
        }
        if (rawCredential instanceof IdentityCredentials) {
            return (IdentityCredentials)rawCredential;
        }
        if (rawCredential instanceof Collection) {
            IdentityCredentials c = IdentityCredentials.NONE;
            for (Object item : (Collection)rawCredential) {
                c = c.with(EnvironmentUtils.getSingleCredential(item));
            }
            return c;
        }
        if (rawCredential instanceof Object[]) {
            IdentityCredentials c = IdentityCredentials.NONE;
            for (Object item : (Object[])rawCredential) {
                c = c.with(EnvironmentUtils.getSingleCredential(item));
            }
            return c;
        }
        return EnvironmentUtils.getSingleCredential(rawCredential);
    }

    private static IdentityCredentials getSingleCredential(Object rawCredential) {
        if (rawCredential == null) {
            return IdentityCredentials.NONE;
        }
        if (rawCredential instanceof Credential) {
            return IdentityCredentials.NONE.withCredential((Credential)rawCredential);
        }
        if (rawCredential instanceof GSSCredential) {
            return IdentityCredentials.NONE.withCredential(new GSSKerberosCredential((GSSCredential)rawCredential));
        }
        if (rawCredential instanceof Password) {
            return IdentityCredentials.NONE.withCredential(new PasswordCredential((Password)rawCredential));
        }
        if (rawCredential instanceof X509Certificate) {
            return IdentityCredentials.NONE.withCredential(new X509CertificateChainPublicCredential((X509Certificate)rawCredential));
        }
        if (rawCredential instanceof X509Certificate[]) {
            return IdentityCredentials.NONE.withCredential(new X509CertificateChainPublicCredential((X509Certificate[])rawCredential));
        }
        if (rawCredential instanceof X500PrivateCredential) {
            X500PrivateCredential credential = (X500PrivateCredential)rawCredential;
            return IdentityCredentials.NONE.withCredential(new X509CertificateChainPrivateCredential(credential.getPrivateKey(), credential.getCertificate()));
        }
        if (rawCredential instanceof String) {
            return IdentityCredentials.NONE.withCredential(new PasswordCredential(ClearPassword.createRaw("clear", ((String)rawCredential).toCharArray())));
        }
        if (rawCredential instanceof char[]) {
            return IdentityCredentials.NONE.withCredential(new PasswordCredential(ClearPassword.createRaw("clear", (char[])rawCredential)));
        }
        if (rawCredential instanceof byte[]) {
            return IdentityCredentials.NONE.withCredential(new PasswordCredential(ClearPassword.createRaw("clear", new String((byte[])rawCredential, StandardCharsets.UTF_8).toCharArray())));
        }
        return IdentityCredentials.NONE;
    }

    public static String getSecurityRealmName(Map<String, ?> env) {
        Object rawRealm = env.get("java.naming.security.sasl.realm");
        return rawRealm instanceof String ? (String)rawRealm : null;
    }

    public static List<String> getURLPackagePrefixes(Map<String, ?> env) {
        return EnvironmentUtils.getURLPackagePrefixes(env, "java.naming.factory.url.pkgs");
    }

    public static List<String> getURLPackagePrefixes(Map<String, ?> env, String propertyName) {
        String prefixes;
        Assert.checkNotNullParam("env", env);
        Assert.checkNotNullParam("propertyName", propertyName);
        ArrayList<String> list = new ArrayList<String>();
        Object prefixesObj = env.get(propertyName);
        if (prefixesObj instanceof String && !(prefixes = (String)prefixesObj).isEmpty()) {
            String[] split;
            for (String s : split = prefixes.split(":")) {
                if (s.isEmpty()) continue;
                list.add(s);
            }
        }
        list.add("com.sun.jndi.url");
        return list;
    }

    public static String compileURLPackagePrefixes(Collection<String> prefixes) {
        Assert.checkNotNullParam("prefixes", prefixes);
        Iterator<String> iterator = prefixes.iterator();
        while (iterator.hasNext()) {
            String firstName = iterator.next();
            if (firstName == null || firstName.isEmpty() || firstName.equals("com.sun.jndi.url")) continue;
            while (iterator.hasNext()) {
                String nextName = iterator.next();
                if (nextName == null || nextName.isEmpty() || nextName.equals("com.sun.jndi.url")) continue;
                StringBuilder b = new StringBuilder();
                b.append(firstName);
                b.append(':').append(nextName);
                while (iterator.hasNext()) {
                    nextName = iterator.next();
                    if (nextName == null || nextName.isEmpty() || nextName.equals("com.sun.jndi.url")) continue;
                    b.append(':').append(nextName);
                }
                return b.toString();
            }
            return firstName;
        }
        return null;
    }
}

