/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.compiled;

import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.reteoo.compiled.SwitchCompilerHandler;
import org.drools.core.rule.IndexableConstraint;

public class AssertHandler
extends SwitchCompilerHandler {
    private final boolean alphaNetContainsHashedField;
    private final String factClassName;

    AssertHandler(StringBuilder builder, String factClassName) {
        this(builder, factClassName, false);
    }

    public AssertHandler(StringBuilder builder, String factClassName, boolean alphaNetContainsHashedField) {
        super(builder);
        this.factClassName = factClassName;
        this.alphaNetContainsHashedField = alphaNetContainsHashedField;
    }

    @Override
    public void startObjectTypeNode(ObjectTypeNode objectTypeNode) {
        this.builder.append(ASSERT_METHOD_SIGNATURE).append("\n");
        if (this.alphaNetContainsHashedField) {
            this.builder.append(this.factClassName).append(" ").append("fact").append(" = (").append(this.factClassName).append(")").append("handle").append(".getObject();").append("\n");
        }
    }

    @Override
    public void startBetaNode(BetaNode betaNode) {
        this.builder.append(this.getVariableName(betaNode)).append(".assertObject(").append("handle").append(",").append("context").append(",").append("wm").append(");").append("\n");
    }

    @Override
    public void startWindowNode(WindowNode windowNode) {
        this.builder.append(this.getVariableName(windowNode)).append(".assertObject(").append("handle").append(",").append("context").append(",").append("wm").append(");").append("\n");
    }

    @Override
    public void startLeftInputAdapterNode(LeftInputAdapterNode leftInputAdapterNode) {
        this.builder.append(this.getVariableName(leftInputAdapterNode)).append(".assertObject(").append("handle").append(",").append("context").append(",").append("wm").append(");").append("\n");
    }

    @Override
    public void startNonHashedAlphaNode(AlphaNode alphaNode) {
        this.builder.append("if ( ").append(this.getVariableName(alphaNode)).append(".isAllowed(").append("handle").append(",").append("wm").append(") ) {").append("\n");
    }

    @Override
    public void endNonHashedAlphaNode(AlphaNode alphaNode) {
        this.builder.append("}").append("\n");
    }

    @Override
    public void startHashedAlphaNodes(IndexableConstraint indexableConstraint) {
        this.generateSwitch(indexableConstraint);
    }

    @Override
    public void startHashedAlphaNode(AlphaNode hashedAlpha, Object hashedValue) {
        this.generateSwitchCase(hashedAlpha, hashedValue);
    }

    @Override
    public void endHashedAlphaNode(AlphaNode hashedAlpha, Object hashedValue) {
        this.builder.append("break;").append("\n");
    }

    @Override
    public void endHashedAlphaNodes(IndexableConstraint indexableConstraint) {
        this.builder.append("}").append("\n");
        this.builder.append("}").append("\n");
    }

    @Override
    public void endObjectTypeNode(ObjectTypeNode objectTypeNode) {
        this.builder.append("}").append("\n");
    }

    @Override
    public void nullCaseAlphaNodeStart(AlphaNode hashedAlpha) {
        super.nullCaseAlphaNodeStart(hashedAlpha);
    }
}

