/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.StringUtil;
import io.smallrye.config.inject.ConfigExtension;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigProducerUtil {
    private ConfigProducerUtil() {
    }

    public static <T> Optional<T> optionalConfigValue(InjectionPoint injectionPoint, Config config) {
        Type type = injectionPoint.getAnnotated().getBaseType();
        Class<T> valueType = ConfigProducerUtil.resolveValueType(type);
        return Optional.ofNullable(ConfigProducerUtil.getValue(injectionPoint, valueType, config));
    }

    private static <T> Class<T> resolveValueType(Type type) {
        Class valueType;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            valueType = ConfigProducerUtil.unwrapType(typeArguments[0]);
        } else {
            valueType = String.class;
        }
        return valueType;
    }

    public static <C extends Collection<T>, T> C collectionConfigProperty(InjectionPoint injectionPoint, Config config, C collection) {
        String[] split;
        Type type = injectionPoint.getAnnotated().getBaseType();
        Class<T> valueType = ConfigProducerUtil.resolveValueType(type);
        String stringValue = ConfigProducerUtil.getValue(injectionPoint, String.class, config);
        for (String aSplit : split = StringUtil.split(stringValue)) {
            T item = ((SmallRyeConfig)config).convert(aSplit, valueType);
            collection.add(item);
        }
        return collection;
    }

    private static <T> Class<T> unwrapType(Type type) {
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return (Class)type;
    }

    public static <T> T getValue(InjectionPoint injectionPoint, Class<T> target, Config config) {
        String name = ConfigProducerUtil.getName(injectionPoint);
        try {
            if (name == null) {
                return null;
            }
            Optional optionalValue = config.getOptionalValue(name, target);
            if (optionalValue.isPresent()) {
                return optionalValue.get();
            }
            String defaultValue = ConfigProducerUtil.getDefaultValue(injectionPoint);
            if (defaultValue != null && !defaultValue.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
                return ((SmallRyeConfig)config).convert(defaultValue, target);
            }
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static String getName(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ConfigProperty.class)) continue;
            ConfigProperty configProperty = (ConfigProperty)qualifier;
            return ConfigExtension.getConfigKey(injectionPoint, configProperty);
        }
        return null;
    }

    private static String getDefaultValue(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ConfigProperty.class)) continue;
            return ((ConfigProperty)qualifier).defaultValue();
        }
        return null;
    }
}

