/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.property;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.property.GetProperty;
import org.apache.tools.ant.property.ParseProperties;

public class ResolvePropertyMap
implements GetProperty {
    private final Set seen = new HashSet();
    private final ParseProperties parseProperties;
    private final GetProperty master;
    private Map map;
    private String prefix;
    private boolean prefixValues = false;
    private boolean expandingLHS = true;

    public ResolvePropertyMap(Project project, GetProperty master, Collection expanders) {
        this.master = master;
        this.parseProperties = new ParseProperties(project, expanders, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String name) {
        if (this.seen.contains(name)) {
            throw new BuildException("Property " + name + " was circularly " + "defined.");
        }
        try {
            Object masterValue;
            String fullKey = name;
            if (this.prefix != null && (this.expandingLHS || this.prefixValues)) {
                fullKey = this.prefix + name;
            }
            if ((masterValue = this.master.getProperty(fullKey)) != null) {
                Object object = masterValue;
                return object;
            }
            this.seen.add(name);
            this.expandingLHS = false;
            Object object = this.parseProperties.parseProperties((String)this.map.get(name));
            return object;
        }
        finally {
            this.seen.remove(name);
        }
    }

    public void resolveAllProperties(Map map) {
        this.resolveAllProperties(map, null, false);
    }

    public void resolveAllProperties(Map map, String prefix) {
        this.resolveAllProperties(map, null, false);
    }

    public void resolveAllProperties(Map map, String prefix, boolean prefixValues) {
        this.map = map;
        this.prefix = prefix;
        this.prefixValues = prefixValues;
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            this.expandingLHS = true;
            String key = (String)i.next();
            Object result = this.getProperty(key);
            String value = result == null ? "" : result.toString();
            map.put(key, value);
        }
    }
}

