#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 network-uri
version:              2.6.4.1
visibility:           public
id:                   network-uri-2.6.4.1-FvgDgWAahTMJnOZjiFXR50
key:                  network-uri-2.6.4.1-FvgDgWAahTMJnOZjiFXR50
license:              BSD-3-Clause
maintainer:           ezra@ezrakilty.net
homepage:             https://github.com/haskell/network-uri
synopsis:             URI manipulation
description:
    This package provides facilities for parsing and unparsing URIs, and creating
    and resolving relative URI references, closely following the URI spec,
    <http://www.ietf.org/rfc/rfc3986.txt IETF RFC 3986>.

    == Backward-compatibility

    In @network-2.6@ the "Network.URI" module was split off from the
    @network@ package into this package. If you'\''re using the "Network.URI"
    module you can be backward compatible and automatically get it from
    the right package by using the
    </package/network-uri-flag network-uri-flag pseudo-package>
    in your @.cabal@ file'\''s build-depends (along with dependencies for
    both @network-uri@ and @network@):

    >  build-depends:
    >     network-uri-flag == 0.1.*

    Or you can do the same manually by adding this boilerplate to your
    @.cabal@ file:

    > flag network-uri
    >   description: Get Network.URI from the network-uri package
    >   default: True
    >
    > library
    >   -- ...
    >   if flag(network-uri)
    >     build-depends: network-uri >= 2.6, network >= 2.6
    >   else
    >     build-depends: network-uri < 2.6, network < 2.6

    That is, get the module from either @network < 2.6@ or from
    @network-uri >= 2.6@.

category:             Network
abi:                  a562769543d784a6b58c1be4b0631572
exposed:              True
exposed-modules:      Network.URI Network.URI.Lens Network.URI.Static
import-dirs:          /usr/lib/ghc-8.10.5/site-local/network-uri-2.6.4.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/network-uri-2.6.4.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/network-uri-2.6.4.1
hs-libraries:         HSnetwork-uri-2.6.4.1-FvgDgWAahTMJnOZjiFXR50
depends:
    base-4.14.2.0 deepseq-1.4.4.0 parsec-3.1.14.0
    template-haskell-2.16.0.0 th-compat-0.1.2-GJSXJrEB3aI5eX2Gih7Wmp

haddock-interfaces:   /usr/share/doc/haskell-network-uri/html/network-uri.haddock
haddock-html:         /usr/share/doc/haskell-network-uri/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

