#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 ghc-trace-events
version:              0.1.2.3
visibility:           public
id:                   ghc-trace-events-0.1.2.3-FS1kQkOTIe05PnsvbgFQ3Z
key:                  ghc-trace-events-0.1.2.3-FS1kQkOTIe05PnsvbgFQ3Z
license:              BSD-3-Clause
copyright:            Copyright (C) 2018-2021 Mitsutoshi Aoe
maintainer:           Mitsutoshi Aoe <me@maoe.name>
author:               Mitsutoshi Aoe
homepage:             https://github.com/maoe/ghc-trace-events
synopsis:
    Faster traceEvent and traceMarker, and binary object logging for
    eventlog

description:
    ghc-trace-events provides faster traceEvent and traceMarker as well
    as arbitrary binary object logging for the eventlog framework. Unlike the
    <http://hackage.haskell.org/package/base/docs/Debug-Trace.html#g:2 eventlog tracing functions in base>,
    all the tracing functions in this library don'\''t evaluate the input if user
    event logging (the
    <https://downloads.haskell.org/~ghc/latest/docs/html/users_guide/runtime_control.html#rts-flag--l%20⟨flags⟩ -lu>
    flag) is disabled, which can give a significant boost in performance. Take a
    look at the benchmark suite for the details.

    This library provies the following modules:

    ["Debug.Trace.String"] Drop-in replacements for the event tracing functions in
    "Debug.Trace".
    ["Debug.Trace.ByteString"] UTF-8 encoded '\''ByteString'\'' variant
    of the event tracing functions in "Debug.Trace". It'\''s faster than the '\''String'\''
    variant.
    ["Debug.Trace.Text"] '\''Text'\'' variant of the event tracing functions
    in "Debug.Trace". It'\''s faster than the '\''String'\'' variant.
    ["Debug.Trace.Binary"] Arbitary binary object logging available for GHC 8.8 or
    later. Unlike the other tracing functions '\''Debug.Trace.Binary.traceBinaryEvent'\''
    takes an arbitrary '\''ByteString'\'' object as opposed to a UTF-8
    encoded string.

category:             Development, GHC, Trace
abi:                  a95536730578860c67738b65f9c1f7a5
exposed:              True
exposed-modules:
    Debug.Trace.Binary Debug.Trace.ByteString Debug.Trace.Flags
    Debug.Trace.String Debug.Trace.Text

import-dirs:          /usr/lib/ghc-8.10.5/site-local/ghc-trace-events-0.1.2.3
library-dirs:         /usr/lib/ghc-8.10.5/site-local/ghc-trace-events-0.1.2.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/ghc-trace-events-0.1.2.3
hs-libraries:         HSghc-trace-events-0.1.2.3-FS1kQkOTIe05PnsvbgFQ3Z
depends:              base-4.14.2.0 bytestring-0.10.12.0 text-1.2.4.1
haddock-interfaces:
    /usr/share/doc/haskell-ghc-trace-events/html/ghc-trace-events.haddock

haddock-html:         /usr/share/doc/haskell-ghc-trace-events/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

