#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 cipher-aes128
version:              0.7.0.5
visibility:           public
id:                   cipher-aes128-0.7.0.5-7NkdduFyC317foaiNBpkFL
key:                  cipher-aes128-0.7.0.5-7NkdduFyC317foaiNBpkFL
license:              BSD-3-Clause
copyright:            Thomas M. DuBuisson
maintainer:           thomas.dubuisson@gmail.com
author:               Thomas M. DuBuisson, Vincent Hanquez (See AUTHORS file)
homepage:             https://github.com/TomMD/cipher-aes128
synopsis:             AES and common modes using AES-NI when available.
description:
    Cipher-aes128 is an implementation of AES and common modes of operation.  It borrows Hanquez'\''s C AES code (see '\''cipher-aes'\'') but
    is unique due to including compile-time detection of
    NI compiler support, a slightly more functional interface
    for GCM operations, exposure of '\''Ptr'\'' based operations via the .Internal module, and build-in crypto-api support.
    Cipher-aes128 was originally developed as "'\''cipher-aes'\'' plus trampolines", which has since been adopted into cipher-aes.

category:             Cryptography
abi:                  9abd34530e0b10e79e1316a2e8bb42c1
exposed:              True
exposed-modules:      Crypto.Cipher.AES128 Crypto.Cipher.AES128.Internal
import-dirs:          /usr/lib/ghc-8.10.5/site-local/cipher-aes128-0.7.0.5
library-dirs:         /usr/lib/ghc-8.10.5/site-local/cipher-aes128-0.7.0.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/cipher-aes128-0.7.0.5
hs-libraries:         HScipher-aes128-0.7.0.5-7NkdduFyC317foaiNBpkFL
depends:
    base-4.14.2.0 bytestring-0.10.12.0
    cereal-0.5.8.1-4r85zOZIbEW4fo8WFnBuTl
    crypto-api-0.13.3-8kK7ehsYBxqIrjHyd9ebTX
    tagged-0.8.6.1-F25vmSN4H5fEaMJYsLgYMV

haddock-interfaces:
    /usr/share/doc/haskell-cipher-aes128/html/cipher-aes128.haddock

haddock-html:         /usr/share/doc/haskell-cipher-aes128/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

