/*
 * Decompiled with CFR 0.152.
 */
package gps.mvc;

import bt747.sys.Generic;
import bt747.sys.interfaces.BT747Exception;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747Thread;
import gps.GpsEvent;
import gps.ProtocolConstants;
import gps.mvc.CmdParam;
import gps.mvc.DeviceControllerIF;
import gps.mvc.DeviceOperationHandlerIF;
import gps.mvc.GpsLinkHandler;
import gps.mvc.GpsModel;
import gps.mvc.HoluxController;
import gps.mvc.MtkController;
import gps.mvc.MtkModel;
import gps.mvc.ProtectedDevControllerIF;
import gps.mvc.SkytraqController;
import gps.mvc.WPController;

public class GpsController
implements BT747Thread,
ProtocolConstants,
DeviceControllerIF {
    private final GpsModel gpsM;
    private MtkModel mtkM;
    private ProtectedDevControllerIF mtkC;
    private final GpsLinkHandler handler;
    private int protocol = -1;
    private boolean eraseRequested;
    private int nextValueToCheck = 0;
    private volatile DeviceOperationHandlerIF operationHandler;
    private int nextRun = 0;
    private int nextAvailableRun = 0;

    public static final GpsController getInstance(GpsModel gpsModel, int n) {
        return new GpsController(gpsModel, n);
    }

    private GpsController(GpsModel gpsModel, int n) {
        this.gpsM = gpsModel;
        this.mtkM = this.gpsM.getMtkModel();
        this.setProtocol(n);
        this.handler = this.gpsM.getHandler();
    }

    public final void setProtocol(int n) {
        if (this.protocol != n && this.mtkC != null) {
            if (this.handler.isConnected()) {
                this.handler.getGPSRxtx().closePort();
            }
            this.mtkC = null;
        }
        this.mtkM = this.gpsM.getMtkModel();
        if (this.mtkC != null) {
            return;
        }
        this.protocol = n;
        switch (this.protocol) {
            default: {
                this.mtkC = new MtkController(this, this.mtkM);
                return;
            }
            case 2: {
                this.mtkC = new HoluxController(this, this.mtkM, true);
                return;
            }
            case 5: {
                this.mtkC = new HoluxController(this, this.mtkM, false);
                return;
            }
            case 1: {
                this.mtkC = new WPController(this, this.mtkM);
                return;
            }
            case 4: 
        }
        this.mtkC = new SkytraqController(this, this.mtkM);
    }

    public final MtkController getMtkController() {
        return (MtkController)this.mtkC;
    }

    public final void setGpsDecode(boolean bl) {
        this.gpsM.setGpsDecode(bl);
    }

    public final void setDataNeeded(int n) {
        int n2;
        if (this.handler.isConnected() && this.mtkM.isDataNeedsRequest(n2 = Generic.getTimeStamp(), n)) {
            this.mtkC.reqData(n);
        }
        if (Generic.isDebug() && Generic.getDebugLevel() >= 3) {
            Generic.debug("Data request of " + n + " skipped");
        }
    }

    public final void setDownloadTimeOut(int n) {
        this.handler.setDownloadTimeOut(n);
    }

    public final void reqStatus() {
        this.setDataNeeded(3);
        GpsController gpsController = this;
        gpsController.setDataNeeded(0);
        gpsController.setDataNeeded(2);
        gpsController.mtkC.reqData(18);
        gpsController.setDataNeeded(8);
        gpsController.setDataNeeded(1);
        this.mtkC.reqData(10);
        this.setDataNeeded(17);
    }

    public final void reqLogOnOffStatus() {
        this.mtkC.reqData(7);
    }

    public final void eraseLog() {
        this.eraseRequested = true;
        this.mtkM.setEraseOngoing(true);
    }

    public final void stopErase() {
        this.eraseRequested = false;
        this.mtkC.cmd(12);
    }

    public final void initConnection() {
        if (this.handler.isConnected()) {
            this.nextRun = Generic.getTimeStamp() + 300;
            GpsController gpsController = this;
            gpsController.gpsM.setAllUnavailable();
            gpsController.nextValueToCheck = 0;
            this.handler.initConnected();
            Generic.addThread(this, false);
        }
    }

    public final void setDeviceOperationHandler(DeviceOperationHandlerIF deviceOperationHandlerIF) {
        this.operationHandler = deviceOperationHandlerIF;
    }

    @Override
    public final void run() {
        try {
            block15: {
                ProtectedDevControllerIF protectedDevControllerIF;
                block16: {
                    int n;
                    block18: {
                        block17: {
                            n = Generic.getTimeStamp();
                            protectedDevControllerIF = this.mtkC;
                            if (n < this.nextRun) break block15;
                            this.nextRun = n + 10;
                            if (!this.handler.isConnected()) break block16;
                            try {
                                protectedDevControllerIF.notifyRun();
                            }
                            catch (BT747Exception bT747Exception) {
                                this.operationHandler = null;
                                Generic.debug("Controller: ", bT747Exception);
                                this.gpsM.postEvent(new GpsEvent(38, bT747Exception));
                            }
                            DeviceOperationHandlerIF deviceOperationHandlerIF = this.operationHandler;
                            if (deviceOperationHandlerIF != null) {
                                try {
                                    if (!deviceOperationHandlerIF.notifyRun(this.handler)) {
                                        this.operationHandler = null;
                                    }
                                }
                                catch (BT747Exception bT747Exception) {
                                    this.operationHandler = null;
                                    Generic.debug("Handler: ", bT747Exception);
                                    this.gpsM.postEvent(new GpsEvent(38, bT747Exception));
                                }
                            }
                            deviceOperationHandlerIF = this.operationHandler;
                            Object object = this.handler.getResponse();
                            if (object == null) break block17;
                            if (deviceOperationHandlerIF != null && deviceOperationHandlerIF.analyseResponse(object)) break block18;
                            this.gpsM.analyseResponse(object);
                        }
                        this.handler.checkSendCmdFromQueue();
                    }
                    if (this.nextAvailableRun < n && this.handler.getOutStandingCmdsCount() == 0 && !this.mtkM.isLogDownloadOngoing()) {
                        if (this.eraseRequested) {
                            this.eraseRequested = false;
                            protectedDevControllerIF.cmd(13);
                        }
                        this.nextAvailableRun = this.nextRun + 300;
                        GpsController gpsController = this;
                        int n2 = gpsController.nextValueToCheck;
                        gpsController.setDataNeeded(n2);
                        if (++n2 > 9) {
                            n2 = 0;
                        }
                        gpsController.nextValueToCheck = n2;
                    }
                    return;
                }
                Generic.removeThread(this);
                protectedDevControllerIF.notifyDisconnected();
            }
            return;
        }
        catch (Exception exception) {
            Generic.debug("Exception in Controller run", exception);
            return;
        }
    }

    @Override
    public final void started() {
    }

    @Override
    public final void stopped() {
    }

    @Override
    public final boolean cmd(int n) {
        return this.mtkC.cmd(n);
    }

    @Override
    public final boolean cmd(int n, CmdParam cmdParam) {
        return this.mtkC.cmd(n, cmdParam);
    }

    public final void setAgpsData(byte[] byArray) {
        this.mtkC.setAgpsData(byArray);
    }

    @Override
    public final void getLog(BT747Path bT747Path) {
        this.mtkC.getLog(bT747Path);
    }
}

