_uu-uniq() {
    local i cur prev opts cmd
    COMPREPLY=()
    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
        cur="$2"
    else
        cur="${COMP_WORDS[COMP_CWORD]}"
    fi
    prev="$3"
    cmd=""
    opts=""

    for i in "${COMP_WORDS[@]:0:COMP_CWORD}"
    do
        case "${cmd},${i}" in
            ",$1")
                cmd="uu__uniq"
                ;;
            *)
                ;;
        esac
    done

    case "${cmd}" in
        uu__uniq)
            opts="-D -w -c -i -d -s -f -u -z -h -V --all-repeated --group --check-chars --count --ignore-case --repeated --skip-chars --skip-fields --unique --zero-terminated --help --version [files]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 1 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --all-repeated)
                    COMPREPLY=($(compgen -W "none prepend separate" -- "${cur}"))
                    return 0
                    ;;
                -D)
                    COMPREPLY=($(compgen -W "none prepend separate" -- "${cur}"))
                    return 0
                    ;;
                --group)
                    COMPREPLY=($(compgen -W "separate prepend append both" -- "${cur}"))
                    return 0
                    ;;
                --check-chars)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -w)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --skip-chars)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -s)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --skip-fields)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -f)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
    esac
}

if [[ "${BASH_VERSINFO[0]}" -eq 4 && "${BASH_VERSINFO[1]}" -ge 4 || "${BASH_VERSINFO[0]}" -gt 4 ]]; then
    complete -F _uu-uniq -o nosort -o bashdefault -o default uu-uniq
else
    complete -F _uu-uniq -o bashdefault -o default uu-uniq
fi
