/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.checkerframework.checker.nullness;

import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.hadoop.shaded.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.apache.hadoop.shaded.org.checkerframework.checker.nullness.qual.NonNull;
import org.apache.hadoop.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public final class Opt {
    private Opt() {
        throw new AssertionError((Object)"shouldn't be instantiated");
    }

    public static <T> @NonNull T get(T primary2) {
        if (primary2 == null) {
            throw new NoSuchElementException("No value present");
        }
        return primary2;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    public static boolean isPresent(@Nullable Object primary2) {
        return primary2 != null;
    }

    public static <T> void ifPresent(T primary2, Consumer<@NonNull ? super @NonNull T> consumer) {
        if (primary2 != null) {
            consumer.accept(primary2);
        }
    }

    public static <T> @Nullable T filter(T primary2, Predicate<@NonNull ? super @NonNull T> predicate) {
        if (primary2 == null) {
            return null;
        }
        return (T)(predicate.test(primary2) ? primary2 : null);
    }

    public static <T, U> @Nullable U map(T primary2, Function<@NonNull ? super @NonNull T, ? extends U> mapper) {
        if (primary2 == null) {
            return null;
        }
        return mapper.apply(primary2);
    }

    public static <T> @NonNull T orElse(T primary2, @NonNull T other) {
        return primary2 != null ? primary2 : other;
    }

    public static <T> @NonNull T orElseGet(T primary2, Supplier<? extends @NonNull T> other) {
        return primary2 != null ? primary2 : other.get();
    }

    public static <T, X extends Throwable> @NonNull T orElseThrow(T primary2, Supplier<? extends @NonNull X> exceptionSupplier) throws X {
        if (primary2 != null) {
            return primary2;
        }
        throw (Throwable)exceptionSupplier.get();
    }
}

