# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_rattler_build_global_optspecs
	string join \n v/verbose q/quiet log-style= wrap-log-lines= color= h/help V/version
end

function __fish_rattler_build_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_rattler_build_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_rattler_build_using_subcommand
	set -l cmd (__fish_rattler_build_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c rattler-build -n "__fish_rattler_build_needs_command" -l log-style -d 'Logging style' -r -f -a "{fancy\t'Use fancy logging output',json\t'Use JSON logging output',plain\t'Use plain logging output'}"
complete -c rattler-build -n "__fish_rattler_build_needs_command" -l wrap-log-lines -d 'Wrap log lines at the terminal width. This is automatically disabled on CI (by detecting the `CI` environment variable)' -r -f -a "{true\t'',false\t''}"
complete -c rattler-build -n "__fish_rattler_build_needs_command" -l color -d 'Enable or disable colored output from rattler-build. Also honors the `CLICOLOR` and `CLICOLOR_FORCE` environment variable' -r -f -a "{always\t'Always use colors',never\t'Never use colors',auto\t'Use colors when the output is a terminal'}"
complete -c rattler-build -n "__fish_rattler_build_needs_command" -s v -l verbose -d 'Increase logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_needs_command" -s q -l quiet -d 'Decrease logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_needs_command" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rattler-build -n "__fish_rattler_build_needs_command" -s V -l version -d 'Print version'
complete -c rattler-build -n "__fish_rattler_build_needs_command" -f -a "build" -d 'Build a package from a recipe'
complete -c rattler-build -n "__fish_rattler_build_needs_command" -f -a "test" -d 'Run a test for a single package'
complete -c rattler-build -n "__fish_rattler_build_needs_command" -f -a "rebuild" -d 'Rebuild a package from a package file instead of a recipe'
complete -c rattler-build -n "__fish_rattler_build_needs_command" -f -a "upload" -d 'Upload a package'
complete -c rattler-build -n "__fish_rattler_build_needs_command" -f -a "completion" -d 'Generate shell completion script'
complete -c rattler-build -n "__fish_rattler_build_needs_command" -f -a "generate-recipe" -d 'Generate a recipe from PyPI or CRAN'
complete -c rattler-build -n "__fish_rattler_build_needs_command" -f -a "auth" -d 'Handle authentication to external channels'
complete -c rattler-build -n "__fish_rattler_build_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -s r -l recipe -d 'The recipe file or directory containing `recipe.yaml`. Defaults to the current directory' -r -F
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l recipe-dir -d 'The directory that contains recipes' -r -F
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l up-to -d 'Build recipes up to the specified package' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l build-platform -d 'The build platform to use for the build (e.g. for building with emulation, or rendering)' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l target-platform -d 'The target platform for the build' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l host-platform -d 'The host platform for the build. If set, it will be used to determine also the target_platform (as long as it is not noarch)' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -s c -l channel -d 'Add a channel to search for dependencies in' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -s m -l variant-config -d 'Variant configuration files for the build' -r -F
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l package-format -d 'The package format to use for the build. Can be one of `tar-bz2` or `conda`. You can also add a compression level to the package format, e.g. `tar-bz2:<number>` (from 1 to 9) or `conda:<number>` (from -7 to 22).' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l compression-threads -d 'The number of threads to use for compression (only relevant when also using `--package-format conda`)' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l output-dir -d 'Output directory for build artifacts.' -r -F
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l auth-file -d 'Path to an auth-file to read authentication information from' -r -F
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l skip-existing -d 'Whether to skip packages that already exist in any channel If set to `none`, do not skip any packages, default when not specified. If set to `local`, only skip packages that already exist locally, default when using `--skip-existing. If set to `all`, skip packages that already exist in any channel' -r -f -a "{none\t'Do not skip any packages',local\t'Skip packages that already exist locally',all\t'Skip packages that already exist in any channel'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l extra-meta -d 'Extra metadata to include in about.json' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l log-style -d 'Logging style' -r -f -a "{fancy\t'Use fancy logging output',json\t'Use JSON logging output',plain\t'Use plain logging output'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l wrap-log-lines -d 'Wrap log lines at the terminal width. This is automatically disabled on CI (by detecting the `CI` environment variable)' -r -f -a "{true\t'',false\t''}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l color -d 'Enable or disable colored output from rattler-build. Also honors the `CLICOLOR` and `CLICOLOR_FORCE` environment variable' -r -f -a "{always\t'Always use colors',never\t'Never use colors',auto\t'Use colors when the output is a terminal'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l ignore-recipe-variants -d 'Do not read the `variants.yaml` file next to a recipe'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l render-only -d 'Render the recipe files without executing the build'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l with-solve -d 'Render the recipe files with solving dependencies'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l keep-build -d 'Keep intermediate build artifacts after the build'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l no-build-id -d 'Don\'t use build id(timestamp) when creating build directory name'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l no-include-recipe -d 'Don\'t store the recipe in the final package'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l no-test -d 'Don\'t run the tests after building the package'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l color-build-log -d 'Don\'t force colors in the output of the build script'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l use-zstd -d 'Enable support for repodata.json.zst'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l use-bz2 -d 'Enable support for repodata.json.bz2'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l experimental -d 'Enable experimental features'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -l tui -d 'Launch the terminal user interface'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -s v -l verbose -d 'Increase logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -s q -l quiet -d 'Decrease logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand build" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand test" -s c -l channel -d 'Channels to use when testing' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand test" -s p -l package-file -d 'The package file to test' -r -F
complete -c rattler-build -n "__fish_rattler_build_using_subcommand test" -l compression-threads -d 'The number of threads to use for compression' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand test" -l output-dir -d 'Output directory for build artifacts.' -r -F
complete -c rattler-build -n "__fish_rattler_build_using_subcommand test" -l auth-file -d 'Path to an auth-file to read authentication information from' -r -F
complete -c rattler-build -n "__fish_rattler_build_using_subcommand test" -l log-style -d 'Logging style' -r -f -a "{fancy\t'Use fancy logging output',json\t'Use JSON logging output',plain\t'Use plain logging output'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand test" -l wrap-log-lines -d 'Wrap log lines at the terminal width. This is automatically disabled on CI (by detecting the `CI` environment variable)' -r -f -a "{true\t'',false\t''}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand test" -l color -d 'Enable or disable colored output from rattler-build. Also honors the `CLICOLOR` and `CLICOLOR_FORCE` environment variable' -r -f -a "{always\t'Always use colors',never\t'Never use colors',auto\t'Use colors when the output is a terminal'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand test" -l use-zstd -d 'Enable support for repodata.json.zst'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand test" -l use-bz2 -d 'Enable support for repodata.json.bz2'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand test" -l experimental -d 'Enable experimental features'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand test" -s v -l verbose -d 'Increase logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand test" -s q -l quiet -d 'Decrease logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand test" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand rebuild" -s p -l package-file -d 'The package file to rebuild' -r -F
complete -c rattler-build -n "__fish_rattler_build_using_subcommand rebuild" -l compression-threads -d 'The number of threads to use for compression' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand rebuild" -l output-dir -d 'Output directory for build artifacts.' -r -F
complete -c rattler-build -n "__fish_rattler_build_using_subcommand rebuild" -l auth-file -d 'Path to an auth-file to read authentication information from' -r -F
complete -c rattler-build -n "__fish_rattler_build_using_subcommand rebuild" -l log-style -d 'Logging style' -r -f -a "{fancy\t'Use fancy logging output',json\t'Use JSON logging output',plain\t'Use plain logging output'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand rebuild" -l wrap-log-lines -d 'Wrap log lines at the terminal width. This is automatically disabled on CI (by detecting the `CI` environment variable)' -r -f -a "{true\t'',false\t''}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand rebuild" -l color -d 'Enable or disable colored output from rattler-build. Also honors the `CLICOLOR` and `CLICOLOR_FORCE` environment variable' -r -f -a "{always\t'Always use colors',never\t'Never use colors',auto\t'Use colors when the output is a terminal'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand rebuild" -l no-test -d 'Do not run tests after building'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand rebuild" -l use-zstd -d 'Enable support for repodata.json.zst'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand rebuild" -l use-bz2 -d 'Enable support for repodata.json.bz2'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand rebuild" -l experimental -d 'Enable experimental features'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand rebuild" -s v -l verbose -d 'Increase logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand rebuild" -s q -l quiet -d 'Decrease logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand rebuild" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and not __fish_seen_subcommand_from quetz artifactory prefix anaconda conda-forge help" -l output-dir -d 'Output directory for build artifacts.' -r -F
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and not __fish_seen_subcommand_from quetz artifactory prefix anaconda conda-forge help" -l auth-file -d 'Path to an auth-file to read authentication information from' -r -F
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and not __fish_seen_subcommand_from quetz artifactory prefix anaconda conda-forge help" -l log-style -d 'Logging style' -r -f -a "{fancy\t'Use fancy logging output',json\t'Use JSON logging output',plain\t'Use plain logging output'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and not __fish_seen_subcommand_from quetz artifactory prefix anaconda conda-forge help" -l wrap-log-lines -d 'Wrap log lines at the terminal width. This is automatically disabled on CI (by detecting the `CI` environment variable)' -r -f -a "{true\t'',false\t''}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and not __fish_seen_subcommand_from quetz artifactory prefix anaconda conda-forge help" -l color -d 'Enable or disable colored output from rattler-build. Also honors the `CLICOLOR` and `CLICOLOR_FORCE` environment variable' -r -f -a "{always\t'Always use colors',never\t'Never use colors',auto\t'Use colors when the output is a terminal'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and not __fish_seen_subcommand_from quetz artifactory prefix anaconda conda-forge help" -l use-zstd -d 'Enable support for repodata.json.zst'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and not __fish_seen_subcommand_from quetz artifactory prefix anaconda conda-forge help" -l use-bz2 -d 'Enable support for repodata.json.bz2'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and not __fish_seen_subcommand_from quetz artifactory prefix anaconda conda-forge help" -l experimental -d 'Enable experimental features'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and not __fish_seen_subcommand_from quetz artifactory prefix anaconda conda-forge help" -s v -l verbose -d 'Increase logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and not __fish_seen_subcommand_from quetz artifactory prefix anaconda conda-forge help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and not __fish_seen_subcommand_from quetz artifactory prefix anaconda conda-forge help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and not __fish_seen_subcommand_from quetz artifactory prefix anaconda conda-forge help" -a "quetz" -d 'Upload to aQuetz server. Authentication is used from the keychain / auth-file'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and not __fish_seen_subcommand_from quetz artifactory prefix anaconda conda-forge help" -a "artifactory" -d 'Options for uploading to a Artifactory channel. Authentication is used from the keychain / auth-file'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and not __fish_seen_subcommand_from quetz artifactory prefix anaconda conda-forge help" -a "prefix" -d 'Options for uploading to a prefix.dev server. Authentication is used from the keychain / auth-file'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and not __fish_seen_subcommand_from quetz artifactory prefix anaconda conda-forge help" -a "anaconda" -d 'Options for uploading to a Anaconda.org server'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and not __fish_seen_subcommand_from quetz artifactory prefix anaconda conda-forge help" -a "conda-forge" -d 'Options for uploading to conda-forge'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and not __fish_seen_subcommand_from quetz artifactory prefix anaconda conda-forge help" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from quetz" -s u -l url -d 'The URL to your Quetz server' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from quetz" -s c -l channel -d 'The URL to your channel' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from quetz" -s a -l api-key -d 'The Quetz API key, if none is provided, the token is read from the keychain / auth-file' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from quetz" -l log-style -d 'Logging style' -r -f -a "{fancy\t'Use fancy logging output',json\t'Use JSON logging output',plain\t'Use plain logging output'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from quetz" -l wrap-log-lines -d 'Wrap log lines at the terminal width. This is automatically disabled on CI (by detecting the `CI` environment variable)' -r -f -a "{true\t'',false\t''}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from quetz" -l color -d 'Enable or disable colored output from rattler-build. Also honors the `CLICOLOR` and `CLICOLOR_FORCE` environment variable' -r -f -a "{always\t'Always use colors',never\t'Never use colors',auto\t'Use colors when the output is a terminal'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from quetz" -s v -l verbose -d 'Increase logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from quetz" -s q -l quiet -d 'Decrease logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from quetz" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from artifactory" -s u -l url -d 'The URL to your Artifactory server' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from artifactory" -s c -l channel -d 'The URL to your channel' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from artifactory" -s r -l username -d 'Your Artifactory username' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from artifactory" -s p -l password -d 'Your Artifactory password' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from artifactory" -l log-style -d 'Logging style' -r -f -a "{fancy\t'Use fancy logging output',json\t'Use JSON logging output',plain\t'Use plain logging output'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from artifactory" -l wrap-log-lines -d 'Wrap log lines at the terminal width. This is automatically disabled on CI (by detecting the `CI` environment variable)' -r -f -a "{true\t'',false\t''}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from artifactory" -l color -d 'Enable or disable colored output from rattler-build. Also honors the `CLICOLOR` and `CLICOLOR_FORCE` environment variable' -r -f -a "{always\t'Always use colors',never\t'Never use colors',auto\t'Use colors when the output is a terminal'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from artifactory" -s v -l verbose -d 'Increase logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from artifactory" -s q -l quiet -d 'Decrease logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from artifactory" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from prefix" -s u -l url -d 'The URL to the prefix.dev server (only necessary for self-hosted instances)' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from prefix" -s c -l channel -d 'The channel to upload the package to' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from prefix" -s a -l api-key -d 'The prefix.dev API key, if none is provided, the token is read from the keychain / auth-file' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from prefix" -l log-style -d 'Logging style' -r -f -a "{fancy\t'Use fancy logging output',json\t'Use JSON logging output',plain\t'Use plain logging output'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from prefix" -l wrap-log-lines -d 'Wrap log lines at the terminal width. This is automatically disabled on CI (by detecting the `CI` environment variable)' -r -f -a "{true\t'',false\t''}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from prefix" -l color -d 'Enable or disable colored output from rattler-build. Also honors the `CLICOLOR` and `CLICOLOR_FORCE` environment variable' -r -f -a "{always\t'Always use colors',never\t'Never use colors',auto\t'Use colors when the output is a terminal'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from prefix" -s v -l verbose -d 'Increase logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from prefix" -s q -l quiet -d 'Decrease logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from prefix" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from anaconda" -s o -l owner -d 'The owner of the distribution (e.g. conda-forge or your username)' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from anaconda" -s c -l channel -d 'The channel / label to upload the package to (e.g. main / rc)' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from anaconda" -s a -l api-key -d 'The Anaconda API key, if none is provided, the token is read from the keychain / auth-file' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from anaconda" -s u -l url -d 'The URL to the Anaconda server' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from anaconda" -l log-style -d 'Logging style' -r -f -a "{fancy\t'Use fancy logging output',json\t'Use JSON logging output',plain\t'Use plain logging output'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from anaconda" -l wrap-log-lines -d 'Wrap log lines at the terminal width. This is automatically disabled on CI (by detecting the `CI` environment variable)' -r -f -a "{true\t'',false\t''}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from anaconda" -l color -d 'Enable or disable colored output from rattler-build. Also honors the `CLICOLOR` and `CLICOLOR_FORCE` environment variable' -r -f -a "{always\t'Always use colors',never\t'Never use colors',auto\t'Use colors when the output is a terminal'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from anaconda" -s f -l force -d 'Replace files on conflict'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from anaconda" -s v -l verbose -d 'Increase logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from anaconda" -s q -l quiet -d 'Decrease logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from anaconda" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from conda-forge" -l staging-token -d 'The Anaconda API key' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from conda-forge" -l feedstock -d 'The feedstock name' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from conda-forge" -l feedstock-token -d 'The feedstock token' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from conda-forge" -l staging-channel -d 'The staging channel name' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from conda-forge" -l anaconda-url -d 'The Anaconda Server URL' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from conda-forge" -l validation-endpoint -d 'The validation endpoint url' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from conda-forge" -l provider -d 'The CI provider' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from conda-forge" -l log-style -d 'Logging style' -r -f -a "{fancy\t'Use fancy logging output',json\t'Use JSON logging output',plain\t'Use plain logging output'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from conda-forge" -l wrap-log-lines -d 'Wrap log lines at the terminal width. This is automatically disabled on CI (by detecting the `CI` environment variable)' -r -f -a "{true\t'',false\t''}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from conda-forge" -l color -d 'Enable or disable colored output from rattler-build. Also honors the `CLICOLOR` and `CLICOLOR_FORCE` environment variable' -r -f -a "{always\t'Always use colors',never\t'Never use colors',auto\t'Use colors when the output is a terminal'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from conda-forge" -l post-comment-on-error -d 'Post comment on promotion failure'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from conda-forge" -l dry-run -d 'Dry run, don\'t actually upload anything'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from conda-forge" -s v -l verbose -d 'Increase logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from conda-forge" -s q -l quiet -d 'Decrease logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from conda-forge" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from help" -f -a "quetz" -d 'Upload to aQuetz server. Authentication is used from the keychain / auth-file'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from help" -f -a "artifactory" -d 'Options for uploading to a Artifactory channel. Authentication is used from the keychain / auth-file'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from help" -f -a "prefix" -d 'Options for uploading to a prefix.dev server. Authentication is used from the keychain / auth-file'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from help" -f -a "anaconda" -d 'Options for uploading to a Anaconda.org server'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from help" -f -a "conda-forge" -d 'Options for uploading to conda-forge'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand upload; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand completion" -s s -l shell -d 'Specifies the shell for which the completions should be generated' -r -f -a "{bash\t'Bourne Again SHell (bash)',elvish\t'Elvish shell',fish\t'Friendly Interactive SHell (fish)',nushell\t'Nushell',powershell\t'PowerShell',zsh\t'Z SHell (zsh)'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand completion" -l log-style -d 'Logging style' -r -f -a "{fancy\t'Use fancy logging output',json\t'Use JSON logging output',plain\t'Use plain logging output'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand completion" -l wrap-log-lines -d 'Wrap log lines at the terminal width. This is automatically disabled on CI (by detecting the `CI` environment variable)' -r -f -a "{true\t'',false\t''}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand completion" -l color -d 'Enable or disable colored output from rattler-build. Also honors the `CLICOLOR` and `CLICOLOR_FORCE` environment variable' -r -f -a "{always\t'Always use colors',never\t'Never use colors',auto\t'Use colors when the output is a terminal'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand completion" -s v -l verbose -d 'Increase logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand completion" -s q -l quiet -d 'Decrease logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand completion" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and not __fish_seen_subcommand_from pypi cran help" -l log-style -d 'Logging style' -r -f -a "{fancy\t'Use fancy logging output',json\t'Use JSON logging output',plain\t'Use plain logging output'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and not __fish_seen_subcommand_from pypi cran help" -l wrap-log-lines -d 'Wrap log lines at the terminal width. This is automatically disabled on CI (by detecting the `CI` environment variable)' -r -f -a "{true\t'',false\t''}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and not __fish_seen_subcommand_from pypi cran help" -l color -d 'Enable or disable colored output from rattler-build. Also honors the `CLICOLOR` and `CLICOLOR_FORCE` environment variable' -r -f -a "{always\t'Always use colors',never\t'Never use colors',auto\t'Use colors when the output is a terminal'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and not __fish_seen_subcommand_from pypi cran help" -s v -l verbose -d 'Increase logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and not __fish_seen_subcommand_from pypi cran help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and not __fish_seen_subcommand_from pypi cran help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and not __fish_seen_subcommand_from pypi cran help" -f -a "pypi" -d 'Generate a recipe for a Python package from PyPI'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and not __fish_seen_subcommand_from pypi cran help" -f -a "cran" -d 'Generate a recipe for an R package from CRAN'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and not __fish_seen_subcommand_from pypi cran help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from pypi" -l log-style -d 'Logging style' -r -f -a "{fancy\t'Use fancy logging output',json\t'Use JSON logging output',plain\t'Use plain logging output'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from pypi" -l wrap-log-lines -d 'Wrap log lines at the terminal width. This is automatically disabled on CI (by detecting the `CI` environment variable)' -r -f -a "{true\t'',false\t''}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from pypi" -l color -d 'Enable or disable colored output from rattler-build. Also honors the `CLICOLOR` and `CLICOLOR_FORCE` environment variable' -r -f -a "{always\t'Always use colors',never\t'Never use colors',auto\t'Use colors when the output is a terminal'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from pypi" -s w -l write -d 'Whether to write the recipe to a folder'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from pypi" -s u -l use-mapping -d 'Whether to use the conda-forge PyPI name mapping'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from pypi" -s t -l tree -d 'Whether to generate recipes for all dependencies'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from pypi" -s v -l verbose -d 'Increase logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from pypi" -s q -l quiet -d 'Decrease logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from pypi" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from cran" -s u -l universe -d 'The R Universe to fetch the package from (defaults to `cran`)' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from cran" -l log-style -d 'Logging style' -r -f -a "{fancy\t'Use fancy logging output',json\t'Use JSON logging output',plain\t'Use plain logging output'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from cran" -l wrap-log-lines -d 'Wrap log lines at the terminal width. This is automatically disabled on CI (by detecting the `CI` environment variable)' -r -f -a "{true\t'',false\t''}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from cran" -l color -d 'Enable or disable colored output from rattler-build. Also honors the `CLICOLOR` and `CLICOLOR_FORCE` environment variable' -r -f -a "{always\t'Always use colors',never\t'Never use colors',auto\t'Use colors when the output is a terminal'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from cran" -s t -l tree -d 'Whether to create recipes for the whole dependency tree or not'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from cran" -s w -l write -d 'Whether to write the recipe to a folder'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from cran" -s v -l verbose -d 'Increase logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from cran" -s q -l quiet -d 'Decrease logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from cran" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from help" -f -a "pypi" -d 'Generate a recipe for a Python package from PyPI'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from help" -f -a "cran" -d 'Generate a recipe for an R package from CRAN'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand generate-recipe; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and not __fish_seen_subcommand_from login logout help" -l log-style -d 'Logging style' -r -f -a "{fancy\t'Use fancy logging output',json\t'Use JSON logging output',plain\t'Use plain logging output'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and not __fish_seen_subcommand_from login logout help" -l wrap-log-lines -d 'Wrap log lines at the terminal width. This is automatically disabled on CI (by detecting the `CI` environment variable)' -r -f -a "{true\t'',false\t''}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and not __fish_seen_subcommand_from login logout help" -l color -d 'Enable or disable colored output from rattler-build. Also honors the `CLICOLOR` and `CLICOLOR_FORCE` environment variable' -r -f -a "{always\t'Always use colors',never\t'Never use colors',auto\t'Use colors when the output is a terminal'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and not __fish_seen_subcommand_from login logout help" -s v -l verbose -d 'Increase logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and not __fish_seen_subcommand_from login logout help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and not __fish_seen_subcommand_from login logout help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and not __fish_seen_subcommand_from login logout help" -f -a "login" -d 'Store authentication information for a given host'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and not __fish_seen_subcommand_from login logout help" -f -a "logout" -d 'Remove authentication information for a given host'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and not __fish_seen_subcommand_from login logout help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and __fish_seen_subcommand_from login" -l token -d 'The token to use (for authentication with prefix.dev)' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and __fish_seen_subcommand_from login" -l username -d 'The username to use (for basic HTTP authentication)' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and __fish_seen_subcommand_from login" -l password -d 'The password to use (for basic HTTP authentication)' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and __fish_seen_subcommand_from login" -l conda-token -d 'The token to use on anaconda.org / quetz authentication' -r
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and __fish_seen_subcommand_from login" -l log-style -d 'Logging style' -r -f -a "{fancy\t'Use fancy logging output',json\t'Use JSON logging output',plain\t'Use plain logging output'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and __fish_seen_subcommand_from login" -l wrap-log-lines -d 'Wrap log lines at the terminal width. This is automatically disabled on CI (by detecting the `CI` environment variable)' -r -f -a "{true\t'',false\t''}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and __fish_seen_subcommand_from login" -l color -d 'Enable or disable colored output from rattler-build. Also honors the `CLICOLOR` and `CLICOLOR_FORCE` environment variable' -r -f -a "{always\t'Always use colors',never\t'Never use colors',auto\t'Use colors when the output is a terminal'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and __fish_seen_subcommand_from login" -s v -l verbose -d 'Increase logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and __fish_seen_subcommand_from login" -s q -l quiet -d 'Decrease logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and __fish_seen_subcommand_from login" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and __fish_seen_subcommand_from logout" -l log-style -d 'Logging style' -r -f -a "{fancy\t'Use fancy logging output',json\t'Use JSON logging output',plain\t'Use plain logging output'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and __fish_seen_subcommand_from logout" -l wrap-log-lines -d 'Wrap log lines at the terminal width. This is automatically disabled on CI (by detecting the `CI` environment variable)' -r -f -a "{true\t'',false\t''}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and __fish_seen_subcommand_from logout" -l color -d 'Enable or disable colored output from rattler-build. Also honors the `CLICOLOR` and `CLICOLOR_FORCE` environment variable' -r -f -a "{always\t'Always use colors',never\t'Never use colors',auto\t'Use colors when the output is a terminal'}"
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and __fish_seen_subcommand_from logout" -s v -l verbose -d 'Increase logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and __fish_seen_subcommand_from logout" -s q -l quiet -d 'Decrease logging verbosity'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and __fish_seen_subcommand_from logout" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and __fish_seen_subcommand_from help" -f -a "login" -d 'Store authentication information for a given host'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and __fish_seen_subcommand_from help" -f -a "logout" -d 'Remove authentication information for a given host'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand auth; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand help; and not __fish_seen_subcommand_from build test rebuild upload completion generate-recipe auth help" -f -a "build" -d 'Build a package from a recipe'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand help; and not __fish_seen_subcommand_from build test rebuild upload completion generate-recipe auth help" -f -a "test" -d 'Run a test for a single package'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand help; and not __fish_seen_subcommand_from build test rebuild upload completion generate-recipe auth help" -f -a "rebuild" -d 'Rebuild a package from a package file instead of a recipe'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand help; and not __fish_seen_subcommand_from build test rebuild upload completion generate-recipe auth help" -f -a "upload" -d 'Upload a package'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand help; and not __fish_seen_subcommand_from build test rebuild upload completion generate-recipe auth help" -f -a "completion" -d 'Generate shell completion script'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand help; and not __fish_seen_subcommand_from build test rebuild upload completion generate-recipe auth help" -f -a "generate-recipe" -d 'Generate a recipe from PyPI or CRAN'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand help; and not __fish_seen_subcommand_from build test rebuild upload completion generate-recipe auth help" -f -a "auth" -d 'Handle authentication to external channels'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand help; and not __fish_seen_subcommand_from build test rebuild upload completion generate-recipe auth help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand help; and __fish_seen_subcommand_from upload" -f -a "quetz" -d 'Upload to aQuetz server. Authentication is used from the keychain / auth-file'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand help; and __fish_seen_subcommand_from upload" -f -a "artifactory" -d 'Options for uploading to a Artifactory channel. Authentication is used from the keychain / auth-file'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand help; and __fish_seen_subcommand_from upload" -f -a "prefix" -d 'Options for uploading to a prefix.dev server. Authentication is used from the keychain / auth-file'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand help; and __fish_seen_subcommand_from upload" -f -a "anaconda" -d 'Options for uploading to a Anaconda.org server'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand help; and __fish_seen_subcommand_from upload" -f -a "conda-forge" -d 'Options for uploading to conda-forge'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand help; and __fish_seen_subcommand_from generate-recipe" -f -a "pypi" -d 'Generate a recipe for a Python package from PyPI'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand help; and __fish_seen_subcommand_from generate-recipe" -f -a "cran" -d 'Generate a recipe for an R package from CRAN'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand help; and __fish_seen_subcommand_from auth" -f -a "login" -d 'Store authentication information for a given host'
complete -c rattler-build -n "__fish_rattler_build_using_subcommand help; and __fish_seen_subcommand_from auth" -f -a "logout" -d 'Remove authentication information for a given host'
