/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.lang.annotation.Annotation;
import javax.annotation.security.DeclareRoles;
import javax.servlet.Servlet;
import org.eclipse.jetty.annotations.AnnotationIntrospector;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeclareRolesAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DeclareRolesAnnotationHandler.class);

    public DeclareRolesAnnotationHandler(WebAppContext context) {
        super(false, context);
    }

    public void doHandle(Class clazz) {
        if (!Servlet.class.isAssignableFrom(clazz)) {
            return;
        }
        if (!(this._context.getSecurityHandler() instanceof ConstraintAware)) {
            LOG.warn("SecurityHandler not ConstraintAware, skipping security annotation processing");
            return;
        }
        DeclareRoles declareRoles = clazz.getAnnotation(DeclareRoles.class);
        if (declareRoles == null) {
            return;
        }
        String[] roles = declareRoles.value();
        if (roles != null && roles.length > 0) {
            for (String r : roles) {
                ((ConstraintSecurityHandler)this._context.getSecurityHandler()).addRole(r);
                this._context.getMetaData().setOrigin("security-role." + r, (Annotation)declareRoles, clazz);
            }
        }
    }
}

