complete -c sqopv -n "__fish_use_subcommand" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_use_subcommand" -s h -l help -d 'Print help'
complete -c sqopv -n "__fish_use_subcommand" -f -a "version" -d 'Prints version information'
complete -c sqopv -n "__fish_use_subcommand" -f -a "list-profiles" -d 'Emits a list of profiles supported by the identified subcommand'
complete -c sqopv -n "__fish_use_subcommand" -f -a "generate-key" -d 'Generates a Secret Key'
complete -c sqopv -n "__fish_use_subcommand" -f -a "change-key-password" -d 'Updates a key\'s password'
complete -c sqopv -n "__fish_use_subcommand" -f -a "revoke-key" -d 'Creates a Revocation Certificate'
complete -c sqopv -n "__fish_use_subcommand" -f -a "extract-cert" -d 'Extracts a Certificate from a Secret Key'
complete -c sqopv -n "__fish_use_subcommand" -f -a "update-key" -d 'Keep a Secret Key Up-To-Date'
complete -c sqopv -n "__fish_use_subcommand" -f -a "merge-certs" -d 'Merge OpenPGP Certificates'
complete -c sqopv -n "__fish_use_subcommand" -f -a "certify-userid" -d 'Certify OpenPGP Certificate User IDs'
complete -c sqopv -n "__fish_use_subcommand" -f -a "validate-userid" -d 'Validate a User ID in an OpenPGP Certificate'
complete -c sqopv -n "__fish_use_subcommand" -f -a "sign" -d 'Creates Detached Signatures'
complete -c sqopv -n "__fish_use_subcommand" -f -a "verify" -d 'Verifies Detached Signatures'
complete -c sqopv -n "__fish_use_subcommand" -f -a "encrypt" -d 'Encrypts a Message'
complete -c sqopv -n "__fish_use_subcommand" -f -a "decrypt" -d 'Decrypts a Message'
complete -c sqopv -n "__fish_use_subcommand" -f -a "armor" -d 'Converts binary OpenPGP data to ASCII'
complete -c sqopv -n "__fish_use_subcommand" -f -a "dearmor" -d 'Converts ASCII OpenPGP data to binary'
complete -c sqopv -n "__fish_use_subcommand" -f -a "inline-detach" -d 'Splits Signatures from an Inline-Signed Message'
complete -c sqopv -n "__fish_use_subcommand" -f -a "inline-verify" -d 'Verifies Inline-Signed Messages'
complete -c sqopv -n "__fish_use_subcommand" -f -a "inline-sign" -d 'Creates Inline-Signed Messages'
complete -c sqopv -n "__fish_use_subcommand" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sqopv -n "__fish_seen_subcommand_from version" -l backend -d 'Returns name and version of the primary underlying OpenPGP toolkit'
complete -c sqopv -n "__fish_seen_subcommand_from version" -l extended -d 'Returns multiple lines of name and version information'
complete -c sqopv -n "__fish_seen_subcommand_from version" -l sop-spec -d 'Returns the latest version of the SOP spec that is implemented'
complete -c sqopv -n "__fish_seen_subcommand_from version" -l sopv -d 'Returns "1.0\\n" if the sopv subset is implemented'
complete -c sqopv -n "__fish_seen_subcommand_from version" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_seen_subcommand_from version" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sqopv -n "__fish_seen_subcommand_from list-profiles" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_seen_subcommand_from list-profiles" -s h -l help -d 'Print help'
complete -c sqopv -n "__fish_seen_subcommand_from generate-key" -l profile -d 'Select the profile to use for key generation' -r
complete -c sqopv -n "__fish_seen_subcommand_from generate-key" -l with-key-password -d 'Protect the newly generated key with the given password' -r
complete -c sqopv -n "__fish_seen_subcommand_from generate-key" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqopv -n "__fish_seen_subcommand_from generate-key" -l signing-only -d 'Create a signing-only key'
complete -c sqopv -n "__fish_seen_subcommand_from generate-key" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_seen_subcommand_from generate-key" -s h -l help -d 'Print help'
complete -c sqopv -n "__fish_seen_subcommand_from change-key-password" -l new-key-password -d 'The new password to lock the key with, or just unlock the key if the option is absent' -r
complete -c sqopv -n "__fish_seen_subcommand_from change-key-password" -l old-key-password -d 'Unlock the keys with these passwords' -r
complete -c sqopv -n "__fish_seen_subcommand_from change-key-password" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqopv -n "__fish_seen_subcommand_from change-key-password" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_seen_subcommand_from change-key-password" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sqopv -n "__fish_seen_subcommand_from revoke-key" -l with-key-password -d 'Unlock the keys with these passwords' -r
complete -c sqopv -n "__fish_seen_subcommand_from revoke-key" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqopv -n "__fish_seen_subcommand_from revoke-key" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_seen_subcommand_from revoke-key" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sqopv -n "__fish_seen_subcommand_from extract-cert" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqopv -n "__fish_seen_subcommand_from extract-cert" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_seen_subcommand_from extract-cert" -s h -l help -d 'Print help'
complete -c sqopv -n "__fish_seen_subcommand_from update-key" -l with-key-password -d 'Unlock the keys with these passwords' -r
complete -c sqopv -n "__fish_seen_subcommand_from update-key" -l merge-certs -d 'Merge updates into the key' -r
complete -c sqopv -n "__fish_seen_subcommand_from update-key" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqopv -n "__fish_seen_subcommand_from update-key" -l signing-only -d 'Don\'t make the updated key encryption-capable if it isn\'t already'
complete -c sqopv -n "__fish_seen_subcommand_from update-key" -l no-added-capabilities -d 'Don\'t advertise support for capabilities that aren\'t already advertised by the key'
complete -c sqopv -n "__fish_seen_subcommand_from update-key" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_seen_subcommand_from update-key" -s h -l help -d 'Print help'
complete -c sqopv -n "__fish_seen_subcommand_from merge-certs" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqopv -n "__fish_seen_subcommand_from merge-certs" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_seen_subcommand_from merge-certs" -s h -l help -d 'Print help'
complete -c sqopv -n "__fish_seen_subcommand_from certify-userid" -l userid -d 'Certify the specified user IDs' -r
complete -c sqopv -n "__fish_seen_subcommand_from certify-userid" -l with-key-password -d 'Unlock the keys with these passwords' -r
complete -c sqopv -n "__fish_seen_subcommand_from certify-userid" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqopv -n "__fish_seen_subcommand_from certify-userid" -l no-require-self-sig -d 'Don\'t require self-signatures on the user IDs to be certified'
complete -c sqopv -n "__fish_seen_subcommand_from certify-userid" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_seen_subcommand_from certify-userid" -s h -l help -d 'Print help'
complete -c sqopv -n "__fish_seen_subcommand_from validate-userid" -l validate-at -d 'Evaluate the validity of the User ID at the specified time, not at the current time' -r
complete -c sqopv -n "__fish_seen_subcommand_from validate-userid" -l addr-spec-only -d 'Treat USERID as an e-mail address, and matched only against the e-mail address part of each correctly bound User ID'
complete -c sqopv -n "__fish_seen_subcommand_from validate-userid" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_seen_subcommand_from validate-userid" -s h -l help -d 'Print help'
complete -c sqopv -n "__fish_seen_subcommand_from sign" -l as -d 'Sign binary data or UTF-8 text' -r
complete -c sqopv -n "__fish_seen_subcommand_from sign" -l micalg-out -d 'Emit the digest algorithm used to the specified file' -r
complete -c sqopv -n "__fish_seen_subcommand_from sign" -l with-key-password -d 'Try to decrypt the signing KEYS with these passwords' -r
complete -c sqopv -n "__fish_seen_subcommand_from sign" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqopv -n "__fish_seen_subcommand_from sign" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_seen_subcommand_from sign" -s h -l help -d 'Print help'
complete -c sqopv -n "__fish_seen_subcommand_from verify" -l not-before -d 'Consider signatures before this date invalid' -r
complete -c sqopv -n "__fish_seen_subcommand_from verify" -l not-after -d 'Consider signatures after this date invalid' -r
complete -c sqopv -n "__fish_seen_subcommand_from verify" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_seen_subcommand_from verify" -s h -l help -d 'Print help'
complete -c sqopv -n "__fish_seen_subcommand_from encrypt" -l profile -d 'Select the profile to use for encryption' -r
complete -c sqopv -n "__fish_seen_subcommand_from encrypt" -l as -d 'Encrypt binary data or UTF-8 text' -r
complete -c sqopv -n "__fish_seen_subcommand_from encrypt" -l with-password -d 'Encrypt with passwords' -r
complete -c sqopv -n "__fish_seen_subcommand_from encrypt" -l sign-with -d 'Keys for signing' -r
complete -c sqopv -n "__fish_seen_subcommand_from encrypt" -l with-key-password -d 'Try to decrypt the signing KEYS with these passwords' -r
complete -c sqopv -n "__fish_seen_subcommand_from encrypt" -l session-key-out -d 'Write the session key here' -r
complete -c sqopv -n "__fish_seen_subcommand_from encrypt" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqopv -n "__fish_seen_subcommand_from encrypt" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_seen_subcommand_from encrypt" -s h -l help -d 'Print help'
complete -c sqopv -n "__fish_seen_subcommand_from decrypt" -l session-key-out -d 'Write the session key here' -r
complete -c sqopv -n "__fish_seen_subcommand_from decrypt" -l with-session-key -d 'Try to decrypt with this session key' -r
complete -c sqopv -n "__fish_seen_subcommand_from decrypt" -l with-password -d 'Try to decrypt with this password' -r
complete -c sqopv -n "__fish_seen_subcommand_from decrypt" -l verifications-out -d 'Write verification result here' -r
complete -c sqopv -n "__fish_seen_subcommand_from decrypt" -l verify-with -d 'Certs for verification' -r
complete -c sqopv -n "__fish_seen_subcommand_from decrypt" -l verify-not-before -d 'Consider signatures before this date invalid' -r
complete -c sqopv -n "__fish_seen_subcommand_from decrypt" -l verify-not-after -d 'Consider signatures after this date invalid' -r
complete -c sqopv -n "__fish_seen_subcommand_from decrypt" -l with-key-password -d 'Try to decrypt the encryption KEYS with these passwords' -r
complete -c sqopv -n "__fish_seen_subcommand_from decrypt" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_seen_subcommand_from decrypt" -s h -l help -d 'Print help'
complete -c sqopv -n "__fish_seen_subcommand_from armor" -l label -d 'Indicates the kind of data' -r
complete -c sqopv -n "__fish_seen_subcommand_from armor" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_seen_subcommand_from armor" -s h -l help -d 'Print help'
complete -c sqopv -n "__fish_seen_subcommand_from dearmor" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_seen_subcommand_from dearmor" -s h -l help -d 'Print help'
complete -c sqopv -n "__fish_seen_subcommand_from inline-detach" -l signatures-out -d 'Write Signatures here' -r
complete -c sqopv -n "__fish_seen_subcommand_from inline-detach" -l no-armor -d 'Don\'t ASCII-armor the signatures'
complete -c sqopv -n "__fish_seen_subcommand_from inline-detach" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_seen_subcommand_from inline-detach" -s h -l help -d 'Print help'
complete -c sqopv -n "__fish_seen_subcommand_from inline-verify" -l not-before -d 'Consider signatures before this date invalid' -r
complete -c sqopv -n "__fish_seen_subcommand_from inline-verify" -l not-after -d 'Consider signatures after this date invalid' -r
complete -c sqopv -n "__fish_seen_subcommand_from inline-verify" -l verifications-out -d 'Write verification result here' -r
complete -c sqopv -n "__fish_seen_subcommand_from inline-verify" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_seen_subcommand_from inline-verify" -s h -l help -d 'Print help'
complete -c sqopv -n "__fish_seen_subcommand_from inline-sign" -l as -d 'Sign binary data, UTF-8 text, or using the Cleartext Signature Framework' -r
complete -c sqopv -n "__fish_seen_subcommand_from inline-sign" -l with-key-password -d 'Try to decrypt the signing KEYS with these passwords' -r
complete -c sqopv -n "__fish_seen_subcommand_from inline-sign" -l no-armor -d 'Don\'t ASCII-armor output'
complete -c sqopv -n "__fish_seen_subcommand_from inline-sign" -l debug -d 'Emit verbose output for debugging'
complete -c sqopv -n "__fish_seen_subcommand_from inline-sign" -s h -l help -d 'Print help'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "version" -d 'Prints version information'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "list-profiles" -d 'Emits a list of profiles supported by the identified subcommand'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "generate-key" -d 'Generates a Secret Key'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "change-key-password" -d 'Updates a key\'s password'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "revoke-key" -d 'Creates a Revocation Certificate'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "extract-cert" -d 'Extracts a Certificate from a Secret Key'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "update-key" -d 'Keep a Secret Key Up-To-Date'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "merge-certs" -d 'Merge OpenPGP Certificates'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "certify-userid" -d 'Certify OpenPGP Certificate User IDs'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "validate-userid" -d 'Validate a User ID in an OpenPGP Certificate'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "sign" -d 'Creates Detached Signatures'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "verify" -d 'Verifies Detached Signatures'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "encrypt" -d 'Encrypts a Message'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "decrypt" -d 'Decrypts a Message'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "armor" -d 'Converts binary OpenPGP data to ASCII'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "dearmor" -d 'Converts ASCII OpenPGP data to binary'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "inline-detach" -d 'Splits Signatures from an Inline-Signed Message'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "inline-verify" -d 'Verifies Inline-Signed Messages'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "inline-sign" -d 'Creates Inline-Signed Messages'
complete -c sqopv -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from list-profiles; and not __fish_seen_subcommand_from generate-key; and not __fish_seen_subcommand_from change-key-password; and not __fish_seen_subcommand_from revoke-key; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from update-key; and not __fish_seen_subcommand_from merge-certs; and not __fish_seen_subcommand_from certify-userid; and not __fish_seen_subcommand_from validate-userid; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from inline-detach; and not __fish_seen_subcommand_from inline-verify; and not __fish_seen_subcommand_from inline-sign; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
