/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.util.HashSet;
import java.util.Set;

public class HtmlParameter
implements Comparable<HtmlParameter> {
    private String name;
    private String value;
    private Type type;
    private Set<String> flags;

    public HtmlParameter(Type type, String name, String value) {
        this.setName(name);
        this.setValue(value);
        this.setType(type);
    }

    public HtmlParameter(String cookieLine) {
        HtmlParameter.validateNotNull(cookieLine, "cookieLine");
        this.type = Type.cookie;
        String[] array = cookieLine.split(";");
        int eqOffset = array[0].indexOf(61);
        if (eqOffset == -1) {
            this.name = "";
            this.value = array[0].trim();
        } else {
            this.name = array[0].substring(0, eqOffset).trim();
            this.value = array[0].substring(eqOffset + 1).trim();
        }
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                this.addFlag(array[i].trim());
            }
        }
    }

    private static void validateNotNull(Object parameter, String parameterName) {
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter " + parameterName + " must not be null");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        HtmlParameter.validateNotNull(name, "name");
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        HtmlParameter.validateNotNull((Object)type, "type");
        this.type = type;
    }

    public Set<String> getFlags() {
        if (this.flags == null) {
            this.flags = new HashSet<String>();
        }
        return this.flags;
    }

    public void addFlag(String flag) {
        this.getFlags().add(flag);
    }

    @Override
    public int compareTo(HtmlParameter o) {
        if (o == null) {
            return 1;
        }
        int result = this.type.ordinal() - o.getType().ordinal();
        if (result == 0) {
            result = this.name.compareTo(o.getName());
        }
        if (result == 0) {
            if (this.value != null && o.getValue() != null) {
                result = this.value.compareTo(o.getValue());
            } else if (this.value != null || o.getValue() != null) {
                return this.value != null ? 1 : -1;
            }
        }
        return result;
    }

    public String toString() {
        return "HtmlParameter type = " + (Object)((Object)this.type) + " name= " + this.name + " value=" + this.value;
    }

    public static enum Flags {
        anticsrf,
        session,
        structural;

    }

    public static enum Type {
        cookie,
        form,
        url,
        header,
        multipart;

    }
}

