/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Range$;
import scala.math.BigDecimal;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Numeric$BigDecimalAsIfIntegral$;
import scala.math.Numeric$BigIntIsIntegral$;
import scala.math.Numeric$ByteIsIntegral$;
import scala.math.Numeric$CharIsIntegral$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Numeric$LongIsIntegral$;
import scala.math.Numeric$ShortIsIntegral$;
import scala.math.Ordering;
import scala.math.Ordering$BigDecimal$;
import scala.math.Ordering$BigInt$;
import scala.math.Ordering$Byte$;
import scala.math.Ordering$Char$;
import scala.math.Ordering$Int$;
import scala.math.Ordering$Long$;
import scala.math.Ordering$Short$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class NumericRange$
implements Serializable {
    public static final NumericRange$ MODULE$ = new NumericRange$();
    private static final Map<Numeric<?>, Ordering<?>> defaultOrdering = (Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Numeric$BigIntIsIntegral$.MODULE$), Ordering$BigInt$.MODULE$), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Numeric$IntIsIntegral$.MODULE$), Ordering$Int$.MODULE$), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Numeric$ShortIsIntegral$.MODULE$), Ordering$Short$.MODULE$), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Numeric$ByteIsIntegral$.MODULE$), Ordering$Byte$.MODULE$), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Numeric$CharIsIntegral$.MODULE$), Ordering$Char$.MODULE$), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Numeric$LongIsIntegral$.MODULE$), Ordering$Long$.MODULE$), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Numeric$BigDecimalAsIfIntegral$.MODULE$), Ordering$BigDecimal$.MODULE$)}));

    private <T> void bigDecimalCheckUnderflow(T start, T end, T step, Integral<T> num) {
        block1: {
            if (!BoxesRunTime.equals(num.minus(num.plus(start, step), start), step)) {
                NumericRange$.FAIL$1(start, step);
            }
            if (BoxesRunTime.equals(num.minus(end, num.minus(end, step)), step)) break block1;
            NumericRange$.FAIL$1(end, step);
        }
    }

    public <T> int count(T start, T end, T step, boolean isInclusive, Integral<T> num) {
        int n;
        Object zero = num.zero();
        boolean upward = num.lt(start, end);
        boolean posStep = num.gt(step, zero);
        if (BoxesRunTime.equals(step, zero)) {
            throw new IllegalArgumentException("step cannot be 0.");
        }
        if (BoxesRunTime.equals(start, end)) {
            n = isInclusive ? 1 : 0;
        } else if (upward != posStep) {
            n = 0;
        } else {
            Object object;
            T endside;
            int stepint;
            int endint;
            int startint = num.toInt(start);
            if (BoxesRunTime.equals(start, num.fromInt(startint)) && BoxesRunTime.equals(end, num.fromInt(endint = num.toInt(end))) && BoxesRunTime.equals(step, num.fromInt(stepint = num.toInt(step)))) {
                return isInclusive ? Range$.MODULE$.inclusive(startint, endint, stepint).length() : Range$.MODULE$.apply(startint, endint, stepint).length();
            }
            if (num instanceof Numeric.BigDecimalAsIfIntegral) {
                this.bigDecimalCheckUnderflow(start, end, step, num);
            }
            Object one = num.one();
            Object limit = num.fromInt(Integer.MAX_VALUE);
            T startside = num.sign(start);
            if (num.gteq(num.times(startside, endside = num.sign(end)), zero)) {
                T diff = num.minus(end, start);
                Object quotient = NumericRange$.check$1(num.quot(diff, step), num, limit);
                Object remainder = num.minus(diff, num.times(quotient, step));
                object = !isInclusive && BoxesRunTime.equals(zero, remainder) ? quotient : NumericRange$.check$1(num.plus(quotient, one), num, limit);
            } else {
                Object object2;
                Object negone = num.fromInt(-1);
                Object startlim = posStep ? negone : one;
                T startdiff = posStep && num.lt(startlim, start) || !posStep && num.gt(startlim, start) ? start : num.minus(startlim, start);
                Object startq = NumericRange$.check$1(num.quot(startdiff, step), num, limit);
                Object waypointA = BoxesRunTime.equals(startq, zero) ? start : num.plus(start, num.times(startq, step));
                T waypointB = num.plus(waypointA, step);
                if (num.lt(waypointB, end) != upward) {
                    object2 = isInclusive && BoxesRunTime.equals(waypointB, end) ? num.plus(startq, num.fromInt(2)) : num.plus(startq, one);
                } else {
                    T enddiff = num.minus(end, waypointB);
                    Object endq = NumericRange$.check$1(num.quot(enddiff, step), num, limit);
                    T last = BoxesRunTime.equals(endq, zero) ? waypointB : num.plus(waypointB, num.times(endq, step));
                    object2 = num.plus(startq, num.plus(endq, !isInclusive && BoxesRunTime.equals(last, end) ? one : num.fromInt(2)));
                }
                object = NumericRange$.check$1(object2, num, limit);
            }
            n = num.toInt(object);
        }
        return n;
    }

    public <T> NumericRange.Exclusive<T> apply(T start, T end, T step, Integral<T> num) {
        return new NumericRange.Exclusive<T>(start, end, step, num);
    }

    public <T> NumericRange.Inclusive<T> inclusive(T start, T end, T step, Integral<T> num) {
        return new NumericRange.Inclusive<T>(start, end, step, num);
    }

    public Map<Numeric<?>, Ordering<?>> defaultOrdering() {
        return defaultOrdering;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NumericRange$.class);
    }

    private static final void FAIL$1(Object boundary, Object step) {
        String string;
        Object object = boundary;
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            string = new StringBuilder(10).append("Precision ").append(bigDecimal.mc().getPrecision()).toString();
        } else {
            string = "Precision";
        }
        String msg = string;
        throw new IllegalArgumentException(new StringBuilder(45).append(msg).append(" inadequate to represent steps of size ").append(step).append(" near ").append(boundary).toString());
    }

    private static final Object check$1(Object t, Integral num$1, Object limit$1) {
        if (num$1.gt(t, limit$1)) {
            throw new IllegalArgumentException("More than Int.MaxValue elements.");
        }
        return t;
    }

    private NumericRange$() {
    }
}

