/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.protocol;

import com.google.gson.Gson;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.protocol.IpnbConnection;
import org.jetbrains.plugins.ipnb.protocol.IpnbConnectionListener;

public class IpnbConnectionV3
extends IpnbConnection {
    private WebSocketClient myChannelsClient;
    private Thread myChannelsThread;

    public IpnbConnectionV3(@NotNull String uri, @NotNull IpnbConnectionListener listener, @Nullable String token, @NotNull Project project, String pathToFile) throws IOException, URISyntaxException {
        if (uri == null) {
            IpnbConnectionV3.$$$reportNull$$$0(0);
        }
        if (listener == null) {
            IpnbConnectionV3.$$$reportNull$$$0(1);
        }
        if (project == null) {
            IpnbConnectionV3.$$$reportNull$$$0(2);
        }
        super(uri, listener, token, project, pathToFile);
    }

    @Override
    protected void initializeClients() throws URISyntaxException {
        IpnbConnection.Draft17WithOrigin draft = new IpnbConnection.Draft17WithOrigin();
        this.myChannelsClient = new IpnbConnection.IpnbWebSocketClient(this.getChannelsURI(), (Draft)draft);
        this.myChannelsThread = new Thread((Runnable)this.myChannelsClient, "IPNB channel client");
        this.myChannelsThread.start();
    }

    @Override
    protected void notifyOpen() {
        if (!this.myIsOpened) {
            this.myIsOpened = true;
            this.myListener.onOpen(this);
        }
    }

    @Override
    @NotNull
    public String execute(@NotNull String code) {
        if (code == null) {
            IpnbConnectionV3.$$$reportNull$$$0(3);
        }
        String messageId = UUID.randomUUID().toString();
        this.myChannelsClient.send(new Gson().toJson((Object)this.createExecuteRequest(code, messageId)));
        String string = messageId;
        if (string == null) {
            IpnbConnectionV3.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void shutdown() {
        this.myChannelsClient.close();
    }

    @Override
    public void close() throws IOException, InterruptedException {
        this.myChannelsThread.join();
        this.shutdownKernel();
    }

    @NotNull
    public URI getChannelsURI() throws URISyntaxException {
        URI uRI = new URI(this.getWebSocketURIBase() + "/channels");
        if (uRI == null) {
            IpnbConnectionV3.$$$reportNull$$$0(5);
        }
        return uRI;
    }

    @Override
    public boolean isAlive() {
        return this.myChannelsClient.isOpen();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ipnb/protocol/IpnbConnectionV3";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ipnb/protocol/IpnbConnectionV3";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChannelsURI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

