/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonRefactoringUtil {
    private CommonRefactoringUtil() {
    }

    public static void showErrorMessage(String title, String message, @Nullable String helpId, @NotNull Project project) {
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(message);
        }
        RefactoringMessageDialog dialog = new RefactoringMessageDialog(title, message, helpId, "OptionPane.errorIcon", false, project);
        dialog.show();
    }

    public static void sortDepthFirstRightLeftOrder(UsageInfo[] usages) {
        Arrays.sort(usages, (usage1, usage2) -> {
            PsiElement element2;
            PsiElement element1 = usage1.getElement();
            if (element1 == (element2 = usage2.getElement())) {
                return 0;
            }
            if (element1 == null) {
                return 1;
            }
            if (element2 == null) {
                return -1;
            }
            return element2.getTextRange().getStartOffset() - element1.getTextRange().getStartOffset();
        });
    }

    public static void showErrorHint(@NotNull Project project, @Nullable Editor editor, @NotNull @Nls String message, @NotNull @Nls String title, @Nullable String helpId) {
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(1);
        }
        if (message == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(2);
        }
        if (title == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(3);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RefactoringErrorHintException(message);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (editor == null || editor.getComponent().getRootPane() == null) {
                CommonRefactoringUtil.showErrorMessage(title, message, helpId, project);
            } else {
                HintManager.getInstance().showErrorHint(editor, message);
            }
        });
    }

    public static String htmlEmphasize(@NotNull String text) {
        if (text == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(4);
        }
        return StringUtil.htmlEmphasize((String)text);
    }

    public static boolean checkReadOnlyStatus(@NotNull PsiElement element) {
        VirtualFile file;
        if (element == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(5);
        }
        return (file = element.getContainingFile().getVirtualFile()) != null && !ReadonlyStatusHandler.getInstance(element.getProject()).ensureFilesWritable(file).hasReadonlyFiles();
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, @NotNull PsiElement element) {
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(6);
        }
        if (element == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(7);
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(element, project, RefactoringBundle.message("refactoring.cannot.be.performed"));
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, PsiElement ... elements) {
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(8);
        }
        if (elements == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(9);
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(project, Collections.emptySet(), Arrays.asList(elements), RefactoringBundle.message("refactoring.cannot.be.performed"), true);
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements, boolean notifyOnFail) {
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(10);
        }
        if (elements == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(11);
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(project, Collections.emptySet(), elements, RefactoringBundle.message("refactoring.cannot.be.performed"), notifyOnFail);
    }

    public static boolean checkReadOnlyStatus(@NotNull PsiElement element, @NotNull Project project, @NotNull String messagePrefix) {
        if (element == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(12);
        }
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(13);
        }
        if (messagePrefix == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(14);
        }
        return element.isWritable() || CommonRefactoringUtil.checkReadOnlyStatus(project, Collections.emptySet(), Collections.singleton(element), messagePrefix, true);
    }

    public static boolean checkReadOnlyStatusRecursively(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements) {
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(15);
        }
        if (elements == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(16);
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(project, elements, Collections.emptySet(), RefactoringBundle.message("refactoring.cannot.be.performed"), false);
    }

    public static boolean checkReadOnlyStatusRecursively(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements, boolean notifyOnFail) {
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(17);
        }
        if (elements == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(18);
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(project, elements, Collections.emptySet(), RefactoringBundle.message("refactoring.cannot.be.performed"), notifyOnFail);
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, @NotNull Collection<? extends PsiElement> recursive, @NotNull Collection<? extends PsiElement> flat, boolean notifyOnFail) {
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(19);
        }
        if (recursive == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(20);
        }
        if (flat == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(21);
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(project, recursive, flat, RefactoringBundle.message("refactoring.cannot.be.performed"), notifyOnFail);
    }

    private static boolean checkReadOnlyStatus(@NotNull Project project, @NotNull Collection<? extends PsiElement> recursive, @NotNull Collection<? extends PsiElement> flat, @NotNull String messagePrefix, boolean notifyOnFail) {
        THashSet failed;
        THashSet readonly;
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(22);
        }
        if (recursive == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(23);
        }
        if (flat == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(24);
        }
        if (messagePrefix == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(25);
        }
        boolean seenNonWritablePsiFilesWithoutVirtualFile = CommonRefactoringUtil.checkReadOnlyStatus(flat, false, (Collection<? super VirtualFile>)(readonly = new THashSet()), (Collection<? super VirtualFile>)(failed = new THashSet())) || CommonRefactoringUtil.checkReadOnlyStatus(recursive, true, (Collection<? super VirtualFile>)readonly, (Collection<? super VirtualFile>)failed);
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance(project).ensureFilesWritable((Collection<VirtualFile>)readonly);
        ContainerUtil.addAll((Collection)failed, (Object[])status.getReadonlyFiles());
        if (notifyOnFail && (!failed.isEmpty() || seenNonWritablePsiFilesWithoutVirtualFile && readonly.isEmpty())) {
            StringBuilder message = new StringBuilder(messagePrefix).append('\n');
            int i = 0;
            for (VirtualFile virtualFile2 : failed) {
                String subj = RefactoringBundle.message(virtualFile2.isDirectory() ? "directory.description" : "file.description", virtualFile2.getPresentableUrl());
                if (virtualFile2.getFileSystem().isReadOnly()) {
                    message.append(RefactoringBundle.message("0.is.located.in.a.jar.file", subj)).append('\n');
                } else {
                    message.append(RefactoringBundle.message("0.is.read.only", subj)).append('\n');
                }
                if (i++ <= 20) continue;
                message.append("...\n");
                break;
            }
            CommonRefactoringUtil.showErrorMessage(RefactoringBundle.message("error.title"), message.toString(), null, project);
            return false;
        }
        return failed.isEmpty();
    }

    private static boolean checkReadOnlyStatus(Collection<? extends PsiElement> elements, boolean recursively, Collection<? super VirtualFile> readonly, Collection<? super VirtualFile> failed) {
        boolean seenNonWritablePsiFilesWithoutVirtualFile = false;
        for (PsiElement psiElement : elements) {
            if (psiElement instanceof PsiDirectory) {
                PsiDirectory dir = (PsiDirectory)psiElement;
                VirtualFile virtualFile2 = dir.getVirtualFile();
                if (virtualFile2.getFileSystem().isReadOnly()) {
                    failed.add(virtualFile2);
                    continue;
                }
                if (recursively) {
                    CommonRefactoringUtil.collectReadOnlyFiles(virtualFile2, readonly);
                    continue;
                }
                readonly.add(virtualFile2);
                continue;
            }
            if (psiElement instanceof PsiDirectoryContainer) {
                PsiDirectory[] directories;
                for (PsiDirectory directory : directories = ((PsiDirectoryContainer)psiElement).getDirectories()) {
                    VirtualFile virtualFile2 = directory.getVirtualFile();
                    if (recursively) {
                        if (virtualFile2.getFileSystem().isReadOnly()) {
                            failed.add(virtualFile2);
                            continue;
                        }
                        CommonRefactoringUtil.collectReadOnlyFiles(virtualFile2, readonly);
                        continue;
                    }
                    if (virtualFile2.getFileSystem().isReadOnly()) {
                        failed.add(virtualFile2);
                        continue;
                    }
                    readonly.add(virtualFile2);
                }
                continue;
            }
            PsiFile file = psiElement.getContainingFile();
            if (file == null) {
                if (psiElement.isWritable()) continue;
                seenNonWritablePsiFilesWithoutVirtualFile = true;
                continue;
            }
            VirtualFile virtualFile3 = file.getVirtualFile();
            if (virtualFile3 != null) {
                readonly.add(virtualFile3);
                continue;
            }
            if (psiElement.isWritable()) continue;
            seenNonWritablePsiFilesWithoutVirtualFile = true;
        }
        return seenNonWritablePsiFilesWithoutVirtualFile;
    }

    public static void collectReadOnlyFiles(@NotNull VirtualFile vFile, final @NotNull Collection<? super VirtualFile> list) {
        if (vFile == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(26);
        }
        if (list == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(27);
        }
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VfsUtilCore.visitChildrenRecursively(vFile, new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean ignored = fileTypeManager.isFileIgnored(file);
                if (!file.isWritable() && !ignored) {
                    list.add(file);
                }
                return !ignored;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/util/CommonRefactoringUtil$1", "visitFile"));
            }
        });
    }

    public static String capitalize(@NotNull String text) {
        if (text == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(28);
        }
        return StringUtil.capitalize((String)text);
    }

    public static boolean isAncestor(@NotNull PsiElement resolved, @NotNull Collection<? extends PsiElement> scopes) {
        if (resolved == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(29);
        }
        if (scopes == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(30);
        }
        for (PsiElement psiElement : scopes) {
            if (!PsiTreeUtil.isAncestor(psiElement, resolved, false)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 11: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagePrefix";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursive";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flat";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/util/CommonRefactoringUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorMessage";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorHint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "htmlEmphasize";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReadOnlyStatus";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReadOnlyStatusRecursively";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "collectReadOnlyFiles";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "capitalize";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "isAncestor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RefactoringErrorHintException
    extends RuntimeException {
        public RefactoringErrorHintException(String message) {
            super(message);
        }
    }
}

