/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.ProgressManagerQueue;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.BranchesLoader;
import org.jetbrains.idea.svn.branchConfig.DefaultBranchConfigInitializer;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.NewRootBunchKt;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\tJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\tJ&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\nJ\u001e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J*\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00172\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"0\u0010J$\u0010$\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\t2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010&\u001a\u00020\u001bR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/idea/svn/branchConfig/NewRootBunch;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myBranchesLoader", "Lcom/intellij/vcs/ProgressManagerQueue;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/ProgressManagerQueue;)V", "mapCopy", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/idea/svn/branchConfig/SvnBranchConfigurationNew;", "getMapCopy", "()Ljava/util/Map;", "myLock", "myMap", "", "Lorg/jetbrains/idea/svn/branchConfig/InfoStorage;", "getConfig", "root", "getConfigOrNull", "reloadBranches", "", "branchLocation", "Lorg/jetbrains/idea/svn/api/Url;", "reliability", "Lorg/jetbrains/idea/svn/branchConfig/InfoReliability;", "passive", "", "prev", "next", "reloadBranchesAsync", "updateBranches", "branchesParent", "items", "", "Lorg/jetbrains/idea/svn/branchConfig/SvnBranchItem;", "updateForRoot", "config", "reload", "intellij.vcs.svn"})
public final class NewRootBunch {
    private final Object myLock;
    private final Map<VirtualFile, InfoStorage<SvnBranchConfigurationNew>> myMap;
    private final Project myProject;
    private final ProgressManagerQueue myBranchesLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Map<VirtualFile, SvnBranchConfigurationNew> getMapCopy() {
        Map map;
        Object object = this.myLock;
        synchronized (object) {
            void $receiver$iv$iv;
            Map $receiver$iv;
            map = $receiver$iv = this.myMap;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                Map map3 = map2;
                SvnBranchConfigurationNew svnBranchConfigurationNew = (SvnBranchConfigurationNew)((InfoStorage)it.getValue()).getValue();
                map3.put(k2, svnBranchConfigurationNew);
            }
            map = destination$iv$iv;
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateForRoot(@NotNull VirtualFile root, @NotNull InfoStorage<SvnBranchConfigurationNew> config, boolean reload) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        Object object = this.myLock;
        synchronized (object) {
            boolean override;
            SvnBranchConfigurationNew previous;
            InfoStorage<SvnBranchConfigurationNew> existing = this.myMap.get(root);
            if (existing == null) {
                previous = null;
                override = true;
                Map<VirtualFile, InfoStorage<SvnBranchConfigurationNew>> map = this.myMap;
                VirtualFile virtualFile = root;
                InfoStorage<SvnBranchConfigurationNew> infoStorage = config;
                map.put(virtualFile, infoStorage);
            } else {
                previous = existing.getValue();
                override = existing.accept(config);
            }
            if (reload && override) {
                this.myBranchesLoader.run(new Runnable(previous, this, root, config, reload){
                    final /* synthetic */ SvnBranchConfigurationNew $previous;
                    final /* synthetic */ NewRootBunch this$0;
                    final /* synthetic */ VirtualFile $root$inlined;
                    final /* synthetic */ InfoStorage $config$inlined;
                    final /* synthetic */ boolean $reload$inlined;
                    {
                        this.$previous = svnBranchConfigurationNew;
                        this.this$0 = newRootBunch;
                        this.$root$inlined = virtualFile;
                        this.$config$inlined = infoStorage;
                        this.$reload$inlined = bl;
                    }

                    public final void run() {
                        this.this$0.reloadBranches(this.$root$inlined, this.$previous, (SvnBranchConfigurationNew)this.$config$inlined.getValue());
                    }
                });
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateBranches(@NotNull VirtualFile root, @NotNull Url branchesParent, @NotNull InfoStorage<List<SvnBranchItem>> items) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)branchesParent, (String)"branchesParent");
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        Object object = this.myLock;
        synchronized (object) {
            InfoStorage<SvnBranchConfigurationNew> existing = this.myMap.get(root);
            if (existing == null) {
                NewRootBunchKt.access$getLOG$p().info("cannot update branches, branches parent not found: " + branchesParent.toDecodedString());
            } else {
                existing.getValue().updateBranch(branchesParent, items);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final SvnBranchConfigurationNew getConfigOrNull(@NotNull VirtualFile root) {
        SvnBranchConfigurationNew svnBranchConfigurationNew;
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Object object = this.myLock;
        synchronized (object) {
            InfoStorage<SvnBranchConfigurationNew> infoStorage = this.myMap.get(root);
            svnBranchConfigurationNew = infoStorage != null ? infoStorage.getValue() : null;
        }
        return svnBranchConfigurationNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SvnBranchConfigurationNew getConfig(@NotNull VirtualFile root) {
        SvnBranchConfigurationNew svnBranchConfigurationNew;
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Object object = this.myLock;
        synchronized (object) {
            SvnBranchConfigurationNew result;
            InfoStorage<SvnBranchConfigurationNew> value = this.myMap.get(root);
            if (value == null) {
                result = new SvnBranchConfigurationNew();
                Map<VirtualFile, InfoStorage<SvnBranchConfigurationNew>> map = this.myMap;
                VirtualFile virtualFile = root;
                InfoStorage<SvnBranchConfigurationNew> infoStorage = new InfoStorage<SvnBranchConfigurationNew>(result, InfoReliability.empty);
                map.put(virtualFile, infoStorage);
                this.myBranchesLoader.run((Runnable)new DefaultBranchConfigInitializer(this.myProject, this, root));
            } else {
                result = value.getValue();
            }
            svnBranchConfigurationNew = result;
        }
        return svnBranchConfigurationNew;
    }

    public final void reloadBranchesAsync(@NotNull VirtualFile root, @NotNull Url branchLocation, @NotNull InfoReliability reliability) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)branchLocation, (String)"branchLocation");
        Intrinsics.checkParameterIsNotNull((Object)((Object)reliability), (String)"reliability");
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, root, branchLocation, reliability){
            final /* synthetic */ NewRootBunch this$0;
            final /* synthetic */ VirtualFile $root;
            final /* synthetic */ Url $branchLocation;
            final /* synthetic */ InfoReliability $reliability;

            public final void run() {
                this.this$0.reloadBranches(this.$root, this.$branchLocation, this.$reliability, true);
            }
            {
                this.this$0 = newRootBunch;
                this.$root = virtualFile;
                this.$branchLocation = url;
                this.$reliability = infoReliability;
            }
        });
    }

    public final void reloadBranches(@NotNull VirtualFile root, @Nullable SvnBranchConfigurationNew prev, @NotNull SvnBranchConfigurationNew next) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)next, (String)"next");
        Object object = prev;
        if (object == null || (object = ((SvnBranchConfigurationNew)object).getBranchLocations()) == null || (object = CollectionsKt.toSet((Iterable)((Iterable)object))) == null) {
            object = SetsKt.emptySet();
        }
        Object oldUrls = object;
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        if (!vcs.isVcsBackgroundOperationsAllowed(root)) {
            return;
        }
        for (Url newBranchUrl : next.getBranchLocations()) {
            if (!vcs.isVcsBackgroundOperationsAllowed(root)) {
                return;
            }
            if (oldUrls.contains(newBranchUrl)) continue;
            this.reloadBranches(root, newBranchUrl, InfoReliability.defaultValues, true);
        }
    }

    public final void reloadBranches(@NotNull VirtualFile root, @NotNull Url branchLocation, @NotNull InfoReliability reliability, boolean passive) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)branchLocation, (String)"branchLocation");
        Intrinsics.checkParameterIsNotNull((Object)((Object)reliability), (String)"reliability");
        new BranchesLoader(this.myProject, this, branchLocation, reliability, root, passive).run();
    }

    public NewRootBunch(@NotNull Project myProject, @NotNull ProgressManagerQueue myBranchesLoader) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        Intrinsics.checkParameterIsNotNull((Object)myBranchesLoader, (String)"myBranchesLoader");
        this.myProject = myProject;
        this.myBranchesLoader = myBranchesLoader;
        this.myLock = new Object();
        NewRootBunch newRootBunch = this;
        newRootBunch.myMap = map = (Map)new LinkedHashMap();
    }
}

