/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitSvnRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitBranchState;
import git4idea.repo.GitHooksInfo;
import git4idea.repo.GitRefUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepositoryFiles;
import git4idea.validators.GitRefNameValidator;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitRepositoryReader {
    private static final Logger LOG = Logger.getInstance(GitRepositoryReader.class);
    @NotNull
    private final File myHeadFile;
    @NotNull
    private final File myRefsHeadsDir;
    @NotNull
    private final File myRefsRemotesDir;
    @NotNull
    private final File myPackedRefsFile;
    @NotNull
    private final GitRepositoryFiles myGitFiles;

    GitRepositoryReader(@NotNull GitRepositoryFiles gitFiles) {
        if (gitFiles == null) {
            GitRepositoryReader.$$$reportNull$$$0(0);
        }
        this.myGitFiles = gitFiles;
        this.myHeadFile = gitFiles.getHeadFile();
        DvcsUtil.assertFileExists((File)this.myHeadFile, (String)(".git/HEAD file not found at " + this.myHeadFile));
        this.myRefsHeadsDir = gitFiles.getRefsHeadsFile();
        this.myRefsRemotesDir = gitFiles.getRefsRemotesFile();
        this.myPackedRefsFile = gitFiles.getPackedRefsPath();
    }

    @NotNull
    GitBranchState readState(@NotNull Collection<GitRemote> remotes) {
        String currentRevision;
        GitLocalBranch currentBranch;
        if (remotes == null) {
            GitRepositoryReader.$$$reportNull$$$0(1);
        }
        Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> branches2 = this.readBranches(remotes);
        Map localBranches = (Map)branches2.first;
        HeadInfo headInfo = this.readHead();
        Repository.State state = this.readRepositoryState(headInfo);
        if (!headInfo.isBranch || !localBranches.isEmpty()) {
            currentBranch = this.findCurrentBranch(headInfo, state, localBranches.keySet());
            currentRevision = GitRepositoryReader.getCurrentRevision(headInfo, currentBranch == null ? null : (Hash)localBranches.get(currentBranch));
        } else if (headInfo.content != null) {
            currentBranch = new GitLocalBranch(headInfo.content);
            currentRevision = null;
        } else {
            currentBranch = null;
            currentRevision = null;
        }
        if (currentBranch == null && currentRevision == null) {
            LOG.error("Couldn't identify neither current branch nor current revision. .git/HEAD content: [" + headInfo.content + "]");
        }
        GitBranchState gitBranchState = new GitBranchState(currentRevision, currentBranch, state, localBranches, (Map)branches2.second);
        if (gitBranchState == null) {
            GitRepositoryReader.$$$reportNull$$$0(2);
        }
        return gitBranchState;
    }

    @NotNull
    GitHooksInfo readHooksInfo() {
        GitHooksInfo gitHooksInfo = new GitHooksInfo(GitRepositoryReader.isExistingExecutableFile(this.myGitFiles.getPreCommitHookFile()) || GitRepositoryReader.isExistingExecutableFile(this.myGitFiles.getCommitMsgHookFile()), GitRepositoryReader.isExistingExecutableFile(this.myGitFiles.getPrePushHookFile()));
        if (gitHooksInfo == null) {
            GitRepositoryReader.$$$reportNull$$$0(3);
        }
        return gitHooksInfo;
    }

    private static boolean isExistingExecutableFile(@NotNull File file) {
        if (file == null) {
            GitRepositoryReader.$$$reportNull$$$0(4);
        }
        return file.exists() && file.canExecute();
    }

    boolean hasShallowCommits() {
        File shallowFile = this.myGitFiles.getShallowFile();
        if (!shallowFile.exists()) {
            return false;
        }
        return shallowFile.length() > 0L;
    }

    @Nullable
    private static String getCurrentRevision(@NotNull HeadInfo headInfo, @Nullable Hash currentBranchHash) {
        if (headInfo == null) {
            GitRepositoryReader.$$$reportNull$$$0(5);
        }
        Object currentRevision = !headInfo.isBranch ? headInfo.content : (currentBranchHash == null ? null : currentBranchHash.asString());
        return currentRevision;
    }

    @Nullable
    private GitLocalBranch findCurrentBranch(@NotNull HeadInfo headInfo, @NotNull Repository.State state, @NotNull Set<GitLocalBranch> localBranches) {
        String currentBranchName;
        if (headInfo == null) {
            GitRepositoryReader.$$$reportNull$$$0(6);
        }
        if (state == null) {
            GitRepositoryReader.$$$reportNull$$$0(7);
        }
        if (localBranches == null) {
            GitRepositoryReader.$$$reportNull$$$0(8);
        }
        if ((currentBranchName = this.findCurrentBranchName(state, headInfo)) == null) {
            return null;
        }
        return (GitLocalBranch)ContainerUtil.find(localBranches, branch -> GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)branch.getFullName(), (Object)currentBranchName));
    }

    @NotNull
    private Repository.State readRepositoryState(@NotNull HeadInfo headInfo) {
        if (headInfo == null) {
            GitRepositoryReader.$$$reportNull$$$0(9);
        }
        if (this.isMergeInProgress()) {
            Repository.State state = Repository.State.MERGING;
            if (state == null) {
                GitRepositoryReader.$$$reportNull$$$0(10);
            }
            return state;
        }
        if (this.isRebaseInProgress()) {
            Repository.State state = Repository.State.REBASING;
            if (state == null) {
                GitRepositoryReader.$$$reportNull$$$0(11);
            }
            return state;
        }
        if (!headInfo.isBranch) {
            Repository.State state = Repository.State.DETACHED;
            if (state == null) {
                GitRepositoryReader.$$$reportNull$$$0(12);
            }
            return state;
        }
        Repository.State state = Repository.State.NORMAL;
        if (state == null) {
            GitRepositoryReader.$$$reportNull$$$0(13);
        }
        return state;
    }

    @Nullable
    private String findCurrentBranchName(@NotNull Repository.State state, @NotNull HeadInfo headInfo) {
        if (state == null) {
            GitRepositoryReader.$$$reportNull$$$0(14);
        }
        if (headInfo == null) {
            GitRepositoryReader.$$$reportNull$$$0(15);
        }
        String currentBranch = null;
        if (headInfo.isBranch) {
            currentBranch = headInfo.content;
        } else if (state == Repository.State.REBASING && (currentBranch = GitRepositoryReader.readRebaseDirBranchFile(this.myGitFiles.getRebaseApplyDir())) == null) {
            currentBranch = GitRepositoryReader.readRebaseDirBranchFile(this.myGitFiles.getRebaseMergeDir());
        }
        return GitRefUtil.addRefsHeadsPrefixIfNeeded(currentBranch);
    }

    @Nullable
    private static String readRebaseDirBranchFile(@NonNls File rebaseDir) {
        File headName;
        if (rebaseDir.exists() && (headName = new File(rebaseDir, "head-name")).exists()) {
            return DvcsUtil.tryLoadFileOrReturn((File)headName, null, (String)"UTF-8");
        }
        return null;
    }

    private boolean isMergeInProgress() {
        return this.myGitFiles.getMergeHeadFile().exists();
    }

    private boolean isRebaseInProgress() {
        return this.myGitFiles.getRebaseApplyDir().exists() || this.myGitFiles.getRebaseMergeDir().exists();
    }

    @NotNull
    private Map<String, String> readPackedBranches() {
        Map map2;
        if (!this.myPackedRefsFile.exists()) {
            Map<String, String> map3 = Collections.emptyMap();
            if (map3 == null) {
                GitRepositoryReader.$$$reportNull$$$0(16);
            }
            return map3;
        }
        try {
            String content = DvcsUtil.tryLoadFile((File)this.myPackedRefsFile, (String)"UTF-8");
            map2 = ContainerUtil.map2MapNotNull((Object[])LineTokenizer.tokenize((CharSequence)content, (boolean)false), GitRefUtil::parseRefsLine);
        }
        catch (RepoStateException e) {
            Map<String, String> map4 = Collections.emptyMap();
            if (map4 == null) {
                GitRepositoryReader.$$$reportNull$$$0(18);
            }
            return map4;
        }
        if (map2 == null) {
            GitRepositoryReader.$$$reportNull$$$0(17);
        }
        return map2;
    }

    @NotNull
    private Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> readBranches(@NotNull Collection<GitRemote> remotes) {
        if (remotes == null) {
            GitRepositoryReader.$$$reportNull$$$0(19);
        }
        Map<String, String> data = this.readBranchRefsFromFiles();
        Map<String, Hash> resolvedRefs = GitRefUtil.resolveRefs(data);
        Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> pair = GitRepositoryReader.createBranchesFromData(remotes, resolvedRefs);
        if (pair == null) {
            GitRepositoryReader.$$$reportNull$$$0(20);
        }
        return pair;
    }

    @NotNull
    private Map<String, String> readBranchRefsFromFiles() {
        HashMap result2 = ContainerUtil.newHashMap(this.readPackedBranches());
        result2.putAll(GitRepositoryReader.readFromBranchFiles(this.myRefsHeadsDir, "refs/heads/"));
        result2.putAll(GitRepositoryReader.readFromBranchFiles(this.myRefsRemotesDir, "refs/remotes/"));
        result2.remove("refs/remotes/origin/HEAD");
        HashMap hashMap = result2;
        if (hashMap == null) {
            GitRepositoryReader.$$$reportNull$$$0(21);
        }
        return hashMap;
    }

    @NotNull
    private static Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> createBranchesFromData(@NotNull Collection<GitRemote> remotes, @NotNull Map<String, Hash> data) {
        if (remotes == null) {
            GitRepositoryReader.$$$reportNull$$$0(22);
        }
        if (data == null) {
            GitRepositoryReader.$$$reportNull$$$0(23);
        }
        HashMap localBranches = ContainerUtil.newHashMap();
        HashMap remoteBranches = ContainerUtil.newHashMap();
        for (Map.Entry<String, Hash> entry : data.entrySet()) {
            String refName = entry.getKey();
            Hash hash = entry.getValue();
            if (refName.startsWith("refs/heads/")) {
                localBranches.put(new GitLocalBranch(refName), hash);
                continue;
            }
            if (refName.startsWith("refs/remotes/")) {
                remoteBranches.put(GitRepositoryReader.parseRemoteBranch(refName, remotes), hash);
                continue;
            }
            LOG.warn("Unexpected ref format: " + refName);
        }
        Pair pair = Pair.create((Object)localBranches, (Object)remoteBranches);
        if (pair == null) {
            GitRepositoryReader.$$$reportNull$$$0(24);
        }
        return pair;
    }

    @Nullable
    private static String loadHashFromBranchFile(@NotNull File branchFile) {
        if (branchFile == null) {
            GitRepositoryReader.$$$reportNull$$$0(25);
        }
        return DvcsUtil.tryLoadFileOrReturn((File)branchFile, null);
    }

    @NotNull
    private static Map<String, String> readFromBranchFiles(@NotNull File refsRootDir, @NotNull String prefix) {
        if (refsRootDir == null) {
            GitRepositoryReader.$$$reportNull$$$0(26);
        }
        if (prefix == null) {
            GitRepositoryReader.$$$reportNull$$$0(27);
        }
        if (!refsRootDir.exists()) {
            Map<String, String> map2 = Collections.emptyMap();
            if (map2 == null) {
                GitRepositoryReader.$$$reportNull$$$0(28);
            }
            return map2;
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        FileUtil.processFilesRecursively((File)refsRootDir, file -> {
            String relativePath;
            if (!file.isDirectory() && !GitRepositoryReader.isHidden(file) && (relativePath = FileUtil.getRelativePath((File)refsRootDir, (File)file)) != null) {
                String hash;
                String branchName = prefix + FileUtil.toSystemIndependentName((String)relativePath);
                boolean isBranchNameValid = GitRefNameValidator.getInstance().checkInput(branchName);
                if (isBranchNameValid && (hash = GitRepositoryReader.loadHashFromBranchFile(file)) != null) {
                    result2.put(branchName, hash);
                }
            }
            return true;
        }, dir -> !GitRepositoryReader.isHidden(dir));
        HashMap<String, String> hashMap = result2;
        if (hashMap == null) {
            GitRepositoryReader.$$$reportNull$$$0(29);
        }
        return hashMap;
    }

    private static boolean isHidden(@NotNull File file) {
        if (file == null) {
            GitRepositoryReader.$$$reportNull$$$0(30);
        }
        return file.getName().startsWith(".");
    }

    @NotNull
    private static GitRemoteBranch parseRemoteBranch(@NotNull String fullBranchName, @NotNull Collection<GitRemote> remotes) {
        String branchName;
        String remoteName;
        GitRemote remote;
        String stdName;
        int slash;
        if (fullBranchName == null) {
            GitRepositoryReader.$$$reportNull$$$0(31);
        }
        if (remotes == null) {
            GitRepositoryReader.$$$reportNull$$$0(32);
        }
        if ((slash = (stdName = GitBranchUtil.stripRefsPrefix(fullBranchName)).indexOf(47)) == -1) {
            GitSvnRemoteBranch gitSvnRemoteBranch = new GitSvnRemoteBranch(fullBranchName);
            if (gitSvnRemoteBranch == null) {
                GitRepositoryReader.$$$reportNull$$$0(33);
            }
            return gitSvnRemoteBranch;
        }
        do {
            remoteName = stdName.substring(0, slash);
            branchName = stdName.substring(slash + 1);
            remote = GitUtil.findRemoteByName(remotes, remoteName);
            slash = stdName.indexOf(47, slash + 1);
        } while (remote == null && slash >= 0);
        if (remote == null) {
            LOG.trace(String.format("No remote found with the name [%s]. All remotes: %s", remoteName, remotes));
            GitRemote fakeRemote = new GitRemote(remoteName, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            GitStandardRemoteBranch gitStandardRemoteBranch = new GitStandardRemoteBranch(fakeRemote, branchName);
            if (gitStandardRemoteBranch == null) {
                GitRepositoryReader.$$$reportNull$$$0(34);
            }
            return gitStandardRemoteBranch;
        }
        GitStandardRemoteBranch gitStandardRemoteBranch = new GitStandardRemoteBranch(remote, branchName);
        if (gitStandardRemoteBranch == null) {
            GitRepositoryReader.$$$reportNull$$$0(35);
        }
        return gitStandardRemoteBranch;
    }

    @NotNull
    private HeadInfo readHead() {
        String headContent;
        try {
            headContent = DvcsUtil.tryLoadFile((File)this.myHeadFile, (String)"UTF-8");
        }
        catch (RepoStateException e) {
            LOG.error((Throwable)e);
            HeadInfo headInfo = new HeadInfo(false, null);
            if (headInfo == null) {
                GitRepositoryReader.$$$reportNull$$$0(36);
            }
            return headInfo;
        }
        Hash hash = GitRefUtil.parseHash(headContent);
        if (hash != null) {
            HeadInfo headInfo = new HeadInfo(false, headContent);
            if (headInfo == null) {
                GitRepositoryReader.$$$reportNull$$$0(37);
            }
            return headInfo;
        }
        String target = GitRefUtil.getTarget(headContent);
        if (target != null) {
            HeadInfo headInfo = new HeadInfo(true, target);
            if (headInfo == null) {
                GitRepositoryReader.$$$reportNull$$$0(38);
            }
            return headInfo;
        }
        LOG.error((Throwable)new RepoStateException("Invalid format of the .git/HEAD file: [" + headContent + "]"));
        HeadInfo headInfo = new HeadInfo(false, null);
        if (headInfo == null) {
            GitRepositoryReader.$$$reportNull$$$0(39);
        }
        return headInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitFiles";
                break;
            }
            case 1: 
            case 19: 
            case 22: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotes";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitRepositoryReader";
                break;
            }
            case 4: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headInfo";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranches";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchFile";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refsRootDir";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullBranchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitRepositoryReader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readHooksInfo";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "readRepositoryState";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "readPackedBranches";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "readBranches";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "readBranchRefsFromFiles";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createBranchesFromData";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "readFromBranchFiles";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRemoteBranch";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "readHead";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isExistingExecutableFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRevision";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findCurrentBranch";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readRepositoryState";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findCurrentBranchName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readBranches";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createBranchesFromData";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loadHashFromBranchFile";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "readFromBranchFiles";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isHidden";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "parseRemoteBranch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HeadInfo {
        @Nullable
        private final String content;
        private final boolean isBranch;

        HeadInfo(boolean branch, @Nullable String content) {
            this.isBranch = branch;
            this.content = content;
        }
    }
}

