/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;

public class PyResolveContext {
    private final boolean myAllowImplicits;
    private final boolean myAllowProperties;
    private final boolean myAllowRemote;
    private final TypeEvalContext myTypeEvalContext;
    private static final PyResolveContext ourDefaultContext = new PyResolveContext(true, true);
    private static final PyResolveContext ourNoImplicitsContext = new PyResolveContext(false, true);
    private static final PyResolveContext ourNoPropertiesContext = new PyResolveContext(false, false);

    private PyResolveContext(boolean allowImplicits, boolean allowProperties) {
        this.myAllowImplicits = allowImplicits;
        this.myAllowProperties = allowProperties;
        this.myTypeEvalContext = null;
        this.myAllowRemote = false;
    }

    private PyResolveContext(boolean allowImplicits, boolean allowProperties, boolean allowRemote, TypeEvalContext typeEvalContext) {
        this.myAllowImplicits = allowImplicits;
        this.myAllowProperties = allowProperties;
        this.myAllowRemote = allowRemote;
        this.myTypeEvalContext = typeEvalContext;
    }

    public boolean allowImplicits() {
        return this.myAllowImplicits;
    }

    public boolean allowProperties() {
        return this.myAllowProperties;
    }

    public boolean allowRemote() {
        return this.myAllowRemote;
    }

    public static PyResolveContext defaultContext() {
        return ourDefaultContext;
    }

    public static PyResolveContext noImplicits() {
        return ourNoImplicitsContext;
    }

    public static PyResolveContext noProperties() {
        return ourNoPropertiesContext;
    }

    public PyResolveContext withTypeEvalContext(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyResolveContext.$$$reportNull$$$0(0);
        }
        return new PyResolveContext(this.myAllowImplicits, this.myAllowProperties, this.myAllowRemote, context);
    }

    public PyResolveContext withoutImplicits() {
        return new PyResolveContext(false, this.myAllowProperties, this.myAllowRemote, this.myTypeEvalContext);
    }

    public PyResolveContext withRemote() {
        return new PyResolveContext(this.myAllowImplicits, this.myAllowProperties, true, this.myTypeEvalContext);
    }

    public TypeEvalContext getTypeEvalContext() {
        return this.myTypeEvalContext != null ? this.myTypeEvalContext : TypeEvalContext.codeInsightFallback(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyResolveContext that = (PyResolveContext)o;
        if (this.myAllowImplicits != that.myAllowImplicits) {
            return false;
        }
        return !(this.myTypeEvalContext != null ? !this.myTypeEvalContext.equals(that.myTypeEvalContext) : that.myTypeEvalContext != null);
    }

    public int hashCode() {
        int result = this.myAllowImplicits ? 1 : 0;
        result = 31 * result + (this.myTypeEvalContext != null ? this.myTypeEvalContext.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/psi/resolve/PyResolveContext", "withTypeEvalContext"));
    }
}

