/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.DictCreationQuickFix;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PySubscriptionExpression;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDictCreationInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.dict.creation", new Object[0]);
        if (string == null) {
            PyDictCreationInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyDictCreationInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            PyDictCreationInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session);
        if (visitor2 == null) {
            PyDictCreationInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    @Nullable
    public static List<Pair<PyExpression, PyExpression>> getDictTargets(@NotNull PyExpression target, @NotNull String name, @NotNull PyAssignmentStatement assignmentStatement) {
        if (target == null) {
            PyDictCreationInspection.$$$reportNull$$$0(4);
        }
        if (name == null) {
            PyDictCreationInspection.$$$reportNull$$$0(5);
        }
        if (assignmentStatement == null) {
            PyDictCreationInspection.$$$reportNull$$$0(6);
        }
        ArrayList<Pair<PyExpression, PyExpression>> targets = new ArrayList<Pair<PyExpression, PyExpression>>();
        for (Pair<PyExpression, PyExpression> targetToValue : assignmentStatement.getTargetsToValuesMapping()) {
            if (targetToValue.first instanceof PySubscriptionExpression) {
                PySubscriptionExpression subscriptionExpression = (PySubscriptionExpression)targetToValue.first;
                if (!name.equals(subscriptionExpression.getOperand().getName()) || subscriptionExpression.getIndexExpression() == null || PyDictCreationInspection.referencesTarget((PyExpression)targetToValue.second, (PsiElement)target)) continue;
                targets.add(targetToValue);
                continue;
            }
            return null;
        }
        return targets;
    }

    private static boolean referencesTarget(@NotNull PyExpression expression, final @NotNull PsiElement target) {
        if (expression == null) {
            PyDictCreationInspection.$$$reportNull$$$0(7);
        }
        if (target == null) {
            PyDictCreationInspection.$$$reportNull$$$0(8);
        }
        final ArrayList refs = new ArrayList();
        expression.accept(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReferenceExpression(PyReferenceExpression node) {
                super.visitPyReferenceExpression(node);
                PsiPolyVariantReference ref = node.getReference();
                if (ref.isReferenceTo(target)) {
                    refs.add(node);
                }
            }
        });
        return !refs.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyDictCreationInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentStatement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyDictCreationInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDictTargets";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "referencesTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyAssignmentStatement(PyAssignmentStatement node) {
            if (node.getAssignedValue() instanceof PyDictLiteralExpression) {
                if (node.getTargets().length != 1) {
                    return;
                }
                PyExpression target = node.getTargets()[0];
                String name = target.getName();
                if (name == null) {
                    return;
                }
                PyStatement statement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)node, PyStatement.class);
                while (statement instanceof PyAssignmentStatement) {
                    PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)statement;
                    List<Pair<PyExpression, PyExpression>> targets = PyDictCreationInspection.getDictTargets(target, name, assignmentStatement);
                    if (targets == null) {
                        return;
                    }
                    if (!targets.isEmpty()) {
                        this.registerProblem((PsiElement)node, "This dictionary creation could be rewritten as a dictionary literal", new DictCreationQuickFix(node));
                        break;
                    }
                    statement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)assignmentStatement, PyStatement.class);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyDictCreationInspection$Visitor", "<init>"));
        }
    }
}

