/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyExpressionCodeFragmentImpl;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonCopyPasteProcessor
implements CopyPastePreProcessor {
    private static final Set<String> START_KEYWORDS = ImmutableSet.of((Object)"async", (Object)"def", (Object)"class", (Object)"with", (Object)"if", (Object)"elif", (Object[])new String[]{"else", "while", "for", "try", "except", "finally"});

    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text2) {
        if (!CodeInsightSettings.getInstance().INDENT_TO_CARET_ON_PASTE || file.getLanguage() != PythonLanguage.getInstance()) {
            return null;
        }
        if (startOffsets.length == 1 && endOffsets.length == 1 && PythonCopyPasteProcessor.fragmentBeginsWithBlockStatement(text2)) {
            String linePrefix;
            PyStatementListContainer block;
            PsiElement keyword;
            int startLine;
            int startLineOffset;
            int start = startOffsets[0];
            int end = endOffsets[0];
            Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
            if (document != null && start != (startLineOffset = PythonCopyPasteProcessor.getLineStartSafeOffset(document, startLine = document.getLineNumber(start))) && startLine != document.getLineNumber(end) && (keyword = file.findElementAt(start)) != null && START_KEYWORDS.contains(keyword.getText()) && (block = (PyStatementListContainer)PsiTreeUtil.getParentOfType((PsiElement)keyword, PyStatementListContainer.class)) != null && end > block.getStatementList().getTextOffset() && StringUtil.isEmptyOrSpaces((String)(linePrefix = document.getText(TextRange.create((int)startLineOffset, (int)start))))) {
                return linePrefix + text2;
            }
        }
        return null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text2, RawText rawText) {
        boolean useTabs;
        if (!CodeInsightSettings.getInstance().INDENT_TO_CARET_ON_PASTE || file.getLanguage() != PythonLanguage.getInstance()) {
            String string = text2;
            if (string == null) {
                PythonCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        CaretModel caretModel = editor.getCaretModel();
        SelectionModel selectionModel = editor.getSelectionModel();
        Document document = editor.getDocument();
        int caretOffset = selectionModel.getSelectionStart() != selectionModel.getSelectionEnd() ? selectionModel.getSelectionStart() : caretModel.getOffset();
        int lineNumber = document.getLineNumber(caretOffset);
        int lineStartOffset = PythonCopyPasteProcessor.getLineStartSafeOffset(document, lineNumber);
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        String line = document.getText(TextRange.create((int)lineStartOffset, (int)lineEndOffset));
        String linePrefix = document.getText(TextRange.create((int)lineStartOffset, (int)caretOffset));
        if (!StringUtil.isEmptyOrSpaces((String)linePrefix)) {
            String string = text2;
            if (string == null) {
                PythonCopyPasteProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        PsiElement element = file.findElementAt(caretOffset);
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PyStringLiteralExpression.class) != null) {
            String string = text2;
            if (string == null) {
                PythonCopyPasteProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }
        text2 = PythonCopyPasteProcessor.addLeadingSpacesToNormalizeSelection(file, text2);
        String fragmentIndent = PyIndentUtil.findCommonIndent(text2, false);
        String newIndent = PythonCopyPasteProcessor.inferBestIndent(file, document, caretOffset, lineNumber, fragmentIndent);
        String newText = PyIndentUtil.changeIndent(text2, false, newIndent);
        if (!selectionModel.hasSelection() && PythonCopyPasteProcessor.shouldPasteOnPreviousLine(file, text2, caretOffset)) {
            caretModel.moveToOffset(lineStartOffset);
            if (StringUtil.isEmptyOrSpaces((String)line)) {
                ApplicationManager.getApplication().runWriteAction(() -> document.deleteString(lineStartOffset, lineEndOffset));
            }
        } else {
            newText = StringUtil.trimStart((String)newText, (String)linePrefix);
        }
        if (PythonCopyPasteProcessor.addLinebreak(text2, line, useTabs = PyIndentUtil.areTabsUsedForIndentation(file)) && selectionModel.getSelectionStart() == selectionModel.getSelectionEnd()) {
            newText = newText + "\n";
        }
        String string = newText;
        if (string == null) {
            PythonCopyPasteProcessor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String addLeadingSpacesToNormalizeSelection(@NotNull PsiFile file, @NotNull String text2) {
        String expectedBodyIndent;
        if (file == null) {
            PythonCopyPasteProcessor.$$$reportNull$$$0(4);
        }
        if (text2 == null) {
            PythonCopyPasteProcessor.$$$reportNull$$$0(5);
        }
        if (!PythonCopyPasteProcessor.fragmentBeginsWithBlockStatement(text2)) {
            String string = text2;
            if (string == null) {
                PythonCopyPasteProcessor.$$$reportNull$$$0(6);
            }
            return string;
        }
        PyExpressionCodeFragmentImpl fragment = new PyExpressionCodeFragmentImpl(file.getProject(), "dummy.py", text2, false);
        PyStatementListContainer statement = PyUtil.as(fragment.getFirstChild(), PyStatementListContainer.class);
        if (statement == null) {
            String string = text2;
            if (string == null) {
                PythonCopyPasteProcessor.$$$reportNull$$$0(7);
            }
            return string;
        }
        String statementIndent = PyIndentUtil.getElementIndent((PsiElement)statement);
        if (!statementIndent.isEmpty()) {
            String string = text2;
            if (string == null) {
                PythonCopyPasteProcessor.$$$reportNull$$$0(8);
            }
            return string;
        }
        String indentStep = PyIndentUtil.getIndentFromSettings(file);
        String bodyIndent = PyIndentUtil.getElementIndent((PsiElement)statement.getStatementList());
        if (bodyIndent.startsWith(expectedBodyIndent = statementIndent + indentStep)) {
            String string = bodyIndent.substring(0, bodyIndent.length() - indentStep.length()) + text2;
            if (string == null) {
                PythonCopyPasteProcessor.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = text2;
        if (string == null) {
            PythonCopyPasteProcessor.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static boolean fragmentBeginsWithBlockStatement(@NotNull String text2) {
        if (text2 == null) {
            PythonCopyPasteProcessor.$$$reportNull$$$0(11);
        }
        return ContainerUtil.exists(START_KEYWORDS, keyword -> text2.startsWith(keyword + " ") || text2.startsWith(keyword + ":"));
    }

    @NotNull
    private static String inferBestIndent(@NotNull PsiFile file, @NotNull Document document, int caretOffset, int lineNumber, @NotNull String fragmentIndent) {
        IElementType nonWSType;
        PsiElement nonWS;
        if (file == null) {
            PythonCopyPasteProcessor.$$$reportNull$$$0(12);
        }
        if (document == null) {
            PythonCopyPasteProcessor.$$$reportNull$$$0(13);
        }
        if (fragmentIndent == null) {
            PythonCopyPasteProcessor.$$$reportNull$$$0(14);
        }
        if ((nonWS = PyUtil.findNextAtOffset(file, caretOffset, PsiWhiteSpace.class)) != null && ((nonWSType = nonWS.getNode().getElementType()) == PyTokenTypes.ELSE_KEYWORD || nonWSType == PyTokenTypes.ELIF_KEYWORD || nonWSType == PyTokenTypes.EXCEPT_KEYWORD || nonWSType == PyTokenTypes.FINALLY_KEYWORD)) {
            nonWS = PyUtil.findNextAtOffset(file, PythonCopyPasteProcessor.getLineStartSafeOffset(document, --lineNumber), PsiWhiteSpace.class);
        }
        if (nonWS != null && document.getLineNumber(nonWS.getTextOffset()) == lineNumber) {
            String string = PyIndentUtil.getLineIndent(document, lineNumber);
            if (string == null) {
                PythonCopyPasteProcessor.$$$reportNull$$$0(15);
            }
            return string;
        }
        int lineStartOffset = PythonCopyPasteProcessor.getLineStartSafeOffset(document, lineNumber);
        PsiElement ws = file.findElementAt(lineStartOffset);
        String userIndent = document.getText(TextRange.create((int)lineStartOffset, (int)caretOffset));
        PyStatementList statementList = PythonCopyPasteProcessor.findEmptyStatementListNearby(file, lineStartOffset);
        if (statementList != null) {
            String string = PyIndentUtil.getElementIndent((PsiElement)statementList);
            if (string == null) {
                PythonCopyPasteProcessor.$$$reportNull$$$0(16);
            }
            return string;
        }
        String smallestIndent = ws == null ? "" : PyIndentUtil.getElementIndent(ws);
        PyStatementListContainer parentBlock = (PyStatementListContainer)PsiTreeUtil.getParentOfType((PsiElement)ws, PyStatementListContainer.class);
        PyStatementListContainer deepestBlock = PythonCopyPasteProcessor.getDeepestPossibleParentBlock(file, caretOffset);
        String greatestIndent = deepestBlock != null && (parentBlock == null || PsiTreeUtil.isAncestor((PsiElement)parentBlock, (PsiElement)deepestBlock, (boolean)true)) ? PyIndentUtil.getElementIndent((PsiElement)deepestBlock.getStatementList()) : smallestIndent;
        if (caretOffset == lineStartOffset && fragmentIndent.startsWith(smallestIndent) && greatestIndent.startsWith(fragmentIndent)) {
            String string = fragmentIndent;
            if (string == null) {
                PythonCopyPasteProcessor.$$$reportNull$$$0(17);
            }
            return string;
        }
        if (smallestIndent.startsWith(userIndent)) {
            String string = smallestIndent;
            if (string == null) {
                PythonCopyPasteProcessor.$$$reportNull$$$0(18);
            }
            return string;
        }
        if (userIndent.startsWith(greatestIndent)) {
            String string = greatestIndent;
            if (string == null) {
                PythonCopyPasteProcessor.$$$reportNull$$$0(19);
            }
            return string;
        }
        String string = userIndent;
        if (string == null) {
            PythonCopyPasteProcessor.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Nullable
    private static PyStatementList findEmptyStatementListNearby(@NotNull PsiFile file, int offset) {
        PsiElement prevLeaf;
        PsiWhiteSpace whitespace;
        if (file == null) {
            PythonCopyPasteProcessor.$$$reportNull$$$0(21);
        }
        if ((whitespace = PythonCopyPasteProcessor.findWhitespaceAtCaret(file, offset)) == null) {
            return null;
        }
        PyStatementList statementList = (PyStatementList)ObjectUtils.chooseNotNull((Object)PyUtil.as(whitespace.getNextSibling(), PyStatementList.class), (Object)PyUtil.as(whitespace.getPrevSibling(), PyStatementList.class));
        if (statementList == null && (prevLeaf = PythonCopyPasteProcessor.getPrevNonCommentLeaf((PsiElement)whitespace)) instanceof PsiErrorElement) {
            statementList = PyUtil.as(prevLeaf.getParent(), PyStatementList.class);
        }
        return statementList != null && statementList.getStatements().length == 0 ? statementList : null;
    }

    @Nullable
    private static PsiWhiteSpace findWhitespaceAtCaret(@NotNull PsiFile file, int offset) {
        if (file == null) {
            PythonCopyPasteProcessor.$$$reportNull$$$0(22);
        }
        return PyUtil.as(file.findElementAt(offset == file.getTextLength() && offset > 0 ? offset - 1 : offset), PsiWhiteSpace.class);
    }

    @Nullable
    private static PyStatementListContainer getDeepestPossibleParentBlock(@NotNull PsiFile file, int offset) {
        PsiWhiteSpace whitespace;
        if (file == null) {
            PythonCopyPasteProcessor.$$$reportNull$$$0(23);
        }
        if ((whitespace = PythonCopyPasteProcessor.findWhitespaceAtCaret(file, offset)) == null) {
            return null;
        }
        PsiElement prevLeaf = PythonCopyPasteProcessor.getPrevNonCommentLeaf((PsiElement)whitespace);
        return (PyStatementListContainer)PsiTreeUtil.getParentOfType((PsiElement)prevLeaf, PyStatementListContainer.class);
    }

    private static boolean shouldPasteOnPreviousLine(@NotNull PsiFile file, @NotNull String text2, int caretOffset) {
        if (file == null) {
            PythonCopyPasteProcessor.$$$reportNull$$$0(24);
        }
        if (text2 == null) {
            PythonCopyPasteProcessor.$$$reportNull$$$0(25);
        }
        boolean useTabs = PyIndentUtil.areTabsUsedForIndentation(file);
        PsiElement nonWS = PyUtil.findNextAtOffset(file, caretOffset, PsiWhiteSpace.class);
        if (nonWS == null || text2.endsWith("\n")) {
            return true;
        }
        return PythonCopyPasteProcessor.inStatementList(file, caretOffset) && (text2.startsWith(useTabs ? "\t" : " ") || StringUtil.split((String)text2, (String)"\n").size() > 1);
    }

    @Nullable
    private static PsiElement getPrevNonCommentLeaf(@NotNull PsiElement element) {
        if (element == null) {
            PythonCopyPasteProcessor.$$$reportNull$$$0(26);
        }
        PsiElement anchor = PsiTreeUtil.prevLeaf((PsiElement)element);
        while (anchor instanceof PsiComment || anchor instanceof PsiWhiteSpace) {
            anchor = PsiTreeUtil.prevLeaf((PsiElement)anchor, (boolean)false);
        }
        return anchor;
    }

    private static boolean inStatementList(@NotNull PsiFile file, int caretOffset) {
        PsiElement element;
        if (file == null) {
            PythonCopyPasteProcessor.$$$reportNull$$$0(27);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)(element = file.findElementAt(caretOffset)), PyStatementListContainer.class) != null;
    }

    private static boolean addLinebreak(@NotNull String text2, @NotNull String line, boolean useTabs) {
        if (text2 == null) {
            PythonCopyPasteProcessor.$$$reportNull$$$0(28);
        }
        if (line == null) {
            PythonCopyPasteProcessor.$$$reportNull$$$0(29);
        }
        return (text2.startsWith(useTabs ? "\t" : " ") || StringUtil.split((String)text2, (String)"\n").size() > 1) && !text2.endsWith("\n") && !StringUtil.isEmptyOrSpaces((String)line);
    }

    private static int getLineStartSafeOffset(Document document, int line) {
        if (line >= document.getLineCount()) {
            return document.getTextLength();
        }
        if (line < 0) {
            return 0;
        }
        return document.getLineStartOffset(line);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/editor/PythonCopyPasteProcessor";
                break;
            }
            case 4: 
            case 12: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 11: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentIndent";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/editor/PythonCopyPasteProcessor";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "addLeadingSpacesToNormalizeSelection";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "inferBestIndent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addLeadingSpacesToNormalizeSelection";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fragmentBeginsWithBlockStatement";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "inferBestIndent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findEmptyStatementListNearby";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findWhitespaceAtCaret";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestPossibleParentBlock";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "shouldPasteOnPreviousLine";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPrevNonCommentLeaf";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "inStatementList";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addLinebreak";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

