/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions.convertToFString;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.PySubstitutionChunkReference;
import com.jetbrains.python.inspections.PyStringFormatParser;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseConvertToFStringProcessor<T extends PyStringFormatParser.SubstitutionChunk> {
    protected final PyStringLiteralExpression myPyString;
    protected final PyUtil.StringNodeInfo myNodeInfo;

    protected BaseConvertToFStringProcessor(@NotNull PyStringLiteralExpression pyString) {
        if (pyString == null) {
            BaseConvertToFStringProcessor.$$$reportNull$$$0(0);
        }
        this.myPyString = pyString;
        this.myNodeInfo = new PyUtil.StringNodeInfo(pyString.getStringNodes().get(0));
    }

    public final boolean isRefactoringAvailable() {
        if (this.myPyString.getStringNodes().size() > 1 || this.myNodeInfo.isBytes() || this.myNodeInfo.isFormatted()) {
            return false;
        }
        PsiElement valuesSource = this.getValuesSource();
        if (valuesSource == null) {
            return false;
        }
        List<T> chunks = this.extractAllSubstitutionChunks();
        for (PyStringFormatParser.SubstitutionChunk chunk : chunks) {
            if (!this.checkChunk(chunk)) {
                return false;
            }
            PySubstitutionChunkReference reference = this.createReference(chunk);
            PyExpression referencedExpr = BaseConvertToFStringProcessor.adjustResolveResult(reference.resolve());
            if (referencedExpr == null) {
                return false;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)valuesSource, (PsiElement)referencedExpr, (boolean)false)) {
                return false;
            }
            if (referencedExpr instanceof PyStarExpression || referencedExpr instanceof PyStarArgument) {
                return false;
            }
            if (this.checkReferencedExpression(chunks, chunk, valuesSource, referencedExpr)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkReferencedExpression(@NotNull List<T> chunks, @NotNull T chunk, @NotNull PsiElement valueSource, @NotNull PyExpression expression) {
        if (chunks == null) {
            BaseConvertToFStringProcessor.$$$reportNull$$$0(1);
        }
        if (chunk == null) {
            BaseConvertToFStringProcessor.$$$reportNull$$$0(2);
        }
        if (valueSource == null) {
            BaseConvertToFStringProcessor.$$$reportNull$$$0(3);
        }
        if (expression == null) {
            BaseConvertToFStringProcessor.$$$reportNull$$$0(4);
        }
        if (expression.textContains('\\') || expression.textContains('\n')) {
            return false;
        }
        return this.adjustQuotesInsideInjectedExpression((PsiElement)expression) != null;
    }

    public final void doRefactoring() {
        String stringText = this.myPyString.getText();
        StringBuilder fStringText = new StringBuilder();
        fStringText.append("f");
        fStringText.append(StringUtil.replaceIgnoreCase((String)this.myNodeInfo.getPrefix(), (String)"u", (String)""));
        fStringText.append(this.myNodeInfo.getQuote());
        TextRange contentRange = this.myNodeInfo.getContentRange();
        int offset = contentRange.getStartOffset();
        for (PyStringFormatParser.SubstitutionChunk chunk : this.extractTopLevelSubstitutionChunks()) {
            fStringText.append(stringText, offset, chunk.getStartIndex());
            offset = chunk.getEndIndex();
            if (this.convertSubstitutionChunk(chunk, fStringText)) continue;
            return;
        }
        if (offset < contentRange.getEndOffset()) {
            fStringText.append(stringText, offset, contentRange.getEndOffset());
        }
        fStringText.append(this.myNodeInfo.getQuote());
        PyExpression expressionToReplace = this.getWholeExpressionToReplace();
        PyElementGenerator generator = PyElementGenerator.getInstance(this.myPyString.getProject());
        PyExpression fString = generator.createExpressionFromText(LanguageLevel.forElement(this.myPyString), fStringText.toString());
        expressionToReplace.replace((PsiElement)fString);
    }

    @NotNull
    protected abstract List<T> extractAllSubstitutionChunks();

    @NotNull
    protected List<T> extractTopLevelSubstitutionChunks() {
        List<T> list = this.extractAllSubstitutionChunks();
        if (list == null) {
            BaseConvertToFStringProcessor.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    protected abstract PySubstitutionChunkReference createReference(@NotNull T var1);

    protected abstract boolean checkChunk(@NotNull T var1);

    protected abstract boolean convertSubstitutionChunk(@NotNull T var1, @NotNull StringBuilder var2);

    @Nullable
    protected PsiElement adjustQuotesInsideInjectedExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            BaseConvertToFStringProcessor.$$$reportNull$$$0(6);
        }
        PsiElement copied = expression.copy();
        char hostQuote = this.myNodeInfo.getSingleQuote();
        PyElementGenerator generator = PyElementGenerator.getInstance(this.myPyString.getProject());
        Collection innerStrings = PsiTreeUtil.collectElementsOfType((PsiElement)copied, (Class[])new Class[]{PyStringLiteralExpression.class});
        for (PyStringLiteralExpression literal : innerStrings) {
            List<ASTNode> nodes = literal.getStringNodes();
            if (nodes.size() > 1) {
                return copied;
            }
            PyUtil.StringNodeInfo info = new PyUtil.StringNodeInfo(nodes.get(0));
            String content2 = info.getContent();
            if (content2.indexOf(hostQuote) >= 0) {
                return null;
            }
            if (!info.isTerminated()) {
                return null;
            }
            if (!info.getQuote().startsWith(this.myNodeInfo.getQuote())) continue;
            char targetSingleQuote = PyStringLiteralUtil.flipQuote(hostQuote);
            if (content2.indexOf(targetSingleQuote) >= 0) {
                return null;
            }
            String targetQuote = info.getQuote().replace(hostQuote, targetSingleQuote);
            String stringWithSwappedQuotes = info.getPrefix() + targetQuote + content2 + targetQuote;
            PsiElement replaced = literal.replace(generator.createStringLiteralAlreadyEscaped(stringWithSwappedQuotes));
            if (literal != copied) continue;
            return replaced;
        }
        return copied;
    }

    @NotNull
    protected abstract PyExpression getWholeExpressionToReplace();

    @Nullable
    protected abstract PsiElement getValuesSource();

    @Nullable
    protected PsiElement prepareExpressionToInject(@NotNull PyExpression expression, @NotNull T chunk) {
        PsiElement quoted;
        if (expression == null) {
            BaseConvertToFStringProcessor.$$$reportNull$$$0(7);
        }
        if (chunk == null) {
            BaseConvertToFStringProcessor.$$$reportNull$$$0(8);
        }
        if ((quoted = this.adjustQuotesInsideInjectedExpression((PsiElement)expression)) == null) {
            return null;
        }
        if (quoted instanceof PyLambdaExpression) {
            return this.wrapExpressionInParentheses(quoted);
        }
        return quoted;
    }

    @Nullable
    protected final PsiElement wrapExpressionInParentheses(@NotNull PsiElement expression) {
        if (expression == null) {
            BaseConvertToFStringProcessor.$$$reportNull$$$0(9);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(this.myPyString.getProject());
        return generator.createExpressionFromText(LanguageLevel.forElement(this.myPyString), "(" + expression.getText() + ")");
    }

    @Nullable
    protected static PyExpression adjustResolveResult(@Nullable PsiElement resolveResult) {
        if (resolveResult == null) {
            return null;
        }
        PyKeywordArgument argument = PyUtil.as(resolveResult, PyKeywordArgument.class);
        if (argument != null) {
            return argument.getValueExpression();
        }
        PyKeyValueExpression parent = PyUtil.as(resolveResult.getParent(), PyKeyValueExpression.class);
        if (parent != null && parent.getKey() == resolveResult) {
            return parent.getValue();
        }
        return PyUtil.as(resolveResult, PyExpression.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueSource";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/convertToFString/BaseConvertToFStringProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/convertToFString/BaseConvertToFStringProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTopLevelSubstitutionChunks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkReferencedExpression";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "adjustQuotesInsideInjectedExpression";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareExpressionToInject";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "wrapExpressionInParentheses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

