/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FileTypeUsagesCollector
extends ProjectUsagesCollector {
    @Override
    @NotNull
    public String getGroupId() {
        if ("statistics.file.types" == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(0);
        }
        return "statistics.file.types";
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        if (project == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(1);
        }
        Set<UsageDescriptor> set = FileTypeUsagesCollector.getDescriptors(project);
        if (set == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public static Set<UsageDescriptor> getDescriptors(@NotNull Project project) {
        FileType[] registeredFileTypes;
        if (project == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(3);
        }
        HashSet usedFileTypes = new HashSet();
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (fileTypeManager == null) {
            Set<UsageDescriptor> set = Collections.emptySet();
            if (set == null) {
                FileTypeUsagesCollector.$$$reportNull$$$0(4);
            }
            return set;
        }
        for (FileType fileType2 : registeredFileTypes = fileTypeManager.getRegisteredFileTypes()) {
            if (project.isDisposed()) {
                Set<UsageDescriptor> set = Collections.emptySet();
                if (set == null) {
                    FileTypeUsagesCollector.$$$reportNull$$$0(5);
                }
                return set;
            }
            PluginType type = StatisticsUtilKt.getPluginType(fileType2.getClass());
            if (!type.isSafeToReport()) continue;
            ApplicationManager.getApplication().runReadAction(() -> FileTypeIndex.processFiles(fileType2, (Processor<? super VirtualFile>)((Processor)file2 -> {
                if (!ProjectKt.getStateStore(project).isProjectFile((VirtualFile)file2)) {
                    usedFileTypes.add(fileType2);
                    return false;
                }
                return true;
            }), GlobalSearchScope.projectScope((Project)project)));
        }
        Set set = ContainerUtil.map2Set(usedFileTypes, (Function)((NotNullFunction)fileType -> new UsageDescriptor(fileType.getName(), 1)));
        if (set == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(6);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsagesCollector";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsagesCollector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

