/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.ProjectGroup;
import com.intellij.ide.ProjectGroupActionGroup;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.ui.ProductIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.SystemDock;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.project.ProjectKt;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public abstract class RecentProjectsManagerBase
extends RecentProjectsManager
implements PersistentStateComponent<State> {
    private static final int MAX_PROJECTS_IN_MAIN_MENU = 6;
    private static final Map<String, MyIcon> ourProjectIcons = new HashMap<String, MyIcon>();
    private static Icon ourSmallAppIcon;
    private final Alarm myNamesResolver;
    private final Set<String> myNamesToResolve;
    private final Object myStateLock;
    private State myState;
    private final Map<String, String> myNameCache;
    private boolean myBatchOpening;

    public static RecentProjectsManagerBase getInstanceEx() {
        return (RecentProjectsManagerBase)RecentProjectsManager.getInstance();
    }

    protected RecentProjectsManagerBase(@NotNull MessageBus messageBus) {
        if (messageBus == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(0);
        }
        this.myNamesResolver = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());
        this.myNamesToResolve = new HashSet<String>(6);
        this.myStateLock = new Object();
        this.myState = new State();
        this.myNameCache = Collections.synchronizedMap(new THashMap());
        MessageBusConnection connection = messageBus.connect();
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new MyAppLifecycleListener());
        connection.subscribe(ProjectManager.TOPIC, (Object)new MyProjectListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        Object object = this.myStateLock;
        synchronized (object) {
            if (this.myState.pid == null) {
                this.myState.pid = "";
            }
            this.updateLastProjectPath();
            this.myState.validateRecentProjects();
            this.myState.updateOpenProjectsTimestamps(this);
            return this.myState;
        }
    }

    @NotNull
    protected State getStateInner() {
        State state = this.myState;
        if (state == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(1);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull State state) {
        File lastFile;
        if (state == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(2);
        }
        state.makePathsSystemIndependent();
        this.removeDuplicates(state);
        if (state.lastPath != null && (!(lastFile = new File(PathUtil.toSystemDependentName((String)state.lastPath))).exists() || lastFile.isDirectory() && !new File(lastFile, ".idea").exists())) {
            state.lastPath = null;
        }
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState = state;
            this.myState.pid = null;
        }
    }

    protected void removeDuplicates(State state) {
        for (String path : new ArrayList<String>(state.recentPaths)) {
            if (!path.endsWith("/")) continue;
            state.recentPaths.remove(path);
            state.additionalInfo.remove(path);
            state.openPaths.remove(path);
        }
    }

    private static void removePathFrom(List<String> items, String path) {
        Iterator<String> iterator = items.iterator();
        while (iterator.hasNext()) {
            String next = iterator.next();
            if (!(SystemInfo.isFileSystemCaseSensitive ? path.equals(next) : path.equalsIgnoreCase(next))) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePath(@Nullable @SystemIndependent String path) {
        if (path == null) {
            return;
        }
        Object object = this.myStateLock;
        synchronized (object) {
            RecentProjectsManagerBase.removePathFrom(this.myState.recentPaths, path);
            this.myState.names.remove(path);
            for (ProjectGroup group : this.myState.groups) {
                group.removeProject(path);
            }
        }
    }

    public boolean hasPath(@SystemIndependent String path) {
        State state = this.getState();
        return state != null && state.recentPaths.contains(path);
    }

    @Nullable
    public @SystemIndependent String getLastProjectCreationLocation() {
        return this.myState.lastProjectLocation;
    }

    public void setLastProjectCreationLocation(@Nullable @SystemIndependent String lastProjectLocation) {
        String location = StringUtil.nullize((String)lastProjectLocation, (boolean)true);
        this.myState.lastProjectLocation = PathUtil.toSystemIndependentName((String)location);
    }

    public @SystemIndependent String getLastProjectPath() {
        return this.myState.lastPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastProjectPath() {
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.openPaths.clear();
            if (openProjects.length == 0) {
                this.myState.lastPath = null;
            } else {
                this.myState.lastPath = this.getProjectPath(openProjects[openProjects.length - 1]);
                for (Project openProject : openProjects) {
                    String path = this.getProjectPath(openProject);
                    if (path == null) continue;
                    this.myState.openPaths.add(path);
                    this.myState.names.put(path, this.getProjectDisplayName(openProject));
                }
            }
        }
    }

    @NotNull
    protected String getProjectDisplayName(@NotNull Project project) {
        if (project == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(3);
        }
        if ("" == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(4);
        }
        return "";
    }

    @Nullable
    public static Icon getProjectIcon(@SystemIndependent String path, boolean isDark) {
        MyIcon icon = ourProjectIcons.get(path);
        if (icon != null) {
            return icon.getIcon();
        }
        return IconDeferrer.getInstance().defer(EmptyIcon.ICON_16, (Object)Pair.create((Object)path, (Object)isDark), p -> RecentProjectsManagerBase.calculateIcon((String)p.first, (Boolean)p.second));
    }

    @Nullable
    protected static Icon calculateIcon(@SystemIndependent String path, boolean isDark) {
        File file2 = new File(path + (isDark ? "/.idea/icon_dark.png" : "/.idea/icon.png"));
        if (file2.exists()) {
            long timestamp = file2.lastModified();
            MyIcon icon = ourProjectIcons.get(path);
            if (icon != null && icon.getTimestamp() == timestamp) {
                return icon.getIcon();
            }
            try {
                Icon ico = RecentProjectsManagerBase.createIcon(file2);
                icon = new MyIcon(ico, timestamp);
                ourProjectIcons.put(path, icon);
                return icon.getIcon();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @NotNull
    public static Icon createIcon(File file2) {
        BufferedImage image = RecentProjectsManagerBase.loadAndScaleImage(file2);
        Icon icon = RecentProjectsManagerBase.toRetinaAwareIcon(image);
        if (icon == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @NotNull
    protected static Icon toRetinaAwareIcon(final BufferedImage image) {
        Icon icon = new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (UIUtil.isJreHiDPI()) {
                    Graphics2D newG = (Graphics2D)g.create(x, y, image.getWidth(), image.getHeight());
                    float s = JBUI.sysScale();
                    newG.scale(1.0f / s, 1.0f / s);
                    newG.drawImage((Image)image, (int)((float)x / s), (int)((float)y / s), null);
                    newG.scale(1.0, 1.0);
                    newG.dispose();
                } else {
                    g.drawImage(image, x, y, null);
                }
            }

            @Override
            public int getIconWidth() {
                return UIUtil.isJreHiDPI() ? (int)((float)image.getWidth() / JBUI.sysScale()) : image.getWidth();
            }

            @Override
            public int getIconHeight() {
                return UIUtil.isJreHiDPI() ? (int)((float)image.getHeight() / JBUI.sysScale()) : image.getHeight();
            }
        };
        if (icon == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(6);
        }
        return icon;
    }

    private static BufferedImage loadAndScaleImage(File file2) {
        try {
            Image img = ImageLoader.loadFromUrl((URL)file2.toURL());
            return Scalr.resize((BufferedImage)ImageUtil.toBufferedImage((Image)img), (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (int)(UIUtil.isRetina() ? 32 : (int)JBUI.pixScale((float)16.0f)), (BufferedImageOp[])new BufferedImageOp[0]);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static Icon getProjectOrAppIcon(String path) {
        Icon icon = RecentProjectsManagerBase.getProjectIcon(path, UIUtil.isUnderDarcula());
        if (icon != null) {
            return icon;
        }
        if (UIUtil.isUnderDarcula() && (icon = RecentProjectsManagerBase.getProjectIcon(path, false)) != null) {
            return icon;
        }
        return RecentProjectsManagerBase.getSmallApplicationIcon();
    }

    protected static Icon getSmallApplicationIcon() {
        if (ourSmallAppIcon == null) {
            try {
                Icon appIcon = ProductIcons.getInstance().getProductIcon();
                if ((float)appIcon.getIconWidth() == JBUI.pixScale((float)16.0f) && (float)appIcon.getIconHeight() == JBUI.pixScale((float)16.0f)) {
                    ourSmallAppIcon = appIcon;
                } else {
                    BufferedImage image = ImageUtil.toBufferedImage((Image)IconUtil.toImage((Icon)appIcon));
                    image = Scalr.resize((BufferedImage)image, (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (int)(UIUtil.isRetina() ? 32 : (int)JBUI.pixScale((float)16.0f)), (BufferedImageOp[])new BufferedImageOp[0]);
                    ourSmallAppIcon = RecentProjectsManagerBase.toRetinaAwareIcon(image);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ourSmallAppIcon == null) {
                ourSmallAppIcon = EmptyIcon.ICON_16;
            }
        }
        return ourSmallAppIcon;
    }

    private Set<String> getDuplicateProjectNames(Set<String> openedPaths, Set<String> recentPaths) {
        HashSet names = ContainerUtil.newHashSet();
        HashSet duplicates = ContainerUtil.newHashSet();
        for (String path : ContainerUtil.concat((Iterable[])new Iterable[]{openedPaths, recentPaths})) {
            if (names.add(this.getProjectName(path))) continue;
            duplicates.add(path);
        }
        return duplicates;
    }

    public AnAction[] getRecentProjectsActions(boolean forMainMenu) {
        return this.getRecentProjectsActions(forMainMenu, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnAction[] getRecentProjectsActions(boolean forMainMenu, boolean useGroups) {
        LinkedHashSet paths;
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.validateRecentProjects();
            paths = ContainerUtil.newLinkedHashSet(this.myState.recentPaths);
        }
        THashSet openedPaths = new THashSet();
        for (Project openProject : ProjectManager.getInstance().getOpenProjects()) {
            ContainerUtil.addIfNotNull((Collection)openedPaths, (Object)this.getProjectPath(openProject));
        }
        paths.remove(null);
        SmartList actions = new SmartList();
        Set<String> duplicates = this.getDuplicateProjectNames((Set<String>)openedPaths, paths);
        if (useGroups) {
            ArrayList<ProjectGroup> groups = new ArrayList<ProjectGroup>(new ArrayList<ProjectGroup>(this.myState.groups));
            final ArrayList projectPaths = new ArrayList(paths);
            Collections.sort(groups, new Comparator<ProjectGroup>(){

                @Override
                public int compare(ProjectGroup o1, ProjectGroup o2) {
                    int ind2;
                    int ind1 = this.getGroupIndex(o1);
                    return ind1 == (ind2 = this.getGroupIndex(o2)) ? StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName()) : ind1 - ind2;
                }

                private int getGroupIndex(ProjectGroup group) {
                    int index = Integer.MAX_VALUE;
                    for (String path : group.getProjects()) {
                        int i = projectPaths.indexOf(path);
                        if (i < 0 || index <= i) continue;
                        index = i;
                    }
                    return index;
                }
            });
            for (ProjectGroup group : groups) {
                paths.removeAll(group.getProjects());
            }
            for (ProjectGroup group : groups) {
                ArrayList<AnAction> children2 = new ArrayList<AnAction>();
                for (String path : group.getProjects()) {
                    AnAction action = this.createOpenAction(path, duplicates);
                    if (action == null) continue;
                    children2.add(action);
                    if (!forMainMenu || children2.size() < 6) continue;
                    break;
                }
                actions.add(new ProjectGroupActionGroup(group, children2));
                if (!group.isExpanded()) continue;
                for (AnAction child2 : children2) {
                    actions.add(child2);
                }
            }
        }
        for (String path : paths) {
            AnAction action = this.createOpenAction(path, duplicates);
            if (action == null) continue;
            actions.add(action);
        }
        if (actions.isEmpty()) {
            return AnAction.EMPTY_ARRAY;
        }
        return actions.toArray(AnAction.EMPTY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnAction createOpenAction(@SystemIndependent String path, Set<String> duplicates) {
        String displayName;
        String projectName = this.getProjectName(path);
        Object object = this.myStateLock;
        synchronized (object) {
            displayName = this.myState.names.get(path);
        }
        if (StringUtil.isEmptyOrSpaces((String)displayName)) {
            displayName = duplicates.contains(path) ? path : projectName;
        }
        return new ReopenProjectAction(path, projectName, displayName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markPathRecent(@SystemIndependent String path, @NotNull Project project) {
        if (project == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(7);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            if (path.endsWith(File.separator)) {
                path = path.substring(0, path.length() - File.separator.length());
            }
            this.myState.lastPath = path;
            ProjectGroup group = this.getProjectGroup(path);
            this.removePath(path);
            this.myState.recentPaths.add(0, path);
            if (group != null) {
                List projects = group.getProjects();
                projects.add(0, path);
                group.save(projects);
            }
            this.myState.additionalInfo.remove(path);
            String additionalMetadata = this.getRecentProjectMetadata(path, project);
            this.myState.additionalInfo.put(path, RecentProjectMetaInfo.create(additionalMetadata));
        }
    }

    @Nullable
    protected String getRecentProjectMetadata(@SystemIndependent String path, @NotNull Project project) {
        if (project == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(8);
        }
        return null;
    }

    @Nullable
    private ProjectGroup getProjectGroup(@SystemIndependent String path) {
        if (path == null) {
            return null;
        }
        for (ProjectGroup group : this.myState.groups) {
            if (!group.getProjects().contains(path)) continue;
            return group;
        }
        return null;
    }

    @Nullable
    protected abstract @SystemIndependent String getProjectPath(@NotNull Project var1);

    public Project doOpenProject(@NotNull @SystemIndependent String projectPath, Project projectToClose, boolean forceOpenInNewFrame) {
        VirtualFile dotIdea;
        if (projectPath == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(9);
        }
        if ((dotIdea = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(projectPath, ".idea"))) != null) {
            EnumSet<PlatformProjectOpenProcessor.Option> options = EnumSet.of(PlatformProjectOpenProcessor.Option.REOPEN);
            if (forceOpenInNewFrame) {
                options.add(PlatformProjectOpenProcessor.Option.FORCE_NEW_FRAME);
            }
            return PlatformProjectOpenProcessor.doOpenProject(dotIdea.getParent(), projectToClose, -1, null, options);
        }
        return ProjectUtil.openOrImport(projectPath, projectToClose, forceOpenInNewFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getProjectName(@NotNull String path) {
        String cached;
        if (path == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(10);
        }
        if ((cached = this.myNameCache.get(path)) != null) {
            String string = cached;
            if (string == null) {
                RecentProjectsManagerBase.$$$reportNull$$$0(11);
            }
            return string;
        }
        this.myNamesResolver.cancelAllRequests();
        Set<String> set = this.myNamesToResolve;
        synchronized (set) {
            this.myNamesToResolve.add(path);
        }
        this.myNamesResolver.addRequest(() -> {
            HashSet<String> paths;
            Set<String> set = this.myNamesToResolve;
            synchronized (set) {
                paths = new HashSet<String>(this.myNamesToResolve);
                this.myNamesToResolve.clear();
            }
            for (String p : paths) {
                this.myNameCache.put(p, RecentProjectsManagerBase.readProjectName(p));
            }
        }, 50);
        String name = new File(path).getName();
        String string = path.endsWith(".ipr") ? FileUtilRt.getNameWithoutExtension((String)name) : name;
        if (string == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(12);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readProjectName(@NotNull String path) {
        File file2;
        if (path == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(13);
        }
        if (!(file2 = new File(path)).isDirectory()) return FileUtilRt.getNameWithoutExtension((String)file2.getName());
        File nameFile = new File(new File(path, ".idea"), ".name");
        if (!nameFile.exists()) return file2.getName();
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(nameFile), CharsetToolkit.UTF8_CHARSET));){
            String name = in.readLine();
            if (StringUtil.isEmpty((String)name)) return file2.getName();
            String string = name.trim();
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file2.getName();
    }

    protected boolean willReopenProjectOnStart() {
        return GeneralSettings.getInstance().isReopenLastProject() && this.getLastProjectPath() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReopenLastProject() {
        GeneralSettings generalSettings = GeneralSettings.getInstance();
        if (generalSettings.isReopenLastProject()) {
            Set openPaths;
            boolean forceNewFrame = true;
            Iterator iterator = this.myStateLock;
            synchronized (iterator) {
                openPaths = ContainerUtil.newLinkedHashSet(this.myState.openPaths);
                if (openPaths.isEmpty()) {
                    openPaths = ContainerUtil.createMaybeSingletonSet((Object)this.myState.lastPath);
                    forceNewFrame = false;
                }
            }
            try {
                this.myBatchOpening = true;
                for (String openPath : openPaths) {
                    if (!ProjectKt.isValidProjectPath(openPath, true)) continue;
                    this.doOpenProject(openPath, null, forceNewFrame);
                }
            }
            finally {
                this.myBatchOpening = false;
            }
        }
    }

    public boolean isBatchOpening() {
        return this.myBatchOpening;
    }

    public List<ProjectGroup> getGroups() {
        return Collections.unmodifiableList(this.myState.groups);
    }

    public void addGroup(ProjectGroup group) {
        if (!this.myState.groups.contains(group)) {
            this.myState.groups.add(group);
        }
    }

    public void removeGroup(ProjectGroup group) {
        this.myState.groups.remove(group);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/RecentProjectsManagerBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/RecentProjectsManagerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateInner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toRetinaAwareIcon";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProjectDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "markPathRecent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRecentProjectMetadata";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doOpenProject";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getProjectName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readProjectName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RecentProjectMetaInfo {
        public String build;
        public String productionCode;
        public boolean eap;
        public String binFolder;
        public long projectOpenTimestamp;
        public long buildTimestamp;
        public String metadata;

        public static RecentProjectMetaInfo create(String metadata) {
            RecentProjectMetaInfo info = new RecentProjectMetaInfo();
            info.build = ApplicationInfoEx.getInstanceEx().getBuild().asString();
            info.productionCode = ApplicationInfoEx.getInstanceEx().getBuild().getProductCode();
            info.eap = ApplicationInfoEx.getInstanceEx().isEAP();
            info.binFolder = PathUtil.toSystemIndependentName((String)PathManager.getBinPath());
            info.projectOpenTimestamp = System.currentTimeMillis();
            info.buildTimestamp = ApplicationInfoEx.getInstanceEx().getBuildDate().getTimeInMillis();
            info.metadata = metadata;
            return info;
        }
    }

    private static class MyIcon
    extends Pair<Icon, Long> {
        MyIcon(Icon icon, Long timestamp) {
            super((Object)icon, (Object)timestamp);
        }

        public Icon getIcon() {
            return (Icon)this.first;
        }

        public long getTimestamp() {
            return (Long)this.second;
        }
    }

    private class MyAppLifecycleListener
    implements AppLifecycleListener {
        private MyAppLifecycleListener() {
        }

        @Override
        public void appFrameCreated(String[] commandLineArgs, @NotNull Ref<Boolean> willOpenProject) {
            if (willOpenProject == null) {
                MyAppLifecycleListener.$$$reportNull$$$0(0);
            }
            if (RecentProjectsManagerBase.this.willReopenProjectOnStart()) {
                willOpenProject.set((Object)Boolean.TRUE);
            }
        }

        @Override
        public void appStarting(Project projectFromCommandLine) {
            if (projectFromCommandLine != null || JetBrainsProtocolHandler.appStartedWithCommand()) {
                return;
            }
            RecentProjectsManagerBase.this.doReopenLastProject();
        }

        @Override
        public void projectFrameClosed() {
            RecentProjectsManagerBase.this.updateLastProjectPath();
        }

        @Override
        public void projectOpenFailed() {
            RecentProjectsManagerBase.this.updateLastProjectPath();
        }

        @Override
        public void appClosing() {
            RecentProjectsManagerBase.this.updateLastProjectPath();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "willOpenProject", "com/intellij/ide/RecentProjectsManagerBase$MyAppLifecycleListener", "appFrameCreated"));
        }
    }

    private class MyProjectListener
    implements ProjectManagerListener {
        private MyProjectListener() {
        }

        public void projectOpened(@NotNull Project project) {
            String path;
            if (project == null) {
                MyProjectListener.$$$reportNull$$$0(0);
            }
            if ((path = RecentProjectsManagerBase.this.getProjectPath(project)) != null) {
                RecentProjectsManagerBase.this.markPathRecent(path, project);
            }
            this.updateUI();
        }

        private void updateUI() {
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                SystemDock.updateMenu();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void projectClosing(@NotNull Project project) {
            String path;
            if (project == null) {
                MyProjectListener.$$$reportNull$$$0(1);
            }
            if ((path = RecentProjectsManagerBase.this.getProjectPath(project)) == null) {
                return;
            }
            Object object = RecentProjectsManagerBase.this.myStateLock;
            synchronized (object) {
                ((RecentProjectsManagerBase)RecentProjectsManagerBase.this).myState.names.put(path, RecentProjectsManagerBase.this.getProjectDisplayName(project));
            }
            RecentProjectsManagerBase.this.myNameCache.put(path, project.getName());
        }

        public void projectClosed(@NotNull Project project) {
            Project openProject;
            String path;
            Project[] openProjects;
            if (project == null) {
                MyProjectListener.$$$reportNull$$$0(2);
            }
            if ((openProjects = ProjectManager.getInstance().getOpenProjects()).length > 0 && (path = RecentProjectsManagerBase.this.getProjectPath(openProject = openProjects[openProjects.length - 1])) != null) {
                RecentProjectsManagerBase.this.markPathRecent(path, openProject);
            }
            this.updateUI();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/ide/RecentProjectsManagerBase$MyProjectListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectOpened";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectClosing";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectClosed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class State {
        public final List<String> recentPaths = new SmartList();
        public final List<String> openPaths = new SmartList();
        public final Map<String, String> names = ContainerUtil.newLinkedHashMap();
        public final List<ProjectGroup> groups = new SmartList();
        public String lastPath;
        public String pid;
        public final Map<String, RecentProjectMetaInfo> additionalInfo = ContainerUtil.newLinkedHashMap();
        public String lastProjectLocation;

        void validateRecentProjects() {
            while (this.recentPaths.remove(null)) {
            }
            Collection<String> displayNames = this.names.values();
            while (displayNames.remove("")) {
            }
            while (this.recentPaths.size() > Registry.intValue((String)"ide.max.recent.projects")) {
                int index = this.recentPaths.size() - 1;
                this.names.remove(this.recentPaths.get(index));
                this.recentPaths.remove(index);
            }
        }

        private void makePathsSystemIndependent() {
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            String version = appInfo.getMajorVersion() + "." + appInfo.getMinorVersion();
            PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)ApplicationManager.getApplication());
            Function convert = depPath -> {
                String migrated;
                String result2 = PathUtil.toSystemIndependentName((String)depPath);
                if (!result2.startsWith("$APP") && result2.contains("2017.1") && pathMacroManager.collapsePath(migrated = result2.replace("2017.1", version)).startsWith("$APP")) {
                    return migrated;
                }
                return result2;
            };
            Consumer convertList = o -> {
                ListIterator<Object> it = o.listIterator();
                while (it.hasNext()) {
                    it.set(convert.fun(it.next()));
                }
            };
            convertList.consume(this.recentPaths);
            convertList.consume(this.openPaths);
            HashMap<String, String> namesCopy = new HashMap<String, String>(this.names);
            this.names.clear();
            for (Map.Entry entry : namesCopy.entrySet()) {
                this.names.put((String)convert.fun(entry.getKey()), (String)entry.getValue());
            }
            for (ProjectGroup group : this.groups) {
                ArrayList paths = new ArrayList(group.getProjects());
                convertList.consume(paths);
                group.save(paths);
            }
            if (this.lastPath != null) {
                this.lastPath = (String)convert.fun((Object)this.lastPath);
            }
            HashMap<String, RecentProjectMetaInfo> additionalInfoCopy = new HashMap<String, RecentProjectMetaInfo>(this.additionalInfo);
            this.additionalInfo.clear();
            for (Map.Entry entry : additionalInfoCopy.entrySet()) {
                ((RecentProjectMetaInfo)entry.getValue()).binFolder = (String)convert.fun((Object)((RecentProjectMetaInfo)entry.getValue()).binFolder);
                this.additionalInfo.put((String)convert.fun(entry.getKey()), (RecentProjectMetaInfo)entry.getValue());
            }
            if (this.lastProjectLocation != null) {
                this.lastProjectLocation = (String)convert.fun((Object)this.lastProjectLocation);
            }
        }

        public void updateOpenProjectsTimestamps(RecentProjectsManagerBase mgr) {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                String path = PathUtil.toSystemIndependentName((String)mgr.getProjectPath(project));
                RecentProjectMetaInfo info = this.additionalInfo.get(path);
                if (info == null) continue;
                info.projectOpenTimestamp = System.currentTimeMillis();
            }
        }
    }
}

