/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.DaemonEditorPopup;
import com.intellij.codeInsight.daemon.impl.DaemonTooltipRendererProvider;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.daemon.impl.TrafficLightRendererContributor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.PopupHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorStripeUpdateManager {
    private final Project myProject;
    private final PsiDocumentManager myPsiDocumentManager;

    public static ErrorStripeUpdateManager getInstance(Project project) {
        return (ErrorStripeUpdateManager)ServiceManager.getService((Project)project, ErrorStripeUpdateManager.class);
    }

    public ErrorStripeUpdateManager(Project project, PsiDocumentManager psiDocumentManager) {
        this.myProject = project;
        this.myPsiDocumentManager = psiDocumentManager;
    }

    public void repaintErrorStripePanel(@NotNull Editor editor) {
        if (editor == null) {
            ErrorStripeUpdateManager.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myProject.isInitialized()) {
            return;
        }
        PsiFile file2 = this.myPsiDocumentManager.getPsiFile(editor.getDocument());
        EditorMarkupModel markup = (EditorMarkupModel)editor.getMarkupModel();
        markup.setErrorPanelPopupHandler(ErrorStripeUpdateManager.createPopup(file2));
        markup.setErrorStripTooltipRendererProvider(this.createTooltipRenderer());
        markup.setMinMarkHeight(DaemonCodeAnalyzerSettings.getInstance().ERROR_STRIPE_MARK_MIN_HEIGHT);
        this.setOrRefreshErrorStripeRenderer(markup, file2);
    }

    protected void setOrRefreshErrorStripeRenderer(@NotNull EditorMarkupModel editorMarkupModel, @Nullable PsiFile file2) {
        Editor editor;
        if (editorMarkupModel == null) {
            ErrorStripeUpdateManager.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!editorMarkupModel.isErrorStripeVisible() || !DaemonCodeAnalyzer.getInstance((Project)this.myProject).isHighlightingAvailable(file2)) {
            return;
        }
        ErrorStripeRenderer renderer = editorMarkupModel.getErrorStripeRenderer();
        if (renderer instanceof TrafficLightRenderer) {
            TrafficLightRenderer tlr = (TrafficLightRenderer)renderer;
            EditorMarkupModelImpl markupModelImpl = (EditorMarkupModelImpl)editorMarkupModel;
            tlr.refresh(markupModelImpl);
            markupModelImpl.repaintVerticalScrollBar();
            if (tlr.isValid()) {
                return;
            }
        }
        if ((editor = editorMarkupModel.getEditor()).isDisposed()) {
            return;
        }
        editorMarkupModel.setErrorStripeRenderer(this.createRenderer(editor, file2));
    }

    @NotNull
    private static PopupHandler createPopup(@Nullable PsiFile psiFile) {
        DaemonEditorPopup daemonEditorPopup = new DaemonEditorPopup(psiFile);
        if (daemonEditorPopup == null) {
            ErrorStripeUpdateManager.$$$reportNull$$$0(2);
        }
        return daemonEditorPopup;
    }

    @NotNull
    private ErrorStripTooltipRendererProvider createTooltipRenderer() {
        DaemonTooltipRendererProvider daemonTooltipRendererProvider = new DaemonTooltipRendererProvider(this.myProject);
        if (daemonTooltipRendererProvider == null) {
            ErrorStripeUpdateManager.$$$reportNull$$$0(3);
        }
        return daemonTooltipRendererProvider;
    }

    @Nullable
    protected TrafficLightRenderer createRenderer(@NotNull Editor editor, @Nullable PsiFile file2) {
        if (editor == null) {
            ErrorStripeUpdateManager.$$$reportNull$$$0(4);
        }
        for (TrafficLightRendererContributor contributor : TrafficLightRendererContributor.EP_NAME.getExtensionList()) {
            TrafficLightRenderer renderer = contributor.createRenderer(editor, file2);
            if (renderer == null) continue;
            return renderer;
        }
        return new TrafficLightRenderer(this.myProject, editor.getDocument(), file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorMarkupModel";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ErrorStripeUpdateManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ErrorStripeUpdateManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltipRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "repaintErrorStripePanel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setOrRefreshErrorStripeRenderer";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRenderer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

