/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.awt.Color;
import javax.swing.plaf.ColorUIResource;

public class ColorUtils {
    static final float OFFSET_180 = 180.0f;
    static final float OFFSET_100 = 100.0f;

    public static Color getDerivedColor(Color color, float f) {
        if (color != null) {
            float[] fArray = ColorUtils.RGBtoHSL(color);
            if ((double)fArray[2] < 0.4) {
                fArray[2] = 0.4f;
            }
            fArray[2] = (double)f > 0.5 ? (float)((double)fArray[2] + (double)((1.0f - fArray[2]) * 2.0f) * ((double)f - 0.5)) : (float)((double)fArray[2] - (double)(fArray[2] * 2.0f) * (0.5 - (double)f));
            int n = ColorUtils.HSLtoRGB(fArray);
            return new ColorUIResource(n);
        }
        return null;
    }

    public static float[] RGBtoHSL(Color color) {
        float f;
        float f2;
        float f3;
        float f4 = (float)color.getRed() / 256.0f;
        float f5 = (float)color.getGreen() / 256.0f;
        float f6 = (float)color.getBlue() / 256.0f;
        float f7 = Math.max(f4, Math.max(f5, f6));
        float f8 = Math.min(f4, Math.min(f5, f6));
        if (f4 == f5 && f5 == f6) {
            f3 = 0.0f;
            f2 = 0.0f;
            f = f4;
        } else {
            f = (f8 + f7) / 2.0f;
            f2 = (double)f < 0.5 ? (f7 - f8) / (f7 + f8) : (f7 - f8) / (2.0f - f7 - f8);
            f3 = f4 == f7 ? (f5 - f6) / (f7 - f8) : (f5 == f7 ? 2.0f + (f6 - f4) / (f7 - f8) : 4.0f + (f4 - f5) / (f7 - f8));
            if ((f3 /= 6.0f) < 0.0f) {
                f3 += 1.0f;
            }
        }
        float[] fArray = new float[]{f3, f2, f};
        return fArray;
    }

    public static int HSLtoRGB(float[] fArray) {
        float f;
        float f2;
        float f3;
        float f4 = fArray[0];
        float f5 = fArray[1];
        float f6 = fArray[2];
        if (f5 == 0.0f) {
            f2 = f3 = f6;
            f = f3;
        } else {
            float f7 = (double)f6 < 0.5 ? f6 * (1.0f + f5) : f6 + f5 - f6 * f5;
            float f8 = 2.0f * f6 - f7;
            float f9 = f4 + 0.33333334f;
            if (f9 > 1.0f) {
                f9 -= 1.0f;
            }
            float f10 = f4;
            float f11 = f4 - 0.33333334f;
            if (f11 < 0.0f) {
                f11 += 1.0f;
            }
            f = (double)f9 < 0.16666666666666666 ? f8 + (f7 - f8) * 6.0f * f9 : ((double)f9 < 0.5 ? f7 : ((double)f9 < 0.6666666666666666 ? f8 + (f7 - f8) * (0.6666667f - f9) * 6.0f : f8));
            f2 = (double)f10 < 0.16666666666666666 ? f8 + (f7 - f8) * 6.0f * f10 : ((double)f10 < 0.5 ? f7 : ((double)f10 < 0.6666666666666666 ? f8 + (f7 - f8) * (0.6666667f - f10) * 6.0f : f8));
            f3 = (double)f11 < 0.16666666666666666 ? f8 + (f7 - f8) * 6.0f * f11 : ((double)f11 < 0.5 ? f7 : ((double)f11 < 0.6666666666666666 ? f8 + (f7 - f8) * (0.6666667f - f11) * 6.0f : f8));
        }
        int n = 0;
        n += ((int)(f * 255.0f) & 0xFF) << 16;
        n += ((int)(f2 * 255.0f) & 0xFF) << 8;
        return n += (int)(f3 * 255.0f) & 0xFF;
    }

    public static int[] calculateDifferent(float[] fArray, float[] fArray2) {
        int[] nArray = new int[]{ColorUtils.floatToInteger(fArray[0], fArray2[0], 180.0f, true), ColorUtils.floatToInteger(fArray[1], fArray2[1], 100.0f, false), ColorUtils.floatToInteger(fArray[2], fArray2[2], 100.0f, false)};
        return nArray;
    }

    public static float[] applyDifference(float[] fArray, int[] nArray) {
        float[] fArray2 = new float[]{ColorUtils.integerToFloat(fArray[0], nArray[0], 180.0f, true), ColorUtils.integerToFloat(fArray[1], nArray[1], 100.0f, false), ColorUtils.integerToFloat(fArray[2], nArray[2], 100.0f, false)};
        return fArray2;
    }

    private static int floatToInteger(float f, float f2, float f3, boolean bl) {
        if (bl) {
            int n = (int)((f2 - f) * 2.0f * f3);
            if ((float)n > f3) {
                return n - (int)(2.0f * f3);
            }
            if ((float)n < -f3) {
                return n + (int)(2.0f * f3);
            }
            return n;
        }
        if (f != 0.0f) {
            return (int)((f2 - f) * f3 / f);
        }
        return (int)((f2 - f) * f3);
    }

    private static float integerToFloat(float f, int n, float f2, boolean bl) {
        if (bl) {
            float f3 = f + (float)n / (2.0f * f2);
            if (f3 < 0.0f) {
                return f3 + 1.0f;
            }
            if (f3 > 1.0f) {
                return f3 - 1.0f;
            }
            return f3;
        }
        if (n > 0) {
            return f + (1.0f - f) * (float)n / f2;
        }
        return f + f * (float)n / f2;
    }

    public static Color[] toColors(boolean bl, int ... nArray) {
        Color[] colorArray = new Color[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            colorArray[i] = new Color(nArray[i], bl);
        }
        return colorArray;
    }

    public static Color toGrayscale(Color color) {
        int n = (int)((double)color.getRed() * 0.3 + (double)color.getGreen() * 0.59 + (double)color.getBlue() * 0.11);
        return new Color(n, n, n);
    }
}

