/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.db;

import com.fasterxml.jackson.databind.JsonNode;
import com.maxmind.db.NodeCache;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;

public class CHMCache
implements NodeCache {
    private static final int DEFAULT_CAPACITY = 4096;
    private final int capacity;
    private final ConcurrentHashMap<Integer, JsonNode> cache;
    private boolean cacheFull = false;

    public CHMCache() {
        this(4096);
    }

    public CHMCache(int capacity) {
        this.capacity = capacity;
        this.cache = new ConcurrentHashMap(capacity);
    }

    @Override
    public JsonNode get(int key, NodeCache.Loader loader) throws IOException {
        Integer k = key;
        JsonNode value = this.cache.get(k);
        if (value == null) {
            value = loader.load(key);
            if (!this.cacheFull) {
                if (this.cache.size() < this.capacity) {
                    this.cache.put(k, value);
                } else {
                    this.cacheFull = true;
                }
            }
        }
        return value;
    }
}

