#!/usr/bin/env -S USE_CCACHE=false bash ../.port_include.sh

port='OpenJDK'
version='17.0.2'
workdir="jdk17u-dev-jdk-${version}-ga"
useconfigure='true'
use_fresh_config_guess='true'
config_guess_paths=("make/autoconf/build-aux/autoconf-config.guess")
use_fresh_config_sub='true'
config_sub_paths=("make/autoconf/build-aux/autoconf-config.sub")
auth_type='sha256'
files="https://github.com/openjdk/jdk17u-dev/archive/refs/tags/jdk-${version}-ga.tar.gz jdk-${version}-ga.tar.gz cb5b2a5d0916723d340f2c5bacd4607f8b8dc3a18dc8019fcfabf5306e2a4112"
depends=("fontconfig" "libffi")

configure() {
    TOOLCHAIN_ARGS=()
    WARNING_IGNORE_FLAGS='-Wno-error=switch -Wno-maybe-uninitialized'
    if [ $SERENITY_TOOLCHAIN = 'Clang' ]; then
        # We need the build CC and CXX to actually be clang when using clang to cross-compile
        #    ... for some reason.
        TOOLCHAIN_ARGS=("--with-toolchain-type=clang"
                        "BUILD_CC=clang"
                        "BUILD_CXX=clang++")
        WARNING_IGNORE_FLAGS="${WARNING_IGNORE_FLAGS} -Wno-error=bitwise-instead-of-logical"
    fi

    # Note: To use ccache with OpenJDK, pass --enable-ccache
    #     It rejects the ccache symlinks.

    run bash configure \
        AR=${AR} \
        READELF=${READELF} \
        STRIP=${STRIP} \
        CXXFILT=${CXXFILT} \
        BUILD_AR=${HOST_AR} \
        BUILD_OBJCOPY=${HOST_OBJCOPY} \
        BUILD_STRIP=${HOST_STRIP} \
        --openjdk-target=${SERENITY_ARCH}-pc-serenity \
        --with-sysroot=${SERENITY_INSTALL_ROOT} \
        --with-jvm-variants=zero \
        --enable-headless-only \
        --with-debug-level=fastdebug \
        --with-native-debug-symbols=internal \
        --with-tools-dir=${SERENITY_TOOLCHAIN_BINDIR} \
        --with-extra-cflags="${WARNING_IGNORE_FLAGS}" \
        --with-extra-cxxflags="${WARNING_IGNORE_FLAGS}" \
        "${TOOLCHAIN_ARGS[@]}"
}

build() {
    run make java.base jdk.compiler java.logging
}

install() {
    run mkdir -p ${SERENITY_INSTALL_ROOT}/usr/local/lib/jvm/
    run sh -c "cp ./build/serenity-* ${SERENITY_INSTALL_ROOT}/usr/local/lib/jvm/ -rf"
}
