"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiResizablePanelContextProvider = EuiResizablePanelContextProvider;
exports.useEuiResizablePanelContext = exports.EuiResizablePanelRegistry = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiResizablePanelRegistry = /*#__PURE__*/function () {
  function EuiResizablePanelRegistry() {
    (0, _classCallCheck2.default)(this, EuiResizablePanelRegistry);
    (0, _defineProperty2.default)(this, "panels", {});
    (0, _defineProperty2.default)(this, "resizerRefs", new Set());
  }

  (0, _createClass2.default)(EuiResizablePanelRegistry, [{
    key: "registerPanel",
    value: function registerPanel(panel) {
      this.panels[panel.id] = panel;
    }
  }, {
    key: "deregisterPanel",
    value: function deregisterPanel(id) {
      delete this.panels[id];
    }
  }, {
    key: "registerResizerRef",
    value: function registerResizerRef(resizerRef) {
      this.resizerRefs.add(resizerRef);
    }
  }, {
    key: "deregisterResizerRef",
    value: function deregisterResizerRef(resizerRef) {
      this.resizerRefs.delete(resizerRef);
    }
  }, {
    key: "getResizerSiblings",
    value: function getResizerSiblings(prevPanelId, nextPanelId) {
      return [this.panels[prevPanelId], this.panels[nextPanelId]];
    }
  }, {
    key: "getAllResizers",
    value: function getAllResizers() {
      return Array.from(this.resizerRefs);
    }
  }, {
    key: "fetchAllPanels",
    value: function fetchAllPanels(prevPanelId, nextPanelId, containerSize) {
      var panelWithSizes = {};

      for (var _key in this.panels) {
        if (_key !== prevPanelId && _key !== nextPanelId) {
          panelWithSizes[_key] = this.panels[_key].getSizePx() / containerSize * 100;
        }
      }

      return panelWithSizes;
    }
  }]);
  return EuiResizablePanelRegistry;
}();

exports.EuiResizablePanelRegistry = EuiResizablePanelRegistry;
var EuiResizablePanelContext = /*#__PURE__*/(0, _react.createContext)({});

function EuiResizablePanelContextProvider(_ref) {
  var children = _ref.children,
      registry = _ref.registry;
  return /*#__PURE__*/_react.default.createElement(EuiResizablePanelContext.Provider, {
    value: {
      registry: registry
    }
  }, children);
}

var useEuiResizablePanelContext = function useEuiResizablePanelContext() {
  var context = (0, _react.useContext)(EuiResizablePanelContext);

  if (!context.registry) {
    throw new Error('useEuiResizablePanelContext must be used within a <EuiResizablePanelContextProvider />');
  }

  return context;
};

exports.useEuiResizablePanelContext = useEuiResizablePanelContext;