/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.clsp;

import jadx.core.clsp.NMethod;
import jadx.core.dex.nodes.GenericInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NClass {
    private final String name;
    private final int id;
    private NClass[] parents;
    private Map<String, NMethod> methodsMap = Collections.emptyMap();
    private List<GenericInfo> generics = Collections.emptyList();

    public NClass(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public NClass[] getParents() {
        return this.parents;
    }

    public void setParents(NClass[] parents) {
        this.parents = parents;
    }

    public Map<String, NMethod> getMethodsMap() {
        return this.methodsMap;
    }

    public List<NMethod> getMethodsList() {
        ArrayList<NMethod> list = new ArrayList<NMethod>(this.methodsMap.size());
        list.addAll(this.methodsMap.values());
        Collections.sort(list);
        return list;
    }

    public void setMethodsMap(Map<String, NMethod> methodsMap) {
        this.methodsMap = Objects.requireNonNull(methodsMap);
    }

    public void setMethods(List<NMethod> methods) {
        HashMap<String, NMethod> map = new HashMap<String, NMethod>(methods.size());
        for (NMethod mth : methods) {
            map.put(mth.getShortId(), mth);
        }
        this.setMethodsMap(map);
    }

    public List<GenericInfo> getGenerics() {
        return this.generics;
    }

    public void setGenerics(List<GenericInfo> generics) {
        this.generics = generics;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NClass nClass = (NClass)o;
        return this.name.equals(nClass.name);
    }

    public String toString() {
        return this.name;
    }
}

