/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

public enum ResourceType {
    CODE(".dex", ".jar", ".class"),
    MANIFEST("AndroidManifest.xml"),
    XML(".xml"),
    ARSC(".arsc"),
    FONT(".ttf", ".otf"),
    IMG(".png", ".gif", ".jpg"),
    MEDIA(".mp3", ".wav"),
    LIB(".so"),
    UNKNOWN(new String[0]);

    private final String[] exts;

    private ResourceType(String ... exts) {
        this.exts = exts;
    }

    public String[] getExts() {
        return this.exts;
    }

    public static ResourceType getFileType(String fileName) {
        for (ResourceType type : ResourceType.values()) {
            for (String ext : type.getExts()) {
                if (!fileName.toLowerCase().endsWith(ext)) continue;
                return type;
            }
        }
        return UNKNOWN;
    }
}

