#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 RSA
version:              2.4.1
visibility:           public
id:                   RSA-2.4.1-9uI251vjsuo7xEIMqsvFbx
key:                  RSA-2.4.1-9uI251vjsuo7xEIMqsvFbx
license:              BSD-3-Clause
maintainer:           Adam Wick <awick@galois.com>
author:               Adam Wick <awick@galois.com>
stability:            stable
synopsis:
    Implementation of RSA, using the padding schemes of PKCS#1 v2.1.

description:
    This library implements the RSA encryption and signature
    algorithms for arbitrarily-sized ByteStrings. While the
    implementations work, they are not necessarily the fastest ones
    on the planet. Particularly key generation. The algorithms
    included are based of RFC 3447, or the Public-Key Cryptography
    Standard for RSA, version 2.1 (a.k.a, PKCS#1 v2.1).

category:             Cryptography, Codec
abi:                  d80c61bd828c659a65dda570bc1b9aff
exposed:              True
exposed-modules:
    Codec.Crypto.RSA Codec.Crypto.RSA.Exceptions Codec.Crypto.RSA.Pure

import-dirs:          /usr/lib/ghc-8.10.5/site-local/RSA-2.4.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/RSA-2.4.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/RSA-2.4.1
hs-libraries:         HSRSA-2.4.1-9uI251vjsuo7xEIMqsvFbx
depends:
    SHA-1.6.4.4-AdaX3b9QKHpD4bkKnWphTy base-4.14.2.0 binary-0.8.8.0
    bytestring-0.10.12.0 crypto-api-0.13.3-8kK7ehsYBxqIrjHyd9ebTX
    crypto-pubkey-types-0.4.3-2901LX6OzBUH0UmLEr8Lsw

haddock-interfaces:   /usr/share/doc/haskell-rsa/html/RSA.haddock
haddock-html:         /usr/share/doc/haskell-rsa/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

