#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 HsYAML
version:              0.2.1.0
visibility:           public
id:                   HsYAML-0.2.1.0-9vDKmnmJIrb8rRs1JLDnYU
key:                  HsYAML-0.2.1.0-9vDKmnmJIrb8rRs1JLDnYU
license:              GPL-2.0-only
copyright:
    2015-2018 Herbert Valerio Riedel
    , 2007-2008 Oren Ben-Kiki

maintainer:           hvr@gnu.org
author:               Herbert Valerio Riedel
homepage:             https://github.com/hvr/HsYAML
synopsis:             Pure Haskell YAML 1.2 processor
description:
    @HsYAML@ is a [YAML 1.2](http://yaml.org/spec/1.2/spec.html) processor, i.e. a library for parsing and serializing YAML documents.

    Features of @HsYAML@ include:

    * Pure Haskell implementation with small dependency footprint and emphasis on strict compliance with the [YAML 1.2 specification](http://yaml.org/spec/1.2/spec.html).
    * Direct decoding to native Haskell types via (@aeson@-inspired) typeclass-based API (see "Data.YAML").
    * Allows round-tripping while preserving ordering, anchors, and comments at Event-level.
    * Support for constructing custom YAML node graph representation (including support for cyclic YAML data structures).
    * Support for the standard (untyped) /Failsafe/, (strict) /JSON/, and (flexible) /Core/ \"schemas\" providing implicit typing rules as defined in the YAML 1.2 specification (including support for user-defined custom schemas; see "Data.YAML.Schema").
    * Support for emitting YAML using /Failsafe/, (strict) /JSON/, and (flexible) /Core/ \"schemas\" (including support for user-defined custom encoding schemas; see "Data.YAML.Schema").
    * Event-based API resembling LibYAML'\''s Event-based API (see "Data.YAML.Event").
    * Low-level API access to lexical token-based scanner (see "Data.YAML.Token").

    See also the <//hackage.haskell.org/package/HsYAML-aeson HsYAML-aeson> package which allows to decode and encode YAML by leveraging @aeson@'\''s '\''FromJSON'\'' and '\''ToJSON'\'' instances.

category:             Text
abi:                  be339ca64d6dd7abbc2f9f1979b7240e
exposed:              True
exposed-modules:
    Data.YAML Data.YAML.Event Data.YAML.Schema Data.YAML.Token

hidden-modules:
    Data.YAML.Loader Data.YAML.Dumper Data.YAML.Internal
    Data.YAML.Event.Internal Data.YAML.Event.Writer Data.YAML.Pos
    Data.YAML.Schema.Internal Data.YAML.Token.Encoding Util Data.DList

import-dirs:          /usr/lib/ghc-8.10.5/site-local/HsYAML-0.2.1.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/HsYAML-0.2.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/HsYAML-0.2.1.0
hs-libraries:         HSHsYAML-0.2.1.0-9vDKmnmJIrb8rRs1JLDnYU
depends:
    base-4.14.2.0 bytestring-0.10.12.0 containers-0.6.4.1
    deepseq-1.4.4.0 mtl-2.2.2 parsec-3.1.14.0 text-1.2.4.1

haddock-interfaces:   /usr/share/doc/haskell-hsyaml/html/HsYAML.haddock
haddock-html:         /usr/share/doc/haskell-hsyaml/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

