/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Collections;
import java.util.Set;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.JvmProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;

public abstract class GroovyProjectInitDescriptor
extends JvmProjectInitDescriptor {
    private final DocumentationRegistry documentationRegistry;

    public GroovyProjectInitDescriptor(BuildScriptBuilderFactory scriptBuilderFactory, TemplateOperationFactory templateOperationFactory, FileResolver fileResolver, TemplateLibraryVersionProvider libraryVersionProvider, DocumentationRegistry documentationRegistry) {
        super("groovy", scriptBuilderFactory, templateOperationFactory, fileResolver, libraryVersionProvider);
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    protected void generate(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        super.generate(settings, buildScriptBuilder);
        buildScriptBuilder.fileComment("This generated file contains a sample Groovy project to get you started.").fileComment("For more details take a look at the Groovy Quickstart chapter in the Gradle").fileComment("User Manual available at " + this.documentationRegistry.getDocumentationFor("tutorial_groovy_projects")).plugin("Apply the groovy plugin to add support for Groovy", "groovy").implementationDependency("Use the latest Groovy version for building this library", "org.codehaus.groovy:groovy-all:" + this.libraryVersionProvider.getVersion("groovy")).testImplementationDependency("Use the awesome Spock testing and specification framework", "org.spockframework:spock-core:" + this.libraryVersionProvider.getVersion("spock"));
        this.configureBuildScript(settings, buildScriptBuilder);
        TemplateOperation sourceTemplate = this.sourceTemplateOperation(settings);
        TemplateOperation testSourceTemplate = this.testTemplateOperation(settings);
        this.whenNoSourcesAvailable(sourceTemplate, testSourceTemplate).generate();
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework() {
        return BuildInitTestFramework.SPOCK;
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks() {
        return Collections.singleton(BuildInitTestFramework.SPOCK);
    }

    protected abstract TemplateOperation sourceTemplateOperation(InitSettings var1);

    protected abstract TemplateOperation testTemplateOperation(InitSettings var1);

    protected void configureBuildScript(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
    }
}

